/* server functions auto-generated by pidl */
#include "autoconf/librpc/gen_ndr/ndr_rot.h"

NTSTATUS dcerpc_server_rot_init(void);

/* rot - dcerpc server boilerplate generated by pidl */


static NTSTATUS rot__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_ROT_BIND
	return DCESRV_INTERFACE_ROT_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void rot__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_ROT_UNBIND
	DCESRV_INTERFACE_ROT_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS rot__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_rot.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_rot.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_rot.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_rot.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_rot, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS rot__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct rot_add *r2 = (struct rot_add *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(rot_add, NDR_IN, r2);
		}
		r2->out.result = dcesrv_rot_add(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_add will reply async\n"));
		}
		break;
	}
	case 1: {
		struct rot_remove *r2 = (struct rot_remove *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(rot_remove, NDR_IN, r2);
		}
		r2->out.result = dcesrv_rot_remove(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_remove will reply async\n"));
		}
		break;
	}
	case 2: {
		struct rot_is_listed *r2 = (struct rot_is_listed *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(rot_is_listed, NDR_IN, r2);
		}
		r2->out.result = dcesrv_rot_is_listed(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_is_listed will reply async\n"));
		}
		break;
	}
	case 3: {
		struct rot_get_interface_pointer *r2 = (struct rot_get_interface_pointer *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(rot_get_interface_pointer, NDR_IN, r2);
		}
		r2->out.result = dcesrv_rot_get_interface_pointer(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_get_interface_pointer will reply async\n"));
		}
		break;
	}
	case 4: {
		struct rot_set_modification_time *r2 = (struct rot_set_modification_time *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(rot_set_modification_time, NDR_IN, r2);
		}
		r2->out.result = dcesrv_rot_set_modification_time(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_set_modification_time will reply async\n"));
		}
		break;
	}
	case 5: {
		struct rot_get_modification_time *r2 = (struct rot_get_modification_time *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(rot_get_modification_time, NDR_IN, r2);
		}
		r2->out.result = dcesrv_rot_get_modification_time(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_get_modification_time will reply async\n"));
		}
		break;
	}
	case 6: {
		struct rot_enum *r2 = (struct rot_enum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(rot_enum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_rot_enum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_enum will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_rot, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS rot__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct rot_add *r2 = (struct rot_add *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_add replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(rot_add, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in rot_add\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct rot_remove *r2 = (struct rot_remove *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_remove replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(rot_remove, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in rot_remove\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct rot_is_listed *r2 = (struct rot_is_listed *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_is_listed replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(rot_is_listed, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in rot_is_listed\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct rot_get_interface_pointer *r2 = (struct rot_get_interface_pointer *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_get_interface_pointer replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(rot_get_interface_pointer, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in rot_get_interface_pointer\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct rot_set_modification_time *r2 = (struct rot_set_modification_time *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_set_modification_time replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(rot_set_modification_time, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in rot_set_modification_time\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct rot_get_modification_time *r2 = (struct rot_get_modification_time *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_get_modification_time replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(rot_get_modification_time, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in rot_get_modification_time\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct rot_enum *r2 = (struct rot_enum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function rot_enum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(rot_enum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in rot_enum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_rot, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS rot__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_rot.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_rot_interface = {
	.name		= "rot",
	.syntax_id  = {{0xb9e79e60,0x3d52,0x11ce,{0xaa,0xa1},{0x00,0x00,0x69,0x01,0x29,0x3f}},131072},
	.bind		= rot__op_bind,
	.unbind		= rot__op_unbind,
	.ndr_pull	= rot__op_ndr_pull,
	.dispatch	= rot__op_dispatch,
	.reply		= rot__op_reply,
	.ndr_push	= rot__op_ndr_push
};


static NTSTATUS rot__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_rot.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_rot.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_rot_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("rot_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool rot__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_rot_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_rot_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_rot_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool rot__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_rot_interface.name, name)==0) {
		memcpy(iface, &dcesrv_rot_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_rot_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "rot";

	/* fill in all the operations */
	ep_server.init_server = rot__op_init_server;

	ep_server.interface_by_uuid = rot__op_interface_by_uuid;
	ep_server.interface_by_name = rot__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'rot' endpoint server!\n"));
		return ret;
	}

	return ret;
}

