#! /bin/sh

# $NetBSD: t_netpgpkeys.sh,v 1.3 2026/01/31 22:35:10 wiz Exp $

#
# Copyright (c) 2026 The NetBSD Foundation, Inc.
# All rights reserved.
#
# This code is derived from software contributed to The NetBSD Foundation
# by Thomas Klausner <wiz@NetBSD.org>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
# AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

cleanup_core() {
	local prog

	prog=$1
	test -f "${prog}.core" || return 0
	readelf -rs "/usr/bin/${prog}"
	gdb -batch -ex bt -ex 'info registers' -ex disas \
	    "/usr/bin/${prog}" "${prog}.core"
}

# Test set 1 (rsa key) for netpgpkeys
atf_test_case netpgpkeys_testset_1_rsa_keys

netpgpkeys_testset_1_rsa_keys_head() {
	atf_set "descr" "Test set 1 (rsa_keys) for netpgpkeys"
}
netpgpkeys_testset_1_rsa_keys_body() {
	atf_expect_fail "PR bin/59936 - does not support keys generated by gnugp2"
	# TODO: fix netpgpkeys so it doesn't need an empty keyring
	atf_check touch pubring.gpg
	atf_check netpgpkeys --keyring pubring.gpg \
		  --import-key "$(atf_get_srcdir)"/data/testkey-rsa.pub
}

# Test set 2 (elliptic curve keys) for netpgpkeys
atf_test_case netpgpkeys_testset_2_ec_keys cleanup

netpgpkeys_testset_2_ec_keys_head() {
	atf_set "descr" "Test set 2 (ec_keys) for netpgpkeys"
}
netpgpkeys_testset_2_ec_keys_body() {
	atf_expect_fail "PR bin/59936 - does not support keys generated by gnugp2 - dumps core for EC keys"
	# TODO: fix netpgpkeys so it doesn't need an empty keyring
	atf_check touch pubring.gpg
	atf_check netpgpkeys --keyring pubring.gpg \
		  --import-key "$(atf_get_srcdir)"/data/testkey-ec.pub \
		  --coredumps
}

netpgpkeys_testset_2_ec_keys_cleanup() {
	cleanup_core netpgpkeys
}

# all test sets
atf_init_test_cases() {
	atf_add_test_case netpgpkeys_testset_1_rsa_keys
	atf_add_test_case netpgpkeys_testset_2_ec_keys
}
