/*-
 * Copyright (c) 1998, 2001 Nicolas Souchu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/5/sys/dev/bktr/bktr_i2c.h 93023 2002-03-23 15:49:15Z nsouch $
 *
 */
#ifndef _BT848_I2C_H
#define _BT848_I2C_H

extern int bt848_i2c_attach(device_t);
extern int bt848_i2c_detach(device_t);

extern int bti2c_iic_callback(device_t, int, caddr_t *);
extern void bti2c_iic_setsda(device_t, int);
extern void bti2c_iic_setscl(device_t, int);
extern int bti2c_iic_getsda(device_t);
extern int bti2c_iic_getscl(device_t);
extern int bti2c_iic_reset(device_t, u_char, u_char, u_char *);

extern int bti2c_smb_callback(device_t, int, caddr_t *);
extern int bti2c_smb_writeb(device_t dev, u_char slave, char cmd, char byte);
extern int bti2c_smb_writew(device_t dev, u_char slave, char cmd, short word);
extern int bti2c_smb_readb(device_t dev, u_char slave, char cmd, char *byte);

#endif
