import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

/**
 * This code was edited or generated using CloudGarden's Jigloo SWT/Swing GUI
 * Builder, which is free for non-commercial use. If Jigloo is being used
 * commercially (ie, by a corporation, company or business for any purpose
 * whatever) then you should purchase a license for each developer using Jigloo.
 * Please visit www.cloudgarden.com for details. Use of Jigloo implies
 * acceptance of these licensing terms. A COMMERCIAL LICENSE HAS NOT BEEN
 * PURCHASED FOR THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED LEGALLY FOR
 * ANY CORPORATE OR COMMERCIAL PURPOSE.
 */
public class NewJFrame extends javax.swing.JFrame {

	private JPanel jPfontsize;
	private JRadioButton jRlandscape;
	private JLabel jLheight_of_a_box;
	private JLabel jLwidth_of_structogram;
	private JLabel jLpath_absolute;
	private JLabel jLpath;
	private JPanel jPPath;
	private JButton jBok;
	private JButton jBloaddefaults;
	private JPanel jPButtons;
	private JCheckBox jChsavesettings;
	private ButtonGroup buttonGroupfont;
	private ButtonGroup buttonGrouporientation;
	private JTextField jTheightofabox;
	private JTextField jTwidthofstructogram;
	private JPanel jPsize;
	private JRadioButton jRportrait;
	private JLabel jLorientation;
	private JRadioButton jRHuge;
	private JRadioButton jRhuge;
	private JRadioButton jRLarge;
	private JRadioButton jRlarge;
	private JRadioButton jRnormalsize;
	private JRadioButton jRsmall;
	private JLabel jLfontsize;
	private JPanel jPorientation;
	private Properties properties;
	private int height_of_a_box;
	private int width_of_a_structogram;
	private String font_height;
	private String path_absolute;
	private String orientation;
	private Keyword_reader main_class;

	public NewJFrame() {
		super();
		properties = new Properties();
		read_settings();
		height_of_a_box = new Integer(properties.getProperty("height"));
		width_of_a_structogram = new Integer(properties.getProperty("width"));
		orientation = properties.getProperty("orientation");
		font_height = properties.getProperty("size");
		path_absolute = properties.getProperty("path");
		initGUI();
		set_settings_GUI();
		jBok.requestFocusInWindow();
	}

	private void initGUI() {
		try {
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			getContentPane().setLayout(null);
			{
				jPfontsize = new JPanel();
				GridLayout jPfontsizeLayout = new GridLayout(7, 1);
				jPfontsizeLayout.setColumns(1);
				jPfontsizeLayout.setHgap(5);
				jPfontsizeLayout.setVgap(5);
				jPfontsizeLayout.setRows(7);
				jPfontsize.setLayout(jPfontsizeLayout);
				getContentPane().add(jPfontsize);
				jPfontsize.setBounds(12, 5, 128, 160);
				{
					jLfontsize = new JLabel();
					jPfontsize.add(jLfontsize);
					jLfontsize.setText("font size:");
					jLfontsize.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jRsmall = new JRadioButton();
					jPfontsize.add(jRsmall);
					jRsmall.setText("small");
					getButtonGroupfont().add(jRsmall);
					jRsmall.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jRnormalsize = new JRadioButton();
					jPfontsize.add(jRnormalsize);
					jRnormalsize.setText("normalsize");
					getButtonGroupfont().add(jRnormalsize);
					jRnormalsize.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jRlarge = new JRadioButton();
					jPfontsize.add(jRlarge);
					jRlarge.setText("large");
					getButtonGroupfont().add(jRlarge);
					jRlarge.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jRLarge = new JRadioButton();
					jPfontsize.add(jRLarge);
					jRLarge.setText("Large");
					getButtonGroupfont().add(jRLarge);
					jRLarge.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jRhuge = new JRadioButton();
					jPfontsize.add(jRhuge);
					jRhuge.setText("huge #Beamer");
					getButtonGroupfont().add(jRhuge);
					jRhuge.setFont(new java.awt.Font("Tahoma", 1, 14));
					jRhuge.setSelected(true);
					jRhuge.setPreferredSize(new java.awt.Dimension(134, 19));
				}
				{
					jRHuge = new JRadioButton();
					jPfontsize.add(jRHuge);
					jRHuge.setText("Huge");
					getButtonGroupfont().add(jRHuge);
					jRHuge.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
			}
			{
				jPorientation = new JPanel();
				GridLayout jPorientationLayout = new GridLayout(3, 1);
				jPorientationLayout.setColumns(1);
				jPorientationLayout.setHgap(5);
				jPorientationLayout.setVgap(5);
				jPorientationLayout.setRows(3);
				getContentPane().add(jPorientation);
				jPorientation.setBounds(154, 6, 120, 63);
				jPorientation.setLayout(jPorientationLayout);
				{
					jLorientation = new JLabel();
					jPorientation.add(jLorientation);
					jLorientation.setText("orientation:");
					jLorientation.setPreferredSize(new java.awt.Dimension(34,
							14));
					jLorientation.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jRlandscape = new JRadioButton();
					jPorientation.add(jRlandscape);
					jRlandscape.setText("landscape");
					getButtonGrouporientation().add(jRlandscape);
					jRlandscape.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jRportrait = new JRadioButton();
					jPorientation.add(jRportrait);
					jRportrait.setText("portrait");
					getButtonGrouporientation().add(jRportrait);
					jRportrait.setFont(new java.awt.Font("Tahoma", 1, 14));
					jRportrait.setSelected(true);
				}
			}
			{
				jPsize = new JPanel();
				GridBagLayout jPsizelayout = new GridBagLayout();
				jPsizelayout.rowWeights = new double[] { 0.1, 0.1, 0.1 };
				jPsizelayout.rowHeights = new int[] { 20, 20, 20 };
				jPsizelayout.columnWeights = new double[] { 0.0, 0.1 };
				jPsizelayout.columnWidths = new int[] { 197, 7 };
				jPsize.setLayout(jPsizelayout);
				getContentPane().add(jPsize);
				getContentPane().add(getJPButtons());
				getContentPane().add(getJPPath());
				jPsize.setBounds(280, 6, 261, 63);
				{
					jLheight_of_a_box = new JLabel();
					jPsize.add(jLheight_of_a_box, new GridBagConstraints(0, 0,
							1, 1, 0.0, 0.0, GridBagConstraints.WEST,
							GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0,
							0));
					jLheight_of_a_box.setText("height of a box:");
					jLheight_of_a_box
							.setFont(new java.awt.Font("Tahoma", 1, 14));
				}
				{
					jTheightofabox = new JTextField();
					jPsize.add(jTheightofabox, new GridBagConstraints(1, 0, 1,
							1, 0.0, 0.0, GridBagConstraints.WEST,
							GridBagConstraints.NONE, new Insets(0, 0, 0, 0),
							30, 0));
					jTheightofabox.setText("");
					jTheightofabox.setFont(new java.awt.Font("Tahoma", 1, 14));
					jTheightofabox.setPreferredSize(new java.awt.Dimension(44,
							24));
					jTheightofabox
							.setHorizontalAlignment(SwingConstants.TRAILING);
					jTheightofabox.setSize(44, 20);
				}
				{
					jLwidth_of_structogram = new JLabel();
					jPsize.add(jLwidth_of_structogram, new GridBagConstraints(
							0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST,
							GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0,
							0));
					jLwidth_of_structogram.setText("width of the structogram:");
					jLwidth_of_structogram.setFont(new java.awt.Font("Tahoma",
							1, 14));
				}
				{
					jTwidthofstructogram = new JTextField();
					jPsize.add(jTwidthofstructogram, new GridBagConstraints(1,
							1, 2, 1, 0.0, 0.0, GridBagConstraints.WEST,
							GridBagConstraints.NONE, new Insets(0, 0, 0, 0),
							30, 0));
					jTwidthofstructogram.setText("");
					jTwidthofstructogram.setFont(new java.awt.Font("Tahoma", 1,
							14));
					jTwidthofstructogram
							.setPreferredSize(new java.awt.Dimension(44, 24));
					jTwidthofstructogram
							.setHorizontalAlignment(SwingConstants.TRAILING);
					jTwidthofstructogram.setSize(44, 24);
				}
				{
					jChsavesettings = new JCheckBox();
					jPsize.add(jChsavesettings, new GridBagConstraints(0, 2, 1,
							1, 0.0, 0.0, GridBagConstraints.WEST,
							GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0,
							0));
					jChsavesettings.setText("save settings:");
					jChsavesettings.setFont(new java.awt.Font("Tahoma", 1, 14));
					jChsavesettings
							.setHorizontalTextPosition(SwingConstants.LEADING);
				}
			}
			pack();
			jBok.requestFocusInWindow();
			this.setSize(570, 215);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private ButtonGroup getButtonGroupfont() {
		if (buttonGroupfont == null) {
			buttonGroupfont = new ButtonGroup();
		}
		return buttonGroupfont;
	}

	private JPanel getJPButtons() {
		if (jPButtons == null) {
			jPButtons = new JPanel();
			GridLayout jPButtonsLayout = new GridLayout(1, 1);
			jPButtonsLayout.setColumns(2);
			jPButtonsLayout.setHgap(5);
			jPButtonsLayout.setVgap(5);
			jPButtons.setLayout(jPButtonsLayout);
			jPButtons.setBounds(156, 130, 385, 35);
			jPButtons.add(getJBloaddefaults());
			jPButtons.add(getJBok());
		}
		return jPButtons;
	}

	private JButton getJBloaddefaults() {
		if (jBloaddefaults == null) {
			jBloaddefaults = new JButton();
			jBloaddefaults.setText("load beamer defaults");
			jBloaddefaults.setFont(new java.awt.Font("Tahoma", 1, 14));
			jBloaddefaults.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					jBloaddefaultsActionPerformed(evt);
				}
			});
		}
		return jBloaddefaults;
	}

	private JButton getJBok() {
		if (jBok == null) {
			jBok = new JButton();
			jBok.setText("ok");
			jBok.setFont(new java.awt.Font("Tahoma", 1, 14));
			jBok.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					jBokActionPerformed(evt);
				}
			});
		}
		return jBok;
	}

	private JPanel getJPPath() {
		if (jPPath == null) {
			jPPath = new JPanel();
			GridBagLayout jPPathLayout = new GridBagLayout();
			jPPath.setBounds(157, 81, 385, 25);
			jPPathLayout.rowWeights = new double[] { 0.1 };
			jPPathLayout.rowHeights = new int[] { 7 };
			jPPathLayout.columnWeights = new double[] { 0.0, 0.1 };
			jPPathLayout.columnWidths = new int[] { 43, 250 };
			jPPath.setLayout(jPPathLayout);
			jPPath.add(getJLpath(), new GridBagConstraints(0, 0, 1, 1, 0.0,
					0.0, GridBagConstraints.WEST, GridBagConstraints.NONE,
					new Insets(0, 0, 0, 0), 0, 0));
			jPPath.add(getJLpath_absolute(), new GridBagConstraints(1, 0, 1, 1,
					0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE,
					new Insets(0, 0, 0, 0), 0, 0));
		}
		return jPPath;
	}

	private JLabel getJLpath() {
		if (jLpath == null) {
			jLpath = new JLabel();
			jLpath.setText("path:");
			jLpath.setFont(new java.awt.Font("Tahoma", 1, 14));
		}
		return jLpath;
	}

	private JLabel getJLpath_absolute() {
		if (jLpath_absolute == null) {
			jLpath_absolute = new JLabel();
			jLpath_absolute.setText(path_absolute);
			jLpath_absolute.setFont(new java.awt.Font("Tahoma", 1, 14));
		}
		return jLpath_absolute;
	}

	private ButtonGroup getButtonGrouporientation() {
		if (buttonGrouporientation == null) {
			buttonGrouporientation = new ButtonGroup();
		}
		return buttonGrouporientation;
	}

	private void read_settings() {
		BufferedInputStream stream = null;
		try {
			stream = new BufferedInputStream(new FileInputStream(
					"start.properties"));
		} catch (FileNotFoundException e) {
			NewJDialog dialog = new NewJDialog(this,
					"file start.properties not found");
			dialog.setVisible(true);
			e.printStackTrace();
		}
		try {
			properties.load(stream);
			stream.close();
		} catch (IOException e) {
			new NewJDialog(this, "file start.properties not found");
		}
	}

	private void save_settings() {
		BufferedOutputStream stream = null;
		try {
			stream = new BufferedOutputStream(new FileOutputStream(
					"start.properties"));
		} catch (FileNotFoundException e) {
			NewJDialog dialog = new NewJDialog(this,
					"Error writing start.properties file");
			dialog.setVisible(true);
			e.printStackTrace();
		}
		try {
			properties
					.store(stream,
							"height - height of a box\r\n#width - width of the structogram\r\n#orientation\r\n#size - font size\r\n#path - last path from reading the file");
			stream.close();
		} catch (IOException e) {
			NewJDialog dialog = new NewJDialog(this,
					"Error writing start.properties file");
			dialog.setVisible(true);
			e.printStackTrace();
		}
	}

	private void set_settings_GUI() {
		jTheightofabox.setText("" + height_of_a_box);
		jTwidthofstructogram.setText("" + width_of_a_structogram);
		AbstractButton b;
		for (Enumeration<AbstractButton> e = buttonGroupfont.getElements(); e
				.hasMoreElements();) {
			b = e.nextElement();
			if (b.getText().equals(font_height)) {
				b.setSelected(true);
			}
		}
		for (Enumeration<AbstractButton> e = buttonGrouporientation
				.getElements(); e.hasMoreElements();) {
			b = e.nextElement();
			if (b.isSelected()) {
				properties.setProperty("orientation", b.getText());
			}
			if (b.getText().equals(orientation)) {
				b.setSelected(true);
			}
		}
	}

	private void read_settings_from_GUI() {
		try {
			height_of_a_box = new Integer(jTheightofabox.getText());
		} catch (NumberFormatException e) {
			height_of_a_box = 20;
		}
		if ((height_of_a_box > 80) || (height_of_a_box < 2)) {
			height_of_a_box = 20;
		}
		jTheightofabox.setText("" + height_of_a_box);
		properties.setProperty("height", "" + height_of_a_box);
		try {
			width_of_a_structogram = new Integer(jTwidthofstructogram.getText());
		} catch (NumberFormatException e) {
			width_of_a_structogram = 20;
		}
		if ((width_of_a_structogram > 240) || (width_of_a_structogram < 80)) {
			width_of_a_structogram = 80;
		}
		jTwidthofstructogram.setText("" + width_of_a_structogram);
		properties.setProperty("width", "" + width_of_a_structogram);
		AbstractButton b;
		for (Enumeration<AbstractButton> e = buttonGroupfont.getElements(); e
				.hasMoreElements();) {
			b = e.nextElement();
			if (b.isSelected()) {
				properties.setProperty("size", b.getText());
			}
		}
		font_height = properties.getProperty("size");
		for (Enumeration<AbstractButton> e = buttonGrouporientation
				.getElements(); e.hasMoreElements();) {
			b = e.nextElement();
			if (b.isSelected()) {
				properties.setProperty("orientation", b.getText());
			}
		}

	}

	private void jBloaddefaultsActionPerformed(ActionEvent evt) {
		jRhuge.setSelected(true);
		jRportrait.setSelected(true);
		jTheightofabox.setText("20");
		jTwidthofstructogram.setText("180");
	}

	private void jBokActionPerformed(ActionEvent evt) {
		String f_h;
		read_settings_from_GUI();
		if (jChsavesettings.isSelected()) {
			save_settings();
		}
		main_class = new Keyword_reader(height_of_a_box, width_of_a_structogram);
		if ((path_absolute = main_class.read_file(this, path_absolute)) != null) {
			if (jChsavesettings.isSelected()) {
				properties.setProperty("path", path_absolute);
				save_settings();
			}
			main_class.mastermethod();
			if (font_height.equals("huge #Beamer")) {
				f_h = font_height.substring(0, font_height.indexOf(" "));
			} else {
				f_h = font_height;
			}
			main_class.store_file(this, path_absolute, jRportrait.isSelected(),
					f_h);
		}
	}
}
