/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.FluentIntrospectionTestBean;
import org.apache.commons.beanutils2.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira456Test {
    private static final String TEST_PROP = "fluentGetProperty";
    private PropertyUtilsBean pub;

    private FluentIntrospectionTestBean clearWriteMethodRef() throws Exception {
        FluentIntrospectionTestBean bean = new FluentIntrospectionTestBean();
        PropertyDescriptor pd = this.pub.getPropertyDescriptor((Object)bean, TEST_PROP);
        pd.setWriteMethod(null);
        return bean;
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.pub = new PropertyUtilsBean();
        this.pub.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
    }

    @Test
    public void testPropertyIsWritable() throws Exception {
        FluentIntrospectionTestBean bean = this.clearWriteMethodRef();
        Assertions.assertTrue((boolean)this.pub.isWriteable((Object)bean, TEST_PROP), (String)"Not writable");
    }

    @Test
    public void testWriteMethodRecover() throws Exception {
        FluentIntrospectionTestBean bean = this.clearWriteMethodRef();
        String value = "Test value";
        this.pub.setProperty((Object)bean, TEST_PROP, (Object)"Test value");
        Assertions.assertEquals((Object)"Test value", (Object)bean.getFluentGetProperty(), (String)"Property not set");
    }
}

