/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;

class KllDirectFloatsSketch
extends KllFloatsSketch {
    private MemorySegment wseg;
    private final MemorySegmentRequest mSegReq;

    KllDirectFloatsSketch(MemorySegment wseg, KllMemorySegmentValidate segVal, MemorySegmentRequest mSegmentRequest) {
        super(segVal);
        this.wseg = wseg;
        this.mSegReq = mSegmentRequest;
    }

    static KllDirectFloatsSketch newDirectUpdatableInstance(int k, int m, MemorySegment dstSeg, MemorySegmentRequest mSegmentRequest) {
        KllPreambleUtil.setMemorySegmentPreInts(dstSeg, KllSketch.SketchStructure.UPDATABLE.getPreInts());
        KllPreambleUtil.setMemorySegmentSerVer(dstSeg, KllSketch.SketchStructure.UPDATABLE.getSerVer());
        KllPreambleUtil.setMemorySegmentFamilyID(dstSeg, Family.KLL.getID());
        KllPreambleUtil.setMemorySegmentK(dstSeg, k);
        KllPreambleUtil.setMemorySegmentM(dstSeg, m);
        KllPreambleUtil.setMemorySegmentN(dstSeg, 0L);
        KllPreambleUtil.setMemorySegmentMinK(dstSeg, k);
        KllPreambleUtil.setMemorySegmentNumLevels(dstSeg, 1);
        int offset = 20;
        MemorySegment.copy(new int[]{k, k}, 0, dstSeg, ValueLayout.JAVA_INT_UNALIGNED, (long)offset, 2);
        MemorySegment.copy(new float[]{Float.NaN, Float.NaN}, 0, dstSeg, ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offset += 8), 2);
        MemorySegment.copy(new float[k], 0, dstSeg, ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offset += 8), k);
        KllMemorySegmentValidate segVal = new KllMemorySegmentValidate(dstSeg, KllSketch.SketchType.KLL_FLOATS_SKETCH, null);
        MemorySegment wSeg = dstSeg;
        return new KllDirectFloatsSketch(wSeg, segVal, mSegmentRequest);
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "NaN";
        }
        return Float.toString(this.getFloatItemsArray()[index]);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemorySegmentK(this.wseg);
    }

    @Override
    public float getMaxItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 4;
        return this.wseg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset);
    }

    @Override
    float getMaxItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Float.NaN;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 4;
        return this.wseg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset);
    }

    @Override
    String getMaxItemAsString() {
        float maxItem = this.getMaxItemInternal();
        return Float.toString(maxItem);
    }

    @Override
    public float getMinItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wseg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset);
    }

    @Override
    float getMinItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Float.NaN;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wseg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset);
    }

    @Override
    String getMinItemAsString() {
        float minItem = this.getMinItemInternal();
        return Float.toString(minItem);
    }

    @Override
    void setMaxItem(float item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 4;
        this.wseg.set(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset, item);
    }

    @Override
    void setMinItem(float item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wseg.set(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset, item);
    }

    @Override
    public long getN() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return 0L;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return 1L;
        }
        return KllPreambleUtil.getMemorySegmentN(this.wseg);
    }

    @Override
    float[] getFloatItemsArray() {
        int k = this.getK();
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new float[k];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            float[] itemsArr = new float[k];
            itemsArr[k - 1] = this.getFloatSingleItem();
            return itemsArr;
        }
        int capacityItems = KllHelper.computeTotalItemCapacity(k, this.getM(), this.getNumLevels());
        float[] floatItemsArr = new float[capacityItems];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        int shift = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.levelsArr[0] : 0;
        int numItems = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.getNumRetained() : capacityItems;
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_FLOAT_UNALIGNED, offset, floatItemsArr, shift, numItems);
        return floatItemsArr;
    }

    @Override
    float[] getFloatRetainedItemsArray() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new float[0];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return new float[]{this.getFloatSingleItem()};
        }
        int numRetained = this.getNumRetained();
        float[] floatItemsArr = new float[numRetained];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8 + (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 0 : this.levelsArr[0] * 4);
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_FLOAT_UNALIGNED, offset, floatItemsArr, 0, numRetained);
        return floatItemsArr;
    }

    @Override
    float getFloatSingleItem() {
        if (!this.isSingleItem()) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.wseg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 8L);
        }
        int offset = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8 : 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (2 + this.getK() - 1) * 4;
        return this.wseg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset);
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemorySegmentM(this.wseg);
    }

    @Override
    MemorySegmentRequest getMemorySegmentRequest() {
        return this.mSegReq;
    }

    @Override
    int getMinK() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL || this.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            return KllPreambleUtil.getMemorySegmentMinK(this.wseg);
        }
        return this.getK();
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] bytesOut = new byte[8];
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            ByteArrayUtil.putFloatLE(bytesOut, 0, Float.NaN);
            ByteArrayUtil.putFloatLE(bytesOut, 4, Float.NaN);
            return bytesOut;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            int offset = 8;
            MemorySegment.copy(this.wseg, ValueLayout.JAVA_BYTE, offset, bytesOut, 0, 4);
            ByteArrayUtil.copyBytes(bytesOut, 0, bytesOut, 4, 4);
            return bytesOut;
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_BYTE, offset, bytesOut, 0, 4);
        MemorySegment.copy(this.wseg, ValueLayout.JAVA_BYTE, offset + 4, bytesOut, 4, 4);
        return bytesOut;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new byte[0];
        }
        float[] fltArr = this.getFloatRetainedItemsArray();
        byte[] fltByteArr = new byte[fltArr.length * 4];
        MemorySegment wseg2 = MemorySegment.ofArray(fltByteArr);
        MemorySegment.copy(fltArr, 0, wseg2, ValueLayout.JAVA_FLOAT_UNALIGNED, 0L, fltArr.length);
        return fltByteArr;
    }

    @Override
    byte[] getTotalItemsByteArr() {
        float[] fltArr = this.getFloatItemsArray();
        byte[] fltByteArr = new byte[fltArr.length * 4];
        MemorySegment wseg2 = MemorySegment.ofArray(fltByteArr);
        MemorySegment.copy(fltArr, 0, wseg2, ValueLayout.JAVA_FLOAT_UNALIGNED, 0L, fltArr.length);
        return fltByteArr;
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.wseg;
    }

    @Override
    void incN(int increment) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentN(this.wseg, KllPreambleUtil.getMemorySegmentN(this.wseg) + (long)increment);
    }

    @Override
    void incNumLevels() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int numLevels = KllPreambleUtil.getMemorySegmentNumLevels(this.wseg);
        KllPreambleUtil.setMemorySegmentNumLevels(this.wseg, ++numLevels);
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemorySegmentLevelZeroSortedFlag(this.wseg);
    }

    @Override
    void setFloatItemsArray(float[] floatItems) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        MemorySegment.copy(floatItems, 0, this.wseg, ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset, floatItems.length);
    }

    @Override
    void setFloatItemsArrayAt(int index, float item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 4;
        this.wseg.set(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset, item);
    }

    @Override
    void setFloatItemsArrayAt(int index, float[] items, int srcOffset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 4;
        MemorySegment.copy(items, srcOffset, this.wseg, ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset, length);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentLevelZeroSortedFlag(this.wseg, sorted);
    }

    @Override
    void setMinK(int minK) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentMinK(this.wseg, minK);
    }

    @Override
    void setN(long n) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentN(this.wseg, n);
    }

    @Override
    void setNumLevels(int numLevels) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemorySegmentNumLevels(this.wseg, numLevels);
    }

    @Override
    public boolean hasMemorySegment() {
        return this.wseg != null && this.wseg.scope().isAlive();
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.wseg.isNative();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return MemorySegmentStatus.isSameResource(this.wseg, that);
    }

    @Override
    void setMemorySegment(MemorySegment wseg) {
        this.wseg = wseg;
    }
}

