/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.ThetaIntersectionImpl;
import org.apache.datasketches.theta.ThetaSetOperationBuilder;
import org.apache.datasketches.theta.ThetaUnionImpl;

public abstract class ThetaSetOperation
implements MemorySegmentStatus {
    static final int CONST_PREAMBLE_LONGS = 3;

    ThetaSetOperation() {
    }

    public static final ThetaSetOperationBuilder builder() {
        return new ThetaSetOperationBuilder();
    }

    public static ThetaSetOperation heapify(MemorySegment srcSeg) {
        return ThetaSetOperation.heapify(srcSeg, 9001L);
    }

    public static ThetaSetOperation heapify(MemorySegment srcSeg, long expectedSeed) {
        byte famID = srcSeg.get(ValueLayout.JAVA_BYTE, 2L);
        Family family = Family.idToFamily(famID);
        switch (family) {
            case UNION: {
                return ThetaUnionImpl.heapifyInstance(srcSeg, expectedSeed);
            }
            case INTERSECTION: {
                return ThetaIntersectionImpl.heapifyInstance(srcSeg, expectedSeed);
            }
        }
        throw new SketchesArgumentException("ThetaSetOperation cannot heapify family: " + family.toString());
    }

    public static ThetaSetOperation wrap(MemorySegment srcSeg) {
        return ThetaSetOperation.wrap(srcSeg, 9001L);
    }

    public static ThetaSetOperation wrap(MemorySegment srcSeg, long expectedSeed) {
        byte famID = srcSeg.get(ValueLayout.JAVA_BYTE, 2L);
        Family family = Family.idToFamily(famID);
        byte serVer = srcSeg.get(ValueLayout.JAVA_BYTE, 1L);
        if (serVer != 3) {
            throw new SketchesArgumentException("SerVer must be 3: " + serVer);
        }
        switch (family) {
            case UNION: {
                return ThetaUnionImpl.wrapInstance(srcSeg, expectedSeed);
            }
            case INTERSECTION: {
                return ThetaIntersectionImpl.wrapInstance(srcSeg, expectedSeed, srcSeg.isReadOnly());
            }
        }
        throw new SketchesArgumentException("ThetaSetOperation cannot wrap family: " + family.toString());
    }

    public static int getMaxUnionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.UNION.getMaxPreLongs() << 3);
    }

    public static int getMaxIntersectionBytes(int nomEntries) {
        int nomEnt = Util.ceilingPowerOf2(nomEntries);
        return (nomEnt << 4) + (Family.INTERSECTION.getMaxPreLongs() << 3);
    }

    public static int getMaxAnotBResultBytes(int nomEntries) {
        int ceil = Util.ceilingPowerOf2(nomEntries);
        return 24 + 15 * ceil;
    }

    public abstract Family getFamily();

    abstract long[] getCache();

    MemorySegment getMemorySegment() {
        return null;
    }

    abstract int getRetainedEntries();

    abstract short getSeedHash();

    abstract long getThetaLong();

    abstract boolean isEmpty();
}

