/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesQuickSelectSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesSketchIterator;

class DirectArrayOfDoublesQuickSelectSketch
extends ArrayOfDoublesQuickSelectSketch {
    private final MemorySegment seg_;
    private int keysOffset_;
    private int valuesOffset_;

    DirectArrayOfDoublesQuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, int numValues, long seed, MemorySegment dstSeg) {
        DirectArrayOfDoublesQuickSelectSketch.checkMemorySegment(nomEntries, lgResizeFactor, numValues, dstSeg);
        super(numValues, seed);
        this.seg_ = dstSeg;
        int startingCapacity = Util.getStartingCapacity(nomEntries, lgResizeFactor);
        this.seg_.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        this.seg_.set(ValueLayout.JAVA_BYTE, 1L, (byte)1);
        this.seg_.set(ValueLayout.JAVA_BYTE, 2L, (byte)Family.TUPLE.getID());
        this.seg_.set(ValueLayout.JAVA_BYTE, 3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch.ordinal());
        this.seg_.set(ValueLayout.JAVA_BYTE, 4L, (byte)((samplingProbability < 1.0f ? 1 << ArrayOfDoublesSketch.Flags.IS_IN_SAMPLING_MODE.ordinal() : 0) | 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        this.seg_.set(ValueLayout.JAVA_BYTE, 5L, (byte)numValues);
        this.seg_.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, org.apache.datasketches.common.Util.computeSeedHash(seed));
        this.thetaLong_ = (long)(9.223372036854776E18 * (double)samplingProbability);
        this.seg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.thetaLong_);
        this.seg_.set(ValueLayout.JAVA_BYTE, 16L, (byte)Integer.numberOfTrailingZeros(nomEntries));
        this.seg_.set(ValueLayout.JAVA_BYTE, 17L, (byte)Integer.numberOfTrailingZeros(startingCapacity));
        this.seg_.set(ValueLayout.JAVA_BYTE, 18L, (byte)lgResizeFactor);
        this.seg_.set(ValueLayout.JAVA_FLOAT_UNALIGNED, 20L, samplingProbability);
        this.seg_.set(ValueLayout.JAVA_INT_UNALIGNED, 24L, 0);
        this.keysOffset_ = 32;
        this.valuesOffset_ = this.keysOffset_ + 8 * startingCapacity;
        org.apache.datasketches.common.Util.clear(this.seg_, this.keysOffset_, 8L * (long)startingCapacity);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.setRebuildThreshold();
    }

    private static final void checkMemorySegment(int nomEntries, int lgResizeFactor, int numValues, MemorySegment dstSeg) {
        int startingCapacity = Util.getStartingCapacity(nomEntries, lgResizeFactor);
        DirectArrayOfDoublesQuickSelectSketch.checkMemorySegmentSize(dstSeg, startingCapacity, numValues);
    }

    DirectArrayOfDoublesQuickSelectSketch(MemorySegment seg, long seed) {
        DirectArrayOfDoublesQuickSelectSketch.checkSerVer(seg);
        super(seg.get(ValueLayout.JAVA_BYTE, 5L), seed);
        this.seg_ = seg;
        SerializerDeserializer.validateFamily(seg.get(ValueLayout.JAVA_BYTE, 2L), seg.get(ValueLayout.JAVA_BYTE, 0L));
        SerializerDeserializer.validateType(this.seg_.get(ValueLayout.JAVA_BYTE, 3L), SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch);
        org.apache.datasketches.common.Util.checkSeedHashes(seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 6L), org.apache.datasketches.common.Util.computeSeedHash(seed));
        this.keysOffset_ = 32;
        this.valuesOffset_ = this.keysOffset_ + 8 * this.getCurrentCapacity();
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(this.getCurrentCapacity());
        this.thetaLong_ = this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
        this.isEmpty_ = (this.seg_.get(ValueLayout.JAVA_BYTE, 4L) & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) != 0;
        this.setRebuildThreshold();
    }

    private static final void checkSerVer(MemorySegment seg) {
        byte version = seg.get(ValueLayout.JAVA_BYTE, 1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            long keyOffset = this.keysOffset_;
            long valuesOffset = this.valuesOffset_;
            int cnt = 0;
            for (int j = 0; j < this.getCurrentCapacity(); ++j) {
                if (this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, keyOffset) != 0L) {
                    double[] array = new double[this.numValues_];
                    MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, valuesOffset, array, 0, this.numValues_);
                    values[cnt++] = array;
                }
                keyOffset += 8L;
                valuesOffset += 8L * (long)this.numValues_;
            }
        }
        return values;
    }

    @Override
    double[] getValuesAsOneDimension() {
        int count = this.getRetainedEntries();
        double[] values = new double[count * this.numValues_];
        int cap = this.getCurrentCapacity();
        if (count > 0) {
            long keyOffsetBytes = this.keysOffset_;
            long valuesOffsetBytes = this.valuesOffset_;
            int cnt = 0;
            for (int j = 0; j < cap; ++j) {
                if (this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, keyOffsetBytes) != 0L) {
                    MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, valuesOffsetBytes, values, cnt++ * this.numValues_, this.numValues_);
                }
                keyOffsetBytes += 8L;
                valuesOffsetBytes += 8L * (long)this.numValues_;
            }
            assert (cnt == count);
        }
        return values;
    }

    @Override
    long[] getKeys() {
        int count = this.getRetainedEntries();
        long[] keys = new long[count];
        int cap = this.getCurrentCapacity();
        if (count > 0) {
            long keyOffsetBytes = this.keysOffset_;
            int cnt = 0;
            for (int j = 0; j < cap; ++j) {
                long key = this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, keyOffsetBytes);
                if (key != 0L) {
                    keys[cnt++] = key;
                }
                keyOffsetBytes += 8L;
            }
            assert (cnt == count);
        }
        return keys;
    }

    @Override
    public int getRetainedEntries() {
        return this.seg_.get(ValueLayout.JAVA_INT_UNALIGNED, 24L);
    }

    @Override
    public int getNominalEntries() {
        return 1 << this.seg_.get(ValueLayout.JAVA_BYTE, 16L);
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.seg_.get(ValueLayout.JAVA_BYTE, 18L));
    }

    @Override
    public float getSamplingProbability() {
        return this.seg_.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 20L);
    }

    @Override
    public byte[] toByteArray() {
        int sizeBytes = this.getSerializedSizeBytes();
        byte[] byteArray = new byte[sizeBytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        this.serializeInto(seg);
        return byteArray;
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new DirectArrayOfDoublesSketchIterator(this.seg_, this.keysOffset_, this.getCurrentCapacity(), this.numValues_);
    }

    @Override
    public boolean hasMemorySegment() {
        return true;
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.seg_;
    }

    @Override
    int getSerializedSizeBytes() {
        return this.valuesOffset_ + 8 * this.numValues_ * this.getCurrentCapacity();
    }

    @Override
    void serializeInto(MemorySegment seg) {
        MemorySegment.copy(this.seg_, 0L, seg, 0L, seg.byteSize());
    }

    @Override
    public void reset() {
        if (!this.isEmpty_) {
            this.isEmpty_ = true;
            org.apache.datasketches.common.Util.setBits(this.seg_, 4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        }
        byte lgResizeFactor = this.seg_.get(ValueLayout.JAVA_BYTE, 18L);
        float samplingProbability = this.seg_.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 20L);
        int startingCapacity = Util.getStartingCapacity(this.getNominalEntries(), lgResizeFactor);
        this.thetaLong_ = (long)(9.223372036854776E18 * (double)samplingProbability);
        this.seg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.thetaLong_);
        this.seg_.set(ValueLayout.JAVA_BYTE, 17L, (byte)Integer.numberOfTrailingZeros(startingCapacity));
        this.seg_.set(ValueLayout.JAVA_INT_UNALIGNED, 24L, 0);
        this.keysOffset_ = 32;
        this.valuesOffset_ = this.keysOffset_ + 8 * startingCapacity;
        org.apache.datasketches.common.Util.clear(this.seg_, this.keysOffset_, 8L * (long)startingCapacity);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.setRebuildThreshold();
    }

    @Override
    protected long getKey(int index) {
        return this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)this.keysOffset_ + 8L * (long)index);
    }

    @Override
    protected void incrementCount() {
        int count = this.seg_.get(ValueLayout.JAVA_INT_UNALIGNED, 24L);
        if (count == 0) {
            org.apache.datasketches.common.Util.setBits(this.seg_, 4L, (byte)(1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()));
        }
        this.seg_.set(ValueLayout.JAVA_INT_UNALIGNED, 24L, count + 1);
    }

    @Override
    protected final int getCurrentCapacity() {
        return 1 << this.seg_.get(ValueLayout.JAVA_BYTE, 17L);
    }

    @Override
    protected void setThetaLong(long thetaLong) {
        this.thetaLong_ = thetaLong;
        this.seg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.thetaLong_);
    }

    @Override
    protected void setValues(int index, double[] values) {
        long offset = (long)this.valuesOffset_ + 8L * (long)this.numValues_ * (long)index;
        for (int i = 0; i < this.numValues_; ++i) {
            this.seg_.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, offset, values[i]);
            offset += 8L;
        }
    }

    @Override
    protected void updateValues(int index, double[] values) {
        long offset = (long)this.valuesOffset_ + 8L * (long)this.numValues_ * (long)index;
        for (int i = 0; i < this.numValues_; ++i) {
            this.seg_.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, offset, this.seg_.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, offset) + values[i]);
            offset += 8L;
        }
    }

    @Override
    protected void setNotEmpty() {
        if (this.isEmpty_) {
            this.isEmpty_ = false;
            org.apache.datasketches.common.Util.clearBits(this.seg_, 4L, (byte)(1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()));
        }
    }

    @Override
    protected boolean isInSamplingMode() {
        return (this.seg_.get(ValueLayout.JAVA_BYTE, 4L) & 1 << ArrayOfDoublesSketch.Flags.IS_IN_SAMPLING_MODE.ordinal()) != 0;
    }

    @Override
    protected void rebuild(int newCapacity) {
        int numValues = this.getNumValues();
        DirectArrayOfDoublesQuickSelectSketch.checkMemorySegmentSize(this.seg_, newCapacity, numValues);
        int currCapacity = this.getCurrentCapacity();
        long[] keys = new long[currCapacity];
        double[] values = new double[currCapacity * numValues];
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_LONG_UNALIGNED, this.keysOffset_, keys, 0, currCapacity);
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, this.valuesOffset_, values, 0, currCapacity * numValues);
        org.apache.datasketches.common.Util.clear(this.seg_, this.keysOffset_, 8L * (long)newCapacity + 8L * (long)newCapacity * (long)numValues);
        this.seg_.set(ValueLayout.JAVA_INT_UNALIGNED, 24L, 0);
        this.seg_.set(ValueLayout.JAVA_BYTE, 17L, (byte)Integer.numberOfTrailingZeros(newCapacity));
        this.valuesOffset_ = this.keysOffset_ + 8 * newCapacity;
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(newCapacity);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == 0L || keys[i] >= this.thetaLong_) continue;
            this.insert(keys[i], Arrays.copyOfRange(values, i * numValues, (i + 1) * numValues));
        }
        this.setRebuildThreshold();
    }

    @Override
    protected int insertKey(long key) {
        return HashOperations.hashInsertOnlyMemorySegment(this.seg_, this.lgCurrentCapacity_, key, 32);
    }

    @Override
    protected int findOrInsertKey(long key) {
        return HashOperations.hashSearchOrInsertMemorySegment(this.seg_, this.lgCurrentCapacity_, key, 32);
    }

    @Override
    protected double[] find(long key) {
        int index = HashOperations.hashSearchMemorySegment(this.seg_, this.lgCurrentCapacity_, key, 32);
        if (index == -1) {
            return null;
        }
        double[] array = new double[this.numValues_];
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)this.valuesOffset_ + 8L * (long)this.numValues_ * (long)index, array, 0, this.numValues_);
        return array;
    }

    private static void checkMemorySegmentSize(MemorySegment seg, int numEntries, int numValues) {
        int sizeNeeded = 32 + (8 + 8 * numValues) * numEntries;
        if ((long)sizeNeeded > seg.byteSize()) {
            throw new SketchesArgumentException("Not enough space: need " + sizeNeeded + " bytes, got " + seg.byteSize() + " bytes");
        }
    }
}

