/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.samples.cometd;

import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.http.cometd.CometdService;
import org.apache.felix.http.samples.cometd.TimeServlet;
import org.cometd.bayeux.server.BayeuxServer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    private BundleContext context;
    private ServiceTracker cometdServiceTracker;
    private ServiceTracker httpServiceTracker;
    private ServiceRegistration reg;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.cometdServiceTracker = new ServiceTracker(this.context, CometdService.class.getName(), (ServiceTrackerCustomizer)this);
        this.cometdServiceTracker.open();
        this.httpServiceTracker = new ServiceTracker(this.context, HttpService.class.getName(), (ServiceTrackerCustomizer)new HTTPServiceCustomizer());
        this.httpServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.cometdServiceTracker != null) {
            this.cometdServiceTracker.close();
        }
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
        }
        this.unregister();
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        this.register((CometdService)service);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.unregister();
        this.register((CometdService)service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.unregister();
    }

    private void register(CometdService cometdService) {
        try {
            BayeuxServer bayeuxServer = cometdService.getBayeuxServer();
            if (bayeuxServer != null) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("alias", "/system/time");
                this.reg = this.context.registerService(Servlet.class.getName(), (Object)new TimeServlet(bayeuxServer), props);
                this.doLog("Connect a browser to http://<host>:<port>/system/time to view the time.");
            } else {
                this.doLog("Failed to get bayeux server");
            }
        }
        catch (ServletException e) {
            this.doLog("Failed to register TimeServlet at /system/time: " + e.getMessage());
        }
    }

    private void unregister() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    private void doLog(String message) {
        System.out.println("## Activator:   " + message);
    }

    class HTTPServiceCustomizer
    implements ServiceTrackerCustomizer {
        HTTPServiceCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            HttpService httpService = (HttpService)Activator.this.context.getService(reference);
            try {
                httpService.registerResources("/js", "/src-web", null);
            }
            catch (NamespaceException e) {
                e.printStackTrace();
            }
            return null;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            HttpService httpService = (HttpService)Activator.this.context.getService(reference);
            httpService.unregister("/js");
        }
    }
}

