/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class CrossSpaceCompactionWriter
extends AbstractCompactionWriter {
    private List<TsFileIOWriter> fileWriterList = new ArrayList<TsFileIOWriter>();
    private List<TsFileResource> seqTsFileResources;
    private List<TsFileResource> targetTsFileResources;
    private int[] seqFileIndexArray = new int[subTaskNum];
    private final long[] currentDeviceEndTime;
    private final boolean[] isEmptyFile;
    private final boolean[] isDeviceExistedInTargetFiles;
    private int chunkGroupHeaderSize;
    private AtomicLong[] startTimeForCurDeviceForEachFile;
    private AtomicLong[] endTimeForCurDeviceForEachFile;
    private AtomicBoolean[] hasCurDeviceForEachFile;
    private AtomicLong[][] startTimeForEachDevice = new AtomicLong[subTaskNum][];
    private AtomicLong[][] endTimeForEachDevice = new AtomicLong[subTaskNum][];

    public CrossSpaceCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqFileResources) throws IOException {
        int i;
        this.currentDeviceEndTime = new long[seqFileResources.size()];
        this.isEmptyFile = new boolean[seqFileResources.size()];
        this.isDeviceExistedInTargetFiles = new boolean[targetResources.size()];
        this.targetTsFileResources = targetResources;
        this.startTimeForCurDeviceForEachFile = new AtomicLong[targetResources.size()];
        this.endTimeForCurDeviceForEachFile = new AtomicLong[targetResources.size()];
        this.hasCurDeviceForEachFile = new AtomicBoolean[targetResources.size()];
        long memorySizeForEachWriter = (long)((double)(SystemInfo.getInstance().getMemorySizeForCompaction() / (long)IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread()) * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataMemorySizeProportion() / (double)targetResources.size());
        for (i = 0; i < targetResources.size(); ++i) {
            this.fileWriterList.add(new TsFileIOWriter(targetResources.get(i).getTsFile()));
            this.isEmptyFile[i] = true;
            this.startTimeForCurDeviceForEachFile[i] = new AtomicLong(Long.MAX_VALUE);
            this.endTimeForCurDeviceForEachFile[i] = new AtomicLong(Long.MIN_VALUE);
            this.hasCurDeviceForEachFile[i] = new AtomicBoolean(false);
        }
        this.seqTsFileResources = seqFileResources;
        int size = targetResources.size();
        for (i = 0; i < subTaskNum; ++i) {
            this.startTimeForEachDevice[i] = new AtomicLong[size];
            this.endTimeForEachDevice[i] = new AtomicLong[size];
            for (int j = 0; j < size; ++j) {
                this.startTimeForEachDevice[i][j] = new AtomicLong(Long.MAX_VALUE);
                this.endTimeForEachDevice[i][j] = new AtomicLong(Long.MIN_VALUE);
            }
        }
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.deviceId = deviceId;
        this.isAlign = isAlign;
        this.seqFileIndexArray = new int[subTaskNum];
        this.checkIsDeviceExistAndGetDeviceEndTime();
        for (int i = 0; i < this.fileWriterList.size(); ++i) {
            this.chunkGroupHeaderSize = this.fileWriterList.get(i).startChunkGroup(deviceId);
        }
    }

    @Override
    public void endChunkGroup() throws IOException {
        int i;
        for (i = 0; i < this.seqTsFileResources.size(); ++i) {
            TsFileIOWriter targetFileWriter = this.fileWriterList.get(i);
            if (this.isDeviceExistedInTargetFiles[i]) {
                targetFileWriter.endChunkGroup();
            } else {
                targetFileWriter.truncate(targetFileWriter.getPos() - (long)this.chunkGroupHeaderSize);
            }
            this.isDeviceExistedInTargetFiles[i] = false;
        }
        int size = this.targetTsFileResources.size();
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < subTaskNum; ++j) {
                this.targetTsFileResources.get(i).updateStartTime(this.deviceId, this.startTimeForEachDevice[j][i].getAndSet(Long.MAX_VALUE));
                this.targetTsFileResources.get(i).updateEndTime(this.deviceId, this.endTimeForEachDevice[j][i].getAndSet(Long.MIN_VALUE));
            }
        }
        this.deviceId = null;
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.flushChunkToFileWriter(this.fileWriterList.get(this.seqFileIndexArray[subTaskId]), subTaskId);
        this.seqFileIndexArray[subTaskId] = 0;
    }

    @Override
    public void write(long timestamp, Object value, int subTaskId) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(timestamp, subTaskId);
        this.writeDataPoint(timestamp, value, subTaskId);
        int fileIndex = this.seqFileIndexArray[subTaskId];
        this.startTimeForEachDevice[subTaskId][fileIndex].accumulateAndGet(timestamp, Math::min);
        this.endTimeForEachDevice[subTaskId][fileIndex].accumulateAndGet(timestamp, Math::max);
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriterList.get(this.seqFileIndexArray[subTaskId]), subTaskId);
        this.isDeviceExistedInTargetFiles[this.seqFileIndexArray[subTaskId]] = true;
        this.isEmptyFile[this.seqFileIndexArray[subTaskId]] = false;
    }

    @Override
    public void write(long[] timestamps, Object values) {
    }

    @Override
    public void endFile() throws IOException {
        for (int i = 0; i < this.isEmptyFile.length; ++i) {
            this.fileWriterList.get(i).endFile();
            if (!this.isEmptyFile[i]) continue;
            this.targetTsFileResources.get(i).setStatus(TsFileResourceStatus.DELETED);
        }
    }

    @Override
    public void close() throws IOException {
        for (TsFileIOWriter targetWriter : this.fileWriterList) {
            if (targetWriter == null || !targetWriter.canWrite()) continue;
            targetWriter.close();
        }
        this.fileWriterList = null;
        this.seqTsFileResources = null;
    }

    @Override
    public List<TsFileIOWriter> getFileIOWriter() {
        return this.fileWriterList;
    }

    private void checkTimeAndMayFlushChunkToCurrentFile(long timestamp, int subTaskId) throws IOException {
        int fileIndex = this.seqFileIndexArray[subTaskId];
        while (timestamp > this.currentDeviceEndTime[fileIndex]) {
            if (fileIndex != this.seqTsFileResources.size() - 1) {
                this.flushChunkToFileWriter(this.fileWriterList.get(fileIndex), subTaskId);
                this.seqFileIndexArray[subTaskId] = ++fileIndex;
                continue;
            }
            return;
        }
    }

    private void checkIsDeviceExistAndGetDeviceEndTime() throws IOException {
        for (int fileIndex = 0; fileIndex < this.seqTsFileResources.size(); ++fileIndex) {
            if (this.seqTsFileResources.get(fileIndex).getTimeIndexType() == 1) {
                this.currentDeviceEndTime[fileIndex] = this.seqTsFileResources.get(fileIndex).getEndTime(this.deviceId);
                continue;
            }
            long endTime = Long.MIN_VALUE;
            Map deviceMetadataMap = FileReaderManager.getInstance().get(this.seqTsFileResources.get(fileIndex).getTsFilePath(), true).readDeviceMetadata(this.deviceId);
            for (Map.Entry entry : deviceMetadataMap.entrySet()) {
                long tmpStartTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getStartTime();
                long tmpEndTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getEndTime();
                if (tmpEndTime < tmpStartTime || endTime >= tmpEndTime) continue;
                endTime = tmpEndTime;
            }
            this.currentDeviceEndTime[fileIndex] = endTime;
        }
    }
}

