/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.Map;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class GroupByTimeFillPlan
extends GroupByTimePlan {
    private long queryStartTime;
    private long queryEndTime;
    private Map<TSDataType, IFill> fillTypes;
    private IFill singleFill;

    public GroupByTimeFillPlan() {
        this.setOperatorType(Operator.OperatorType.GROUP_BY_FILL);
    }

    public IFill getSingleFill() {
        return this.singleFill;
    }

    public Map<TSDataType, IFill> getFillType() {
        return this.fillTypes;
    }

    public void setSingleFill(IFill singleFill) {
        this.singleFill = singleFill;
    }

    public void setFillType(Map<TSDataType, IFill> fillTypes) {
        this.fillTypes = fillTypes;
    }

    public void setQueryStartTime(long queryStartTime) {
        this.queryStartTime = queryStartTime;
    }

    public long getQueryStartTime() {
        return this.queryStartTime;
    }

    public void setQueryEndTime(long queryEndTime) {
        this.queryEndTime = queryEndTime;
    }

    public long getQueryEndTime() {
        return this.queryEndTime;
    }

    public void initFillRange() {
        long minQueryStartTime = this.startTime;
        long maxQueryEndTime = this.endTime;
        if (this.fillTypes != null) {
            for (Map.Entry<TSDataType, IFill> IFillEntry : this.fillTypes.entrySet()) {
                IFill fill = IFillEntry.getValue();
                fill.convertRange(this.startTime, this.endTime);
                minQueryStartTime = Math.min(minQueryStartTime, fill.getQueryStartTime());
                maxQueryEndTime = Math.max(maxQueryEndTime, fill.getQueryEndTime());
            }
        } else {
            IFill fill = this.singleFill;
            fill.convertRange(this.startTime, this.endTime);
            minQueryStartTime = Math.min(minQueryStartTime, fill.getQueryStartTime());
            maxQueryEndTime = Math.max(maxQueryEndTime, fill.getQueryEndTime());
        }
        if (minQueryStartTime < this.startTime) {
            long extraStartTime;
            long queryRange = minQueryStartTime - this.startTime;
            if (this.isSlidingStepByMonth) {
                long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
                extraStartTime = GroupByEngineDataSet.calcIntervalByMonth(this.startTime, intervalNum);
                while (extraStartTime < minQueryStartTime) {
                    extraStartTime = GroupByEngineDataSet.calcIntervalByMonth(this.startTime, ++intervalNum);
                }
            } else {
                long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
                extraStartTime = this.slidingStep * intervalNum + this.startTime;
            }
            minQueryStartTime = Math.min(extraStartTime, this.startTime);
        }
        maxQueryEndTime = Math.max(maxQueryEndTime, this.endTime);
        this.queryStartTime = this.startTime;
        this.queryEndTime = this.endTime;
        this.startTime = minQueryStartTime;
        this.endTime = maxQueryEndTime;
    }
}

