/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InsertRowsNode
extends InsertNode
implements WALEntryValue {
    private List<Integer> insertRowNodeIndexList;
    private List<InsertRowNode> insertRowNodeList;
    private boolean isMixingAlignment = false;
    private Map<Integer, TSStatus> results = new HashMap<Integer, TSStatus>();

    public InsertRowsNode(PlanNodeId id) {
        super(id);
        this.insertRowNodeList = new ArrayList<InsertRowNode>();
        this.insertRowNodeIndexList = new ArrayList<Integer>();
    }

    @Override
    public InsertNode mergeInsertNode(List<InsertNode> insertNodes) {
        ArrayList<InsertRowNode> list = new ArrayList<InsertRowNode>();
        ArrayList<Integer> index = new ArrayList<Integer>();
        int i = 0;
        for (InsertNode insertNode : insertNodes) {
            for (InsertRowNode insertRowNode : ((InsertRowsNode)insertNode).getInsertRowNodeList()) {
                list.add(insertRowNode);
                index.add(i);
                ++i;
            }
        }
        return new InsertRowsNode(insertNodes.get(0).getPlanNodeId(), index, list);
    }

    public InsertRowsNode(PlanNodeId id, List<Integer> insertRowNodeIndexList, List<InsertRowNode> insertRowNodeList) {
        super(id);
        this.insertRowNodeIndexList = insertRowNodeIndexList;
        this.insertRowNodeList = insertRowNodeList;
    }

    public List<Integer> getInsertRowNodeIndexList() {
        return this.insertRowNodeIndexList;
    }

    public void setInsertRowNodeIndexList(List<Integer> insertRowNodeIndexList) {
        this.insertRowNodeIndexList = insertRowNodeIndexList;
    }

    public List<InsertRowNode> getInsertRowNodeList() {
        return this.insertRowNodeList;
    }

    public void setInsertRowNodeList(List<InsertRowNode> insertRowNodeList) {
        this.insertRowNodeList = insertRowNodeList;
    }

    public void addOneInsertRowNode(InsertRowNode node, int index) {
        this.insertRowNodeList.add(node);
        this.insertRowNodeIndexList.add(index);
    }

    public boolean isMixingAlignment() {
        return this.isMixingAlignment;
    }

    public void setMixingAlignment(boolean mixingAlignment) {
        this.isMixingAlignment = mixingAlignment;
    }

    @Override
    public void setSearchIndex(long index) {
        this.searchIndex = index;
        this.insertRowNodeList.forEach(plan -> plan.setSearchIndex(index));
    }

    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results.clear();
    }

    public TSStatus[] getFailingStatus() {
        return StatusUtils.getFailingStatus(this.results, (int)this.insertRowNodeList.size());
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.INSERT_ROWS;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertRowsNode that = (InsertRowsNode)o;
        return Objects.equals(this.insertRowNodeIndexList, that.insertRowNodeIndexList) && Objects.equals(this.insertRowNodeList, that.insertRowNodeList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.insertRowNodeIndexList, this.insertRowNodeList);
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of Insert is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.emptyList();
    }

    public static InsertRowsNode deserialize(ByteBuffer byteBuffer) {
        int i;
        ArrayList<InsertRowNode> insertRowNodeList = new ArrayList<InsertRowNode>();
        ArrayList<Integer> insertRowNodeIndex = new ArrayList<Integer>();
        int size = byteBuffer.getInt();
        for (i = 0; i < size; ++i) {
            InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""));
            insertRowNode.subDeserialize(byteBuffer);
            insertRowNodeList.add(insertRowNode);
        }
        for (i = 0; i < size; ++i) {
            insertRowNodeIndex.add(byteBuffer.getInt());
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        for (InsertRowNode insertRowNode : insertRowNodeList) {
            insertRowNode.setPlanNodeId(planNodeId);
        }
        InsertRowsNode insertRowsNode = new InsertRowsNode(planNodeId);
        insertRowsNode.setInsertRowNodeList(insertRowNodeList);
        insertRowsNode.setInsertRowNodeIndexList(insertRowNodeIndex);
        return insertRowsNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INSERT_ROWS.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.insertRowNodeList.size(), (ByteBuffer)byteBuffer);
        for (InsertRowNode node : this.insertRowNodeList) {
            node.subSerialize(byteBuffer);
        }
        for (Integer index : this.insertRowNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INSERT_ROWS.serialize(stream);
        ReadWriteIOUtils.write((int)this.insertRowNodeList.size(), (OutputStream)stream);
        for (InsertRowNode node : this.insertRowNodeList) {
            node.subSerialize(stream);
        }
        for (Integer index : this.insertRowNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (OutputStream)stream);
        }
    }

    @Override
    public void markAsGeneratedByPipe() {
        this.isGeneratedByPipe = true;
        this.insertRowNodeList.forEach(PlanNode::markAsGeneratedByPipe);
    }

    @Override
    public void markAsGeneratedByRemoteConsensusLeader() {
        super.markAsGeneratedByRemoteConsensusLeader();
        this.insertRowNodeList.forEach(InsertNode::markAsGeneratedByRemoteConsensusLeader);
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        HashMap<TRegionReplicaSet, InsertRowsNode> splitMap = new HashMap<TRegionReplicaSet, InsertRowsNode>();
        ArrayList<TEndPoint> redirectInfo = new ArrayList<TEndPoint>();
        for (int i = 0; i < this.insertRowNodeList.size(); ++i) {
            InsertRowNode insertRowNode = this.insertRowNodeList.get(i);
            TRegionReplicaSet dataRegionReplicaSet = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(insertRowNode.devicePath.getFullPath(), TimePartitionUtils.getTimePartitionSlot((long)insertRowNode.getTime()));
            redirectInfo.add(((TDataNodeLocation)dataRegionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint());
            InsertRowsNode tmpNode = (InsertRowsNode)splitMap.get(dataRegionReplicaSet);
            if (tmpNode != null) {
                tmpNode.addOneInsertRowNode(insertRowNode, i);
                continue;
            }
            tmpNode = new InsertRowsNode(this.getPlanNodeId());
            tmpNode.setDataRegionReplicaSet(dataRegionReplicaSet);
            tmpNode.addOneInsertRowNode(insertRowNode, i);
            splitMap.put(dataRegionReplicaSet, tmpNode);
        }
        analysis.setRedirectNodeList(redirectInfo);
        return new ArrayList<WritePlanNode>(splitMap.values());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRows(this, context);
    }

    @Override
    public long getMinTime() {
        return this.insertRowNodeList.stream().map(InsertRowNode::getMinTime).reduce(Long::min).orElse(Long.MAX_VALUE);
    }

    @Override
    public void setProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
        this.insertRowNodeList.forEach(insertRowNode -> insertRowNode.setProgressIndex(progressIndex));
    }

    public void updateProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return;
        }
        this.progressIndex = this.progressIndex == null ? progressIndex : this.progressIndex.updateToMinimumEqualOrIsAfterProgressIndex(progressIndex);
    }

    @Override
    public int serializedSize() {
        return 10 + this.subSerializeSize();
    }

    private int subSerializeSize() {
        int size = 4;
        for (InsertRowNode insertRowNode : this.insertRowNodeList) {
            size += insertRowNode.subSerializeSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putShort(PlanNodeType.INSERT_ROWS.getNodeType());
        buffer.putLong(this.searchIndex);
        this.subSerialize(buffer);
    }

    private void subSerialize(IWALByteBufferView buffer) {
        buffer.putInt(this.insertRowNodeList.size());
        for (InsertRowNode insertRowNode : this.insertRowNodeList) {
            insertRowNode.subSerialize(buffer);
        }
    }

    public static InsertRowsNode deserializeFromWAL(DataInputStream stream) throws IOException {
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        long searchIndex = stream.readLong();
        int listSize = stream.readInt();
        for (int i = 0; i < listSize; ++i) {
            InsertRowNode insertRowNode = InsertRowNode.subDeserializeFromWAL(stream);
            insertRowsNode.addOneInsertRowNode(insertRowNode, i);
        }
        insertRowsNode.setSearchIndex(searchIndex);
        return insertRowsNode;
    }

    public static InsertRowsNode deserializeFromWAL(ByteBuffer buffer) {
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        long searchIndex = buffer.getLong();
        int listSize = buffer.getInt();
        for (int i = 0; i < listSize; ++i) {
            InsertRowNode insertRowNode = InsertRowNode.subDeserializeFromWAL(buffer);
            insertRowsNode.addOneInsertRowNode(insertRowNode, i);
        }
        insertRowsNode.setSearchIndex(searchIndex);
        return insertRowsNode;
    }
}

