/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceLastCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceNormalSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceTemplateSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.IDeviceSchema;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;

@ThreadSafe
public class DeviceCacheEntry {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeviceCacheEntry.class) + 2L * RamUsageEstimator.shallowSizeOfInstance(AtomicReference.class);
    private final AtomicReference<IDeviceSchema> deviceSchema = new AtomicReference();
    private final AtomicReference<DeviceLastCache> lastCache = new AtomicReference();

    int setDeviceSchema(String database, DeviceSchemaInfo deviceSchemaInfo) {
        if (deviceSchemaInfo.getTemplateId() == -1) {
            int result = this.deviceSchema.compareAndSet(null, new DeviceNormalSchema(database, deviceSchemaInfo.isAligned())) ? DeviceNormalSchema.INSTANCE_SIZE : 0;
            return this.deviceSchema.get() instanceof DeviceNormalSchema ? result + ((DeviceNormalSchema)this.deviceSchema.get()).update(deviceSchemaInfo.getMeasurementSchemaInfoList()) : 0;
        }
        return this.deviceSchema.compareAndSet(null, new DeviceTemplateSchema(database, deviceSchemaInfo.getTemplateId())) ? DeviceTemplateSchema.INSTANCE_SIZE : 0;
    }

    int setMeasurementSchema(String database, boolean isAligned, String[] measurements, IMeasurementSchema[] schemas) {
        if (schemas == null) {
            return 0;
        }
        int result = this.deviceSchema.compareAndSet(null, new DeviceNormalSchema(database, isAligned)) ? DeviceNormalSchema.INSTANCE_SIZE : 0;
        return this.deviceSchema.get() instanceof DeviceNormalSchema ? result + ((DeviceNormalSchema)this.deviceSchema.get()).update(measurements, schemas) : 0;
    }

    IDeviceSchema getDeviceSchema() {
        return this.deviceSchema.get();
    }

    int invalidateSchema() {
        AtomicInteger size = new AtomicInteger(0);
        this.deviceSchema.updateAndGet(schema -> {
            if (Objects.nonNull(schema)) {
                size.set(schema.estimateSize());
            }
            return null;
        });
        return size.get();
    }

    int initOrInvalidateLastCache(String[] measurements, boolean isInvalidate) {
        int result = this.lastCache.compareAndSet(null, new DeviceLastCache()) ? DeviceLastCache.INSTANCE_SIZE : 0;
        DeviceLastCache cache = this.lastCache.get();
        return Objects.nonNull(this.lastCache.get()) ? (result += Objects.nonNull(cache) ? cache.initOrInvalidate(measurements, isInvalidate) : 0) : 0;
    }

    int tryUpdateLastCache(String[] measurements, TimeValuePair[] timeValuePairs, boolean invalidateNull) {
        DeviceLastCache cache = this.lastCache.get();
        int result = Objects.nonNull(cache) ? cache.tryUpdate(measurements, timeValuePairs, invalidateNull) : 0;
        return Objects.nonNull(this.lastCache.get()) ? result : 0;
    }

    int tryUpdateLastCache(String[] measurements, TimeValuePair[] timeValuePairs) {
        return this.tryUpdateLastCache(measurements, timeValuePairs, false);
    }

    int invalidateLastCache(String measurement) {
        DeviceLastCache cache = this.lastCache.get();
        int result = Objects.nonNull(cache) ? cache.invalidate(measurement) : 0;
        return Objects.nonNull(this.lastCache.get()) ? result : 0;
    }

    TimeValuePair getTimeValuePair(String measurement) {
        DeviceLastCache cache = this.lastCache.get();
        return Objects.nonNull(cache) ? cache.getTimeValuePair(measurement) : null;
    }

    boolean updateInputMap(@Nonnull Map<String, TimeValuePair> updateMap) {
        for (String measurement : updateMap.keySet()) {
            TimeValuePair result = this.getTimeValuePair(measurement);
            if (result == null) {
                return false;
            }
            updateMap.put(measurement, result);
        }
        return true;
    }

    int invalidateLastCache() {
        AtomicInteger size = new AtomicInteger(0);
        this.lastCache.updateAndGet(cacheEntry -> {
            if (Objects.nonNull(cacheEntry)) {
                size.set(cacheEntry.estimateSize());
            }
            return null;
        });
        return size.get();
    }

    int estimateSize() {
        IDeviceSchema schema = this.deviceSchema.get();
        DeviceLastCache cache = this.lastCache.get();
        return (int)(INSTANCE_SIZE + (long)(Objects.nonNull(schema) ? schema.estimateSize() : 0) + (long)(Objects.nonNull(cache) ? cache.estimateSize() : 0));
    }
}

