/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class MigrateRegion
extends Statement {
    private final int regionId;
    private final int fromId;
    private final int toId;

    public MigrateRegion(int regionId, int fromId, int toId) {
        this(null, regionId, fromId, toId);
    }

    public MigrateRegion(@Nullable NodeLocation location, int regionId, int fromId, int toId) {
        super(location);
        this.regionId = regionId;
        this.fromId = fromId;
        this.toId = toId;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(MigrateRegion.class, this.regionId, this.fromId, this.toId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MigrateRegion)) {
            return false;
        }
        MigrateRegion another = (MigrateRegion)obj;
        return this.regionId == another.regionId && this.fromId == another.fromId && this.toId == another.toId;
    }

    @Override
    public String toString() {
        return String.format("migrate region %d from %d to %d", this.regionId, this.fromId, this.toId);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMigrateRegion(this, context);
    }

    public int getRegionId() {
        return this.regionId;
    }

    public int getFromId() {
        return this.fromId;
    }

    public int getToId() {
        return this.toId;
    }
}

