/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.multipdf;

import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.multipdf.PDFCloneUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;

public class Overlay
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Overlay.class);
    private LayoutPage defaultOverlayPage;
    private final Map<Integer, LayoutPage> rotatedDefaultOverlayPagesMap = new HashMap<Integer, LayoutPage>();
    private LayoutPage firstPageOverlayPage;
    private LayoutPage lastPageOverlayPage;
    private LayoutPage oddPageOverlayPage;
    private LayoutPage evenPageOverlayPage;
    private final Set<PDDocument> openDocumentsSet = new HashSet<PDDocument>();
    private Map<Integer, LayoutPage> specificPageOverlayLayoutPageMap = new HashMap<Integer, LayoutPage>();
    private Position position = Position.BACKGROUND;
    private String inputFileName = null;
    private PDDocument inputPDFDocument = null;
    private String defaultOverlayFilename = null;
    private PDDocument defaultOverlayDocument = null;
    private String firstPageOverlayFilename = null;
    private PDDocument firstPageOverlayDocument = null;
    private String lastPageOverlayFilename = null;
    private PDDocument lastPageOverlayDocument = null;
    private String allPagesOverlayFilename = null;
    private PDDocument allPagesOverlayDocument = null;
    private String oddPageOverlayFilename = null;
    private PDDocument oddPageOverlayDocument = null;
    private String evenPageOverlayFilename = null;
    private PDDocument evenPageOverlayDocument = null;
    private int numberOfOverlayPages = 0;
    private boolean useAllOverlayPages = false;
    private boolean adjustRotation = false;

    public PDDocument overlay(Map<Integer, String> specificPageOverlayMap) throws IOException {
        HashMap<String, LayoutPage> layouts = new HashMap<String, LayoutPage>();
        this.loadPDFs();
        for (Map.Entry<Integer, String> e : specificPageOverlayMap.entrySet()) {
            String path = e.getValue();
            LayoutPage layoutPage = (LayoutPage)layouts.get(path);
            if (layoutPage == null) {
                PDDocument doc = this.loadPDF(path);
                layoutPage = this.createLayoutPageFromDocument(doc);
                layouts.put(path, layoutPage);
                this.openDocumentsSet.add(doc);
            }
            this.specificPageOverlayLayoutPageMap.put(e.getKey(), layoutPage);
        }
        this.processPages(this.inputPDFDocument);
        return this.inputPDFDocument;
    }

    public PDDocument overlayDocuments(Map<Integer, PDDocument> specificPageOverlayDocumentMap) throws IOException {
        this.loadPDFs();
        for (Map.Entry<Integer, PDDocument> e : specificPageOverlayDocumentMap.entrySet()) {
            PDDocument doc = e.getValue();
            if (doc == null) continue;
            this.specificPageOverlayLayoutPageMap.put(e.getKey(), this.createLayoutPageFromDocument(doc));
        }
        this.processPages(this.inputPDFDocument);
        return this.inputPDFDocument;
    }

    @Override
    public void close() throws IOException {
        if (this.defaultOverlayDocument != null) {
            this.defaultOverlayDocument.close();
        }
        if (this.firstPageOverlayDocument != null) {
            this.firstPageOverlayDocument.close();
        }
        if (this.lastPageOverlayDocument != null) {
            this.lastPageOverlayDocument.close();
        }
        if (this.allPagesOverlayDocument != null) {
            this.allPagesOverlayDocument.close();
        }
        if (this.oddPageOverlayDocument != null) {
            this.oddPageOverlayDocument.close();
        }
        if (this.evenPageOverlayDocument != null) {
            this.evenPageOverlayDocument.close();
        }
        for (PDDocument doc : this.openDocumentsSet) {
            doc.close();
        }
        this.openDocumentsSet.clear();
        this.specificPageOverlayLayoutPageMap.clear();
        this.rotatedDefaultOverlayPagesMap.clear();
    }

    private void loadPDFs() throws IOException {
        if (this.inputFileName != null) {
            this.inputPDFDocument = this.loadPDF(this.inputFileName);
        }
        if (this.inputPDFDocument == null) {
            throw new IllegalArgumentException("No input document");
        }
        if (this.defaultOverlayFilename != null) {
            this.defaultOverlayDocument = this.loadPDF(this.defaultOverlayFilename);
        }
        if (this.defaultOverlayDocument != null) {
            this.defaultOverlayPage = this.createLayoutPageFromDocument(this.defaultOverlayDocument);
        }
        if (this.firstPageOverlayFilename != null) {
            this.firstPageOverlayDocument = this.loadPDF(this.firstPageOverlayFilename);
        }
        if (this.firstPageOverlayDocument != null) {
            this.firstPageOverlayPage = this.createLayoutPageFromDocument(this.firstPageOverlayDocument);
        }
        if (this.lastPageOverlayFilename != null) {
            this.lastPageOverlayDocument = this.loadPDF(this.lastPageOverlayFilename);
        }
        if (this.lastPageOverlayDocument != null) {
            this.lastPageOverlayPage = this.createLayoutPageFromDocument(this.lastPageOverlayDocument);
        }
        if (this.oddPageOverlayFilename != null) {
            this.oddPageOverlayDocument = this.loadPDF(this.oddPageOverlayFilename);
        }
        if (this.oddPageOverlayDocument != null) {
            this.oddPageOverlayPage = this.createLayoutPageFromDocument(this.oddPageOverlayDocument);
        }
        if (this.evenPageOverlayFilename != null) {
            this.evenPageOverlayDocument = this.loadPDF(this.evenPageOverlayFilename);
        }
        if (this.evenPageOverlayDocument != null) {
            this.evenPageOverlayPage = this.createLayoutPageFromDocument(this.evenPageOverlayDocument);
        }
        if (this.allPagesOverlayFilename != null) {
            this.allPagesOverlayDocument = this.loadPDF(this.allPagesOverlayFilename);
        }
        if (this.allPagesOverlayDocument != null) {
            this.specificPageOverlayLayoutPageMap = this.createPageOverlayLayoutPageMap(this.allPagesOverlayDocument);
            this.useAllOverlayPages = true;
            this.numberOfOverlayPages = this.specificPageOverlayLayoutPageMap.size();
        }
    }

    private PDDocument loadPDF(String pdfName) throws IOException {
        return Loader.loadPDF(new File(pdfName));
    }

    private LayoutPage createLayoutPageFromDocument(PDDocument doc) throws IOException {
        return this.createLayoutPage(doc.getPage(0));
    }

    private LayoutPage createLayoutPage(PDPage page) throws IOException {
        COSBase contents = page.getCOSObject().getDictionaryObject(COSName.CONTENTS);
        PDResources resources = page.getResources();
        if (resources == null) {
            resources = new PDResources();
        }
        return new LayoutPage(page.getMediaBox(), this.createCombinedContentStream(contents), resources.getCOSObject(), page.getRotation());
    }

    private Map<Integer, LayoutPage> createPageOverlayLayoutPageMap(PDDocument doc) throws IOException {
        int i = 0;
        PDPageTree pageTree = doc.getPages();
        HashMap<Integer, LayoutPage> layoutPages = new HashMap<Integer, LayoutPage>(pageTree.getCount());
        for (PDPage page : pageTree) {
            layoutPages.put(i, this.createLayoutPage(page));
            ++i;
        }
        return layoutPages;
    }

    private COSStream createCombinedContentStream(COSBase contents) throws IOException {
        List<COSStream> contentStreams = this.createContentStreamList(contents);
        COSStream concatStream = this.inputPDFDocument.getDocument().createCOSStream();
        try (OutputStream out = concatStream.createOutputStream(COSName.FLATE_DECODE);){
            for (COSStream contentStream : contentStreams) {
                COSInputStream in = contentStream.createInputStream();
                Throwable throwable = null;
                try {
                    IOUtils.copy(in, out);
                    out.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
        }
        return concatStream;
    }

    private List<COSStream> createContentStreamList(COSBase contents) throws IOException {
        if (contents == null) {
            return Collections.emptyList();
        }
        if (contents instanceof COSStream) {
            return Collections.singletonList((COSStream)contents);
        }
        ArrayList<COSStream> contentStreams = new ArrayList<COSStream>();
        if (contents instanceof COSArray) {
            for (COSBase item : (COSArray)contents) {
                contentStreams.addAll(this.createContentStreamList(item));
            }
        } else if (contents instanceof COSObject) {
            contentStreams.addAll(this.createContentStreamList(((COSObject)contents).getObject()));
        } else {
            throw new IOException("Unknown content type: " + contents.getClass().getName());
        }
        return contentStreams;
    }

    private void processPages(PDDocument document) throws IOException {
        int pageCounter = 0;
        PDFCloneUtility cloner = new PDFCloneUtility(document);
        PDPageTree pageTree = document.getPages();
        int numberOfPages = pageTree.getCount();
        for (PDPage page : pageTree) {
            LayoutPage layoutPage;
            if ((layoutPage = this.getLayoutPage(++pageCounter, numberOfPages)) == null) continue;
            COSDictionary pageDictionary = page.getCOSObject();
            COSBase originalContent = pageDictionary.getDictionaryObject(COSName.CONTENTS);
            COSArray newContentArray = new COSArray();
            switch (this.position) {
                case FOREGROUND: {
                    newContentArray.add(this.createStream("q\n"));
                    this.addOriginalContent(originalContent, newContentArray);
                    newContentArray.add(this.createStream("Q\n"));
                    this.overlayPage(page, layoutPage, newContentArray, cloner);
                    break;
                }
                case BACKGROUND: {
                    this.overlayPage(page, layoutPage, newContentArray, cloner);
                    this.addOriginalContent(originalContent, newContentArray);
                    break;
                }
                default: {
                    throw new IOException("Unknown type of position:" + (Object)((Object)this.position));
                }
            }
            pageDictionary.setItem(COSName.CONTENTS, (COSBase)newContentArray);
        }
    }

    private void addOriginalContent(COSBase contents, COSArray contentArray) throws IOException {
        if (contents == null) {
            return;
        }
        if (contents instanceof COSStream) {
            contentArray.add(contents);
        } else if (contents instanceof COSArray) {
            contentArray.addAll((COSArray)contents);
        } else {
            throw new IOException("Unknown content type: " + contents.getClass().getName());
        }
    }

    private void overlayPage(PDPage page, LayoutPage layoutPage, COSArray array, PDFCloneUtility cloner) throws IOException {
        PDResources resources = page.getResources();
        if (resources == null) {
            resources = new PDResources();
            page.setResources(resources);
        }
        PDFormXObject overlayFormXObject = this.createOverlayFormXObject(layoutPage, cloner);
        COSName formXObjectId = resources.add(overlayFormXObject, "OL");
        array.add(this.createOverlayStream(page, layoutPage, formXObjectId));
    }

    private LayoutPage getLayoutPage(int pageNumber, int numberOfPages) throws IOException {
        LayoutPage layoutPage = null;
        if (!this.useAllOverlayPages && this.specificPageOverlayLayoutPageMap.containsKey(pageNumber)) {
            layoutPage = this.specificPageOverlayLayoutPageMap.get(pageNumber);
        } else if (pageNumber == 1 && this.firstPageOverlayPage != null) {
            layoutPage = this.firstPageOverlayPage;
        } else if (pageNumber == numberOfPages && this.lastPageOverlayPage != null) {
            layoutPage = this.lastPageOverlayPage;
        } else if (pageNumber % 2 == 1 && this.oddPageOverlayPage != null) {
            layoutPage = this.oddPageOverlayPage;
        } else if (pageNumber % 2 == 0 && this.evenPageOverlayPage != null) {
            layoutPage = this.evenPageOverlayPage;
        } else if (this.defaultOverlayPage != null) {
            PDPage page;
            int rotation;
            layoutPage = this.defaultOverlayPage;
            if (this.adjustRotation && (rotation = (page = this.inputPDFDocument.getPage(pageNumber - 1)).getRotation()) != 0) {
                return this.createAdjustedLayoutPage(rotation);
            }
        } else if (this.useAllOverlayPages) {
            int usePageNum = (pageNumber - 1) % this.numberOfOverlayPages;
            layoutPage = this.specificPageOverlayLayoutPageMap.get(usePageNum);
        }
        return layoutPage;
    }

    private LayoutPage createAdjustedLayoutPage(int rotation) throws IOException {
        LayoutPage rotatedLayoutPage = this.rotatedDefaultOverlayPagesMap.get(rotation);
        if (rotatedLayoutPage == null) {
            rotatedLayoutPage = this.createLayoutPage(this.defaultOverlayDocument.getPage(0));
            int newRotation = (rotatedLayoutPage.overlayRotation - rotation + 360) % 360;
            rotatedLayoutPage.overlayRotation = newRotation;
            this.rotatedDefaultOverlayPagesMap.put(rotation, rotatedLayoutPage);
        }
        return rotatedLayoutPage;
    }

    private PDFormXObject createOverlayFormXObject(LayoutPage layoutPage, PDFCloneUtility cloner) throws IOException {
        PDFormXObject xobjForm = new PDFormXObject(layoutPage.overlayCOSStream);
        xobjForm.setResources(new PDResources(cloner.cloneForNewDocument(layoutPage.overlayResources)));
        xobjForm.setFormType(1);
        xobjForm.setBBox(layoutPage.overlayMediaBox.createRetranslatedRectangle());
        AffineTransform at = new AffineTransform();
        switch (layoutPage.overlayRotation) {
            case 90: {
                at.translate(0.0, layoutPage.overlayMediaBox.getWidth());
                at.quadrantRotate(3);
                break;
            }
            case 180: {
                at.translate(layoutPage.overlayMediaBox.getWidth(), layoutPage.overlayMediaBox.getHeight());
                at.quadrantRotate(2);
                break;
            }
            case 270: {
                at.translate(layoutPage.overlayMediaBox.getHeight(), 0.0);
                at.quadrantRotate(1);
                break;
            }
        }
        xobjForm.setMatrix(at);
        return xobjForm;
    }

    private COSStream createOverlayStream(PDPage page, LayoutPage layoutPage, COSName xObjectId) throws IOException {
        StringBuilder overlayStream = new StringBuilder();
        overlayStream.append("q\nq\n");
        PDRectangle overlayMediaBox = new PDRectangle(layoutPage.overlayMediaBox.getCOSArray());
        if (layoutPage.overlayRotation == 90 || layoutPage.overlayRotation == 270) {
            overlayMediaBox.setLowerLeftX(layoutPage.overlayMediaBox.getLowerLeftY());
            overlayMediaBox.setLowerLeftY(layoutPage.overlayMediaBox.getLowerLeftX());
            overlayMediaBox.setUpperRightX(layoutPage.overlayMediaBox.getUpperRightY());
            overlayMediaBox.setUpperRightY(layoutPage.overlayMediaBox.getUpperRightX());
        }
        AffineTransform at = this.calculateAffineTransform(page, overlayMediaBox);
        double[] flatmatrix = new double[6];
        at.getMatrix(flatmatrix);
        for (double v : flatmatrix) {
            overlayStream.append(this.float2String((float)v));
            overlayStream.append(' ');
        }
        overlayStream.append(" cm\n");
        overlayStream.append(" /");
        overlayStream.append(xObjectId.getName());
        overlayStream.append(" Do Q\nQ\n");
        return this.createStream(overlayStream.toString());
    }

    protected AffineTransform calculateAffineTransform(PDPage page, PDRectangle overlayMediaBox) {
        AffineTransform at = new AffineTransform();
        PDRectangle pageMediaBox = page.getMediaBox();
        float hShift = (pageMediaBox.getWidth() - overlayMediaBox.getWidth()) / 2.0f;
        float vShift = (pageMediaBox.getHeight() - overlayMediaBox.getHeight()) / 2.0f;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Overlay position: (" + hShift + "," + vShift + ")");
        }
        at.translate(hShift, vShift);
        return at;
    }

    private String float2String(float floatValue) {
        BigDecimal value = new BigDecimal(String.valueOf(floatValue));
        String stringValue = value.toPlainString();
        if (stringValue.indexOf(46) > -1 && !stringValue.endsWith(".0")) {
            while (stringValue.endsWith("0") && !stringValue.endsWith(".0")) {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
            }
        }
        return stringValue;
    }

    private COSStream createStream(String content) throws IOException {
        COSStream stream = this.inputPDFDocument.getDocument().createCOSStream();
        try (OutputStream out = stream.createOutputStream(content.length() > 20 ? COSName.FLATE_DECODE : null);){
            out.write(content.getBytes(StandardCharsets.ISO_8859_1));
        }
        return stream;
    }

    public void setOverlayPosition(Position overlayPosition) {
        this.position = overlayPosition;
    }

    public void setInputFile(String inputFile) {
        this.inputFileName = inputFile;
    }

    public void setInputPDF(PDDocument inputPDF) {
        this.inputPDFDocument = inputPDF;
    }

    public String getInputFile() {
        return this.inputFileName;
    }

    public void setDefaultOverlayFile(String defaultOverlayFile) {
        this.defaultOverlayFilename = defaultOverlayFile;
    }

    public void setDefaultOverlayPDF(PDDocument defaultOverlayPDF) {
        this.defaultOverlayDocument = defaultOverlayPDF;
    }

    public String getDefaultOverlayFile() {
        return this.defaultOverlayFilename;
    }

    public void setFirstPageOverlayFile(String firstPageOverlayFile) {
        this.firstPageOverlayFilename = firstPageOverlayFile;
    }

    public void setFirstPageOverlayPDF(PDDocument firstPageOverlayPDF) {
        this.firstPageOverlayDocument = firstPageOverlayPDF;
    }

    public void setLastPageOverlayFile(String lastPageOverlayFile) {
        this.lastPageOverlayFilename = lastPageOverlayFile;
    }

    public void setLastPageOverlayPDF(PDDocument lastPageOverlayPDF) {
        this.lastPageOverlayDocument = lastPageOverlayPDF;
    }

    public void setAllPagesOverlayFile(String allPagesOverlayFile) {
        this.allPagesOverlayFilename = allPagesOverlayFile;
    }

    public void setAllPagesOverlayPDF(PDDocument allPagesOverlayPDF) {
        this.allPagesOverlayDocument = allPagesOverlayPDF;
    }

    public void setOddPageOverlayFile(String oddPageOverlayFile) {
        this.oddPageOverlayFilename = oddPageOverlayFile;
    }

    public void setOddPageOverlayPDF(PDDocument oddPageOverlayPDF) {
        this.oddPageOverlayDocument = oddPageOverlayPDF;
    }

    public void setEvenPageOverlayFile(String evenPageOverlayFile) {
        this.evenPageOverlayFilename = evenPageOverlayFile;
    }

    public void setEvenPageOverlayPDF(PDDocument evenPageOverlayPDF) {
        this.evenPageOverlayDocument = evenPageOverlayPDF;
    }

    public void setAdjustRotation(boolean adjustRotation) {
        this.adjustRotation = adjustRotation;
    }

    private static final class LayoutPage {
        private final PDRectangle overlayMediaBox;
        private final COSStream overlayCOSStream;
        private final COSDictionary overlayResources;
        private int overlayRotation;

        private LayoutPage(PDRectangle mediaBox, COSStream contentStream, COSDictionary resources, int rotation) {
            this.overlayMediaBox = mediaBox;
            this.overlayCOSStream = contentStream;
            this.overlayResources = resources;
            this.overlayRotation = rotation;
        }
    }

    public static enum Position {
        FOREGROUND,
        BACKGROUND;

    }
}

