/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setAttributeNodeNS Adds a new attribute and raises an INUSE_ATTRIBUTE_ERR
 * if newAttr is already an attribute of another Element object.
 * Create two new element nodes and a new attribute node.  Attempt to add the same attribute
 * node to the same two element nodes.
 * Check if an INUSE_ATTRIBUTE_ERR is thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
 */
public class elementsetattributenodens04 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        Element element1 = doc.createElementNS("http://www.w3.org/DOM/Test", "elem1");
        Element element2 = doc.createElementNS("http://www.w3.org/DOM/Test", "elem2");
        Attr attribute = doc.createAttributeNS("http://www.w3.org/DOM/Test", "attr");
        Attr newAttribute = element1.setAttributeNodeNS(attribute);

        DOMException ex = assertThrows(DOMException.class, () -> element2.setAttributeNodeNS(attribute));
        assertEquals(DOMException.INUSE_ATTRIBUTE_ERR, ex.code, "elementsetattributenodens04");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributenodens04";
    }

}
