/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SystemProperties;
import java.io.IOException;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.impl.producer.PublishingSettings;
import org.apache.rocketmq.client.java.message.MessageIdCodec;
import org.apache.rocketmq.client.java.message.MessageImpl;
import org.apache.rocketmq.client.java.message.MessageType;
import org.apache.rocketmq.client.java.message.protocol.Encoding;
import org.apache.rocketmq.client.java.misc.Utilities;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.shaded.com.google.protobuf.ByteString;
import org.apache.rocketmq.shaded.com.google.protobuf.util.Timestamps;

public class PublishingMessageImpl
extends MessageImpl {
    private final MessageId messageId;
    private final MessageType messageType;

    public PublishingMessageImpl(Message message, PublishingSettings publishingSettings, boolean txEnabled) throws IOException {
        super(message);
        int length = message.getBody().remaining();
        int maxBodySizeBytes = publishingSettings.getMaxBodySizeBytes();
        if (length > maxBodySizeBytes) {
            throw new IOException("Message body size exceeds the threshold, max size=" + maxBodySizeBytes + " bytes");
        }
        this.messageId = MessageIdCodec.getInstance().nextMessageId();
        if (!(message.getMessageGroup().isPresent() || message.getLiteTopic().isPresent() || message.getPriority().isPresent() || message.getDeliveryTimestamp().isPresent() || txEnabled)) {
            this.messageType = MessageType.NORMAL;
            return;
        }
        if (message.getMessageGroup().isPresent() && !txEnabled) {
            this.messageType = MessageType.FIFO;
            return;
        }
        if (message.getLiteTopic().isPresent() && !txEnabled) {
            this.messageType = MessageType.LITE;
            return;
        }
        if (message.getDeliveryTimestamp().isPresent() && !txEnabled) {
            this.messageType = MessageType.DELAY;
            return;
        }
        if (message.getPriority().isPresent() && !txEnabled) {
            this.messageType = MessageType.PRIORITY;
            return;
        }
        if (!(message.getMessageGroup().isPresent() || message.getLiteTopic().isPresent() || message.getPriority().isPresent() || message.getDeliveryTimestamp().isPresent() || !txEnabled)) {
            this.messageType = MessageType.TRANSACTION;
            return;
        }
        throw new IllegalArgumentException("Transactional message should not set messageGroup, deliveryTimestamp, lite and priority");
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public apache.rocketmq.v2.Message toProtobuf(String namespace, MessageQueueImpl mq) {
        SystemProperties.Builder systemPropertiesBuilder = SystemProperties.newBuilder().addAllKeys(this.keys).setMessageId(this.messageId.toString()).setBornTimestamp(Timestamps.fromMillis(System.currentTimeMillis())).setBornHost(Utilities.hostName()).setBodyEncoding(Encoding.toProtobuf(Encoding.IDENTITY)).setQueueId(mq.getQueueId()).setMessageType(MessageType.toProtobuf(this.messageType));
        this.getTag().ifPresent(systemPropertiesBuilder::setTag);
        this.getDeliveryTimestamp().ifPresent(millis -> systemPropertiesBuilder.setDeliveryTimestamp(Timestamps.fromMillis(millis)));
        this.getMessageGroup().ifPresent(systemPropertiesBuilder::setMessageGroup);
        this.getLiteTopic().ifPresent(systemPropertiesBuilder::setLiteTopic);
        this.getPriority().ifPresent(systemPropertiesBuilder::setPriority);
        SystemProperties systemProperties = systemPropertiesBuilder.build();
        Resource topicResource = Resource.newBuilder().setResourceNamespace(namespace).setName(this.getTopic()).build();
        return apache.rocketmq.v2.Message.newBuilder().setTopic(topicResource).setBody(ByteString.copyFrom(this.getBody())).setSystemProperties(systemProperties).putAllUserProperties(this.getProperties()).build();
    }
}

