/*
 * Decompiled with CFR 0.152.
 */
package brave.sampler;

import brave.internal.Nullable;
import brave.propagation.SamplingFlags;
import brave.sampler.CountingSampler;
import brave.sampler.Sampler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DeclarativeSampler<M> {
    final ConcurrentMap<M, Sampler> methodsToSamplers = new ConcurrentHashMap<M, Sampler>();
    final RateForMethod<M> rateForMethod;
    static final Sampler NULL_SENTINEL = new Sampler(){

        @Override
        public boolean isSampled(long traceId) {
            throw new AssertionError();
        }
    };

    public static <M> DeclarativeSampler<M> create(RateForMethod<M> rateForMethod) {
        return new DeclarativeSampler<M>(rateForMethod);
    }

    DeclarativeSampler(RateForMethod<M> rateForMethod) {
        this.rateForMethod = rateForMethod;
    }

    public Sampler toSampler(final M method) {
        if (method == null) {
            throw new NullPointerException("method == null");
        }
        return new Sampler(){

            @Override
            public boolean isSampled(long traceId) {
                Boolean decision = DeclarativeSampler.this.sample(method).sampled();
                return decision != null ? decision : false;
            }
        };
    }

    public Sampler toSampler(final M method, final Sampler fallback) {
        if (method == null) {
            throw new NullPointerException("method == null");
        }
        if (fallback == null) {
            throw new NullPointerException("fallback == null");
        }
        return new Sampler(){

            @Override
            public boolean isSampled(long traceId) {
                Boolean decision = DeclarativeSampler.this.sample(method).sampled();
                if (decision == null) {
                    return fallback.isSampled(traceId);
                }
                return decision;
            }
        };
    }

    public SamplingFlags sample(@Nullable M method) {
        if (method == null) {
            return SamplingFlags.EMPTY;
        }
        Sampler sampler = (Sampler)this.methodsToSamplers.get(method);
        if (sampler == NULL_SENTINEL) {
            return SamplingFlags.EMPTY;
        }
        if (sampler != null) {
            return this.sample(sampler);
        }
        Float rate = this.rateForMethod.get(method);
        if (rate == null) {
            this.methodsToSamplers.put(method, NULL_SENTINEL);
            return SamplingFlags.EMPTY;
        }
        sampler = CountingSampler.create(rate.floatValue());
        Sampler previousSampler = this.methodsToSamplers.putIfAbsent(method, sampler);
        if (previousSampler != null) {
            sampler = previousSampler;
        }
        return this.sample(sampler);
    }

    private SamplingFlags sample(Sampler sampler) {
        return sampler.isSampled(0L) ? SamplingFlags.SAMPLED : SamplingFlags.NOT_SAMPLED;
    }

    public static interface RateForMethod<M> {
        @Nullable
        public Float get(M var1);
    }
}

