/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.producer;

import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.BeanParam;
import org.apache.servicecomb.swagger.generator.jaxrs.processor.annotation.BeanParamAnnotationProcessor;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import org.apache.servicecomb.swagger.invocation.arguments.ProviderParameter;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapperFactory;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerBeanParamMapper;
import org.springframework.stereotype.Component;

@Component
public class JaxRSProducerArgumentsMapperFactory
extends ProducerArgumentsMapperFactory {
    @Override
    public boolean canProcess(ArgumentsMapperConfig config) {
        return config.getSwaggerGeneratorContext().getClass().getCanonicalName().equals("org.apache.servicecomb.swagger.generator.jaxrs.JaxrsSwaggerGeneratorContext");
    }

    @Override
    protected Set<String> findAggregatedParamNames(Map<String, ProviderParameter> providerParamMap, Map<String, ProducerArgumentsMapperFactory.ParamWrapper<Parameter>> swaggerParamMap) {
        HashSet<String> aggregatedParamNames = new HashSet<String>();
        for (Map.Entry<String, ProviderParameter> providerParameterEntry : providerParamMap.entrySet()) {
            if (null == providerParameterEntry.getValue().getAnnotations()) continue;
            for (Annotation annotation : providerParameterEntry.getValue().getAnnotations()) {
                if (!(annotation instanceof BeanParam)) continue;
                aggregatedParamNames.add(providerParameterEntry.getKey());
            }
        }
        return aggregatedParamNames;
    }

    @Override
    protected void generateAggregatedParamMapper(ArgumentsMapperConfig config, Map<String, ProviderParameter> providerParamMap, Map<String, ProducerArgumentsMapperFactory.ParamWrapper<Parameter>> swaggerParamMap, Set<String> aggregatedParamNames) {
        for (String aggregatedProducerParamName : aggregatedParamNames) {
            ProviderParameter aggregatedParam = providerParamMap.get(aggregatedProducerParamName);
            Map<String, String> producerToSwaggerParamNameMapper = this.getProducerToSwaggerParamNameMap(aggregatedParam);
            HashMap<String, Integer> producerNameToSwaggerIndexMap = new HashMap<String, Integer>(producerToSwaggerParamNameMapper.size());
            for (Map.Entry<String, String> producerSwaggerNameMapEntry : producerToSwaggerParamNameMapper.entrySet()) {
                producerNameToSwaggerIndexMap.put(producerSwaggerNameMapEntry.getKey(), swaggerParamMap.get(producerSwaggerNameMapEntry.getValue()).getIndex());
            }
            ProducerBeanParamMapper mapper = new ProducerBeanParamMapper(producerNameToSwaggerIndexMap, aggregatedParam.getIndex(), aggregatedParam.getType());
            config.addArgumentMapper(mapper);
        }
    }

    private Map<String, String> getProducerToSwaggerParamNameMap(ProviderParameter aggregatedParam) {
        HashMap<String, String> producerToSwaggerParamNameMapper = new HashMap<String, String>();
        Class aggregatedParamClazz = (Class)aggregatedParam.getType();
        block0: for (Field field : aggregatedParamClazz.getDeclaredFields()) {
            for (Annotation fieldAnnotation : field.getAnnotations()) {
                if (!BeanParamAnnotationProcessor.SUPPORTED_PARAM_ANNOTATIONS.contains(fieldAnnotation.annotationType())) continue;
                producerToSwaggerParamNameMapper.put(field.getName(), JaxRSProducerArgumentsMapperFactory.retrieveVisibleParamName(fieldAnnotation));
                continue block0;
            }
        }
        block2: for (AccessibleObject accessibleObject : aggregatedParamClazz.getDeclaredMethods()) {
            String methodName = ((Method)accessibleObject).getName();
            if (!methodName.startsWith("set")) continue;
            for (Annotation setterAnnotation : accessibleObject.getAnnotations()) {
                if (!BeanParamAnnotationProcessor.SUPPORTED_PARAM_ANNOTATIONS.contains(setterAnnotation.annotationType())) continue;
                producerToSwaggerParamNameMapper.put(methodName.substring("set".length(), "set".length() + 1).toLowerCase() + methodName.substring("set".length() + 1), JaxRSProducerArgumentsMapperFactory.retrieveVisibleParamName(setterAnnotation));
                continue block2;
            }
        }
        return producerToSwaggerParamNameMapper;
    }
}

