/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class QueryRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String PARAM_KEY = "param";
    public static final String REGEXP_KEY = "regexp";

    public QueryRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(PARAM_KEY, REGEXP_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        return exchange -> {
            if (!StringUtils.hasText((String)config.regexp)) {
                return exchange.getRequest().getQueryParams().containsKey((Object)config.param);
            }
            List values = (List)exchange.getRequest().getQueryParams().get((Object)config.param);
            if (values == null) {
                return false;
            }
            for (String value : values) {
                if (value == null || !value.matches(config.regexp)) continue;
                return true;
            }
            return false;
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String param;
        private String regexp;

        public String getParam() {
            return this.param;
        }

        public Config setParam(String param) {
            this.param = param;
            return this;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }
    }
}

