/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.registry.lightweight.MicroserviceInfo;
import org.apache.servicecomb.registry.lightweight.model.Microservice;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstance;

@Path(value="/v1/discovery")
public interface DiscoveryClient {
    @Path(value="/info")
    @GET
    @Operation(summary="", operationId="getInfo")
    public CompletableFuture<MicroserviceInfo> getInfoAsync(Endpoint var1, @QueryParam(value="service-id") String var2);

    default public MicroserviceInfo getInfo(Endpoint endpoint, String serviceId) {
        return (MicroserviceInfo)AsyncUtils.toSync(this.getInfoAsync(endpoint, serviceId));
    }

    @Path(value="/microservice")
    @GET
    @Operation(summary="", operationId="getMicroservice")
    public CompletableFuture<Microservice> getMicroserviceAsync(Endpoint var1, @QueryParam(value="service-id") String var2);

    default public Microservice getMicroservice(Endpoint endpoint, String serviceId) {
        return (Microservice)AsyncUtils.toSync(this.getMicroserviceAsync(endpoint, serviceId));
    }

    @Path(value="/instance")
    @GET
    @Operation(summary="", operationId="getInstance")
    public CompletableFuture<MicroserviceInstance> getInstanceAsync(Endpoint var1, @QueryParam(value="service-id") String var2);

    default public MicroserviceInstance getInstance(Endpoint endpoint, String serviceId) {
        return (MicroserviceInstance)AsyncUtils.toSync(this.getInstanceAsync(endpoint, serviceId));
    }

    @Path(value="/schemas/{schema-id}")
    @GET
    @Produces(value={"text/plain"})
    @Operation(summary="", operationId="getSchema")
    public CompletableFuture<String> getSchemaAsync(Endpoint var1, @QueryParam(value="service-id") String var2, @PathParam(value="schema-id") String var3);

    default public String getSchema(Endpoint endpoint, String serviceId, String schemaId) {
        return (String)AsyncUtils.toSync(this.getSchemaAsync(endpoint, serviceId, schemaId));
    }
}

