/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.sc;

import com.google.common.base.Charsets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.Hashing;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.config.DataCenterProperties;
import org.apache.servicecomb.foundation.common.event.SimpleEventBus;
import org.apache.servicecomb.registry.RegistrationId;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.sc.MicroserviceHandler;
import org.apache.servicecomb.registry.sc.SCConfigurationProperties;
import org.apache.servicecomb.registry.sc.SCRegistrationInstance;
import org.apache.servicecomb.service.center.client.RegistrationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterRegistration;
import org.apache.servicecomb.service.center.client.ServiceCenterWatch;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.apache.servicecomb.service.center.client.model.SchemaInfo;
import org.apache.servicecomb.service.center.client.model.ServiceCenterConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class SCRegistration
implements Registration<SCRegistrationInstance> {
    private final EventBus eventBus = new SimpleEventBus();
    private Microservice microservice;
    private MicroserviceInstance microserviceInstance;
    private ServiceCenterRegistration serviceCenterRegistration;
    private final ServiceCenterClient serviceCenterClient;
    private final ServiceCenterWatch serviceCenterWatch;
    private final SCConfigurationProperties configurationProperties;
    private SCRegistrationInstance registrationInstance;
    private DataCenterProperties dataCenterProperties;
    private Environment environment;
    private RegistrationId registrationId;
    private CountDownLatch readyWaiter = new CountDownLatch(1);

    @Autowired
    public SCRegistration(SCConfigurationProperties configurationProperties, ServiceCenterClient serviceCenterClient, ServiceCenterWatch serviceCenterWatch) {
        this.configurationProperties = configurationProperties;
        this.serviceCenterClient = serviceCenterClient;
        this.serviceCenterWatch = serviceCenterWatch;
    }

    @Autowired
    public void setDataCenterProperties(DataCenterProperties dataCenterProperties) {
        this.dataCenterProperties = dataCenterProperties;
    }

    @Autowired
    public void setRegistrationId(RegistrationId registrationId) {
        this.registrationId = registrationId;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void init() {
        this.microservice = MicroserviceHandler.createMicroservice(this.environment);
        this.microserviceInstance = MicroserviceHandler.createMicroserviceInstance(this.environment, this.configurationProperties, this.dataCenterProperties);
        this.microserviceInstance.setInstanceId(this.registrationId.getInstanceId());
        this.serviceCenterRegistration = new ServiceCenterRegistration(this.serviceCenterClient, new ServiceCenterConfiguration().setCanOverwriteSwagger(this.configurationProperties.isCanOverwriteSwagger()).setCanOverwriteSwagger(this.configurationProperties.isCanOverwriteSwagger()), this.eventBus);
        this.serviceCenterRegistration.setMicroservice(this.microservice);
        this.serviceCenterRegistration.setMicroserviceInstance(this.microserviceInstance);
        this.registrationInstance = new SCRegistrationInstance(this.microservice, this.microserviceInstance, this.serviceCenterRegistration);
        this.eventBus.register((Object)this);
    }

    public void run() {
        try {
            this.serviceCenterRegistration.startRegistration();
            if (!this.readyWaiter.await(this.configurationProperties.getRegistrationWaitTimeInMillis(), TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException(String.format("registration timeout after %s milli seconds.", this.configurationProperties.getRegistrationWaitTimeInMillis()));
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("registration process is interrupted.");
        }
    }

    @Subscribe
    public void onMicroserviceInstanceRegistrationEvent(RegistrationEvents.MicroserviceInstanceRegistrationEvent event) {
        if (!event.isSuccess()) {
            return;
        }
        this.readyWaiter.countDown();
        if (this.configurationProperties.isWatch()) {
            this.serviceCenterWatch.startWatch("default", this.microservice.getServiceId());
        }
    }

    public void destroy() {
        if (this.serviceCenterRegistration != null) {
            this.serviceCenterRegistration.stop();
        }
    }

    public String name() {
        return "sc-registry";
    }

    public SCRegistrationInstance getMicroserviceInstance() {
        return this.registrationInstance;
    }

    public boolean updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        return this.serviceCenterClient.updateMicroserviceInstanceStatus(this.microservice.getServiceId(), this.microserviceInstance.getInstanceId(), org.apache.servicecomb.service.center.client.model.MicroserviceInstanceStatus.valueOf((String)status.name()));
    }

    public void addSchema(String schemaId, String content) {
        if (this.configurationProperties.isEnableSwaggerRegistration()) {
            this.microservice.addSchema(schemaId);
            this.serviceCenterRegistration.addSchemaInfo(new SchemaInfo(schemaId, content, SCRegistration.calcSchemaSummary(content)));
        }
    }

    public static String calcSchemaSummary(String schemaContent) {
        return Hashing.sha256().newHasher().putString((CharSequence)schemaContent, Charsets.UTF_8).hash().toString();
    }

    public void addEndpoint(String endpoint) {
        this.microserviceInstance.addEndpoint(endpoint);
    }

    public void addProperty(String key, String value) {
        this.microserviceInstance.addProperty(key, value);
    }

    public boolean enabled() {
        return this.configurationProperties.isEnabled();
    }

    public Microservice getBackendMicroservice() {
        return this.microservice;
    }

    public MicroserviceInstance getBackendMicroserviceInstance() {
        return this.microserviceInstance;
    }

    EventBus getEventBus() {
        return this.eventBus;
    }
}

