/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.scripting.bundle.tracker.internal.AbstractBundledRenderUnit;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;

class Script
extends AbstractBundledRenderUnit {
    private final URL url;
    private final ScriptEngine scriptEngine;
    private String sourceCode;
    private CompiledScript compiledScript = null;
    private Lock compilationLock = new ReentrantLock();
    private Lock readLock = new ReentrantLock();

    Script(Bundle bundle, URL url, ScriptEngine scriptEngine) {
        super(bundle);
        this.url = url;
        this.scriptEngine = scriptEngine;
    }

    private String getSourceCode() throws IOException {
        if (this.sourceCode == null) {
            this.readLock.lock();
            try {
                if (this.sourceCode == null) {
                    this.sourceCode = IOUtils.toString((InputStream)this.url.openStream(), (Charset)StandardCharsets.UTF_8);
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return this.sourceCode;
    }

    @Override
    @NotNull
    public String getName() {
        return this.url.getPath();
    }

    @Override
    @NotNull
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public void eval(@NotNull ScriptContext context) throws ScriptException {
        try {
            if (this.scriptEngine instanceof Compilable && this.compiledScript == null) {
                this.compilationLock.lock();
                try {
                    if (this.compiledScript == null) {
                        this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile((Reader)new ScriptNameAwareReader((Reader)new StringReader(this.getSourceCode()), this.getName()));
                    }
                }
                finally {
                    this.compilationLock.unlock();
                }
            }
            if (this.compiledScript != null) {
                this.compiledScript.eval(context);
            } else {
                this.scriptEngine.eval(this.getSourceCode(), context);
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }
}

