/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EspReader
extends FilterReader {
    private final Logger log = LoggerFactory.getLogger(EspReader.class);
    private static final byte PARSE_STATE_ESP = 1;
    private static final byte PARSE_STATE_ECMA = 2;
    private static final byte PARSE_STATE_ECMA_EXPR = 3;
    private static final byte PARSE_STATE_ECMA_EXPR_COMPACT = 4;
    private static final byte PARSE_STATE_JSP_COMMENT = 5;
    private static final byte PARSE_STATE_QUOTE = 6;
    private static final byte PARSE_STATE_VERBATIM = 7;
    private static final byte PARSE_STATE_ECMA_COMMENT = 8;
    private static final byte PARSE_STATE_ECMA_COMMENTL = 9;
    private PushbackReader input;
    private byte state;
    private Stack<Byte> stateStack;
    private boolean lineStart;
    private int verbatimChars;
    private char quoteChar;
    private boolean escape;
    private boolean outUndefined = true;
    public static final String DEFAULT_OUT_INIT_STATEMENT = "out=response.writer;";
    private String outInitStatement = "out=response.writer;";

    public EspReader(Reader baseReader) {
        super(baseReader);
        this.input = new PushbackReader(baseReader, 100);
        this.stateStack = new Stack();
        this.lineStart = true;
        this.verbatimChars = -1;
        this.quoteChar = '\u0000';
        this.escape = false;
        this.pushState((byte)1);
    }

    public void setOutInitStatement(String statement) {
        this.outInitStatement = statement;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.input.ready();
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.doRead();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int i = 0;
        while (i < len && (c = this.doRead()) >= 0) {
            cbuf[off] = (char)c;
            ++i;
            ++off;
        }
        return i == 0 ? -1 : i;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        long i = -1L;
        while (++i < n && this.doRead() >= 0) {
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        super.close();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    private int doRead() throws IOException {
        int c;
        block10: while (true) {
            if ((c = this.input.read()) < 0) {
                if (!this.lineStart && this.state == 1) {
                    this.doVerbatim("\");");
                    this.lineStart = true;
                    continue;
                }
                return c;
            }
            switch (this.state) {
                case 1: {
                    int c4;
                    int c3;
                    if (c == 36) {
                        int c2 = this.input.read();
                        if (c2 == 123) {
                            this.pushState((byte)4);
                            this.startWrite(null);
                            if (this.lineStart) continue block10;
                            this.doVerbatim("\");");
                            continue block10;
                        }
                        this.input.unread(c2);
                    } else if (c == 60) {
                        int c2 = this.input.read();
                        c3 = this.input.read();
                        if (c2 == 37) {
                            if (c3 == 61) {
                                this.pushState((byte)3);
                                this.startWrite(null);
                                if (this.lineStart) continue block10;
                                this.doVerbatim("\");");
                                continue block10;
                            }
                            if (c3 == 45) {
                                c4 = this.input.read();
                                if (c4 == 45) {
                                    this.pushState((byte)5);
                                    continue block10;
                                }
                                this.input.unread(c4);
                            }
                            this.input.unread(c3);
                            this.pushState((byte)2);
                            if (this.lineStart) continue block10;
                            this.doVerbatim("\");");
                            continue block10;
                        }
                        this.input.unread(c3);
                        this.input.unread(c2);
                    } else {
                        if (c == 13 || c == 10) {
                            String lineEnd;
                            if (c == 13) {
                                int c2 = this.input.read();
                                if (c2 != 10) {
                                    this.input.unread(c2);
                                    lineEnd = "\\r";
                                } else {
                                    lineEnd = "\\r\\n";
                                }
                            } else {
                                lineEnd = "\\n";
                            }
                            if (!this.lineStart) {
                                this.doVerbatim("\");\n");
                                this.doVerbatim(lineEnd);
                                this.lineStart = true;
                                continue block10;
                            }
                            this.doVerbatim("\");\n");
                            this.doVerbatim(lineEnd);
                            this.startWrite("\"");
                            continue block10;
                        }
                        if (c == 34 || c == 92) {
                            this.doVerbatim(String.valueOf((char)c));
                            c = 92;
                        }
                    }
                    if (!this.lineStart) break block10;
                    this.lineStart = false;
                    this.startWrite("\"" + (char)c);
                    continue block10;
                }
                case 2: 
                case 3: {
                    if (c == 37) {
                        int c2 = this.input.read();
                        if (c2 == 62) {
                            if (this.popState() == 3) {
                                this.doVerbatim(");");
                            }
                            this.lineStart = true;
                            continue block10;
                        }
                        this.input.unread(c2);
                        break block10;
                    }
                    if (c == 47) {
                        int c2 = this.input.read();
                        if (c2 == 47) {
                            this.pushState((byte)9);
                        } else if (c2 == 42) {
                            this.pushState((byte)8);
                        }
                        this.input.unread(c2);
                        break block10;
                    }
                    if (c != 39 && c != 34) break block10;
                    this.escape = false;
                    this.quoteChar = (char)c;
                    this.pushState((byte)6);
                    break block10;
                }
                case 4: {
                    if (c != 125) break block10;
                    this.popState();
                    this.doVerbatim(");");
                    this.lineStart = true;
                    continue block10;
                }
                case 5: {
                    int c4;
                    int c3;
                    if (c == 45) {
                        int c2 = this.input.read();
                        if (c2 == 45) {
                            c3 = this.input.read();
                            if (c3 == 37) {
                                c4 = this.input.read();
                                if (c4 == 62) {
                                    this.popState();
                                    continue block10;
                                }
                                this.input.unread(c4);
                            }
                            this.input.unread(c3);
                        }
                        this.input.unread(c2);
                        continue block10;
                    }
                    if (c != 13 && c != 10) continue block10;
                    if (this.lineStart) break block10;
                    this.input.unread(c);
                    this.doVerbatim("\");");
                    this.lineStart = true;
                    continue block10;
                }
                case 6: {
                    if (c == this.quoteChar && !this.escape) {
                        this.popState();
                        break block10;
                    }
                    this.escape = c == 92 && !this.escape;
                    break block10;
                }
                case 7: {
                    if (--this.verbatimChars >= 0) break block10;
                    this.popState();
                    break block10;
                }
                case 8: {
                    if (c != 42) break block10;
                    int c2 = this.input.read();
                    if (c2 == 47) {
                        this.popState();
                        this.doVerbatim("/");
                        break block10;
                    }
                    this.input.unread(c2);
                    break block10;
                }
                case 9: {
                    if (c == 13) {
                        int c2 = this.input.read();
                        if (c2 == 10) {
                            this.popState();
                        }
                        this.input.unread(c2);
                        break block10;
                    }
                    if (c != 10) break block10;
                    this.popState();
                    break block10;
                }
                default: {
                    this.log.warn("doRead(): unknown state " + this.state);
                    this.state = 1;
                }
            }
            break;
        }
        return c;
    }

    private void ensureOpen() throws IOException {
        if (this.input == null) {
            throw new IOException("Reader is closed");
        }
    }

    private void startWrite(String startString) throws IOException {
        if (startString != null && startString.length() > 0) {
            this.doVerbatim(startString);
        }
        this.doVerbatim("out.write(");
        if (this.outUndefined) {
            this.doVerbatim(this.outInitStatement);
            this.outUndefined = false;
        }
    }

    private void doVerbatim(String verbatimString) throws IOException {
        this.input.unread(verbatimString.toCharArray());
        this.verbatimChars += verbatimString.length();
        if (this.state != 7) {
            this.pushState((byte)7);
        }
    }

    private byte pushState(byte newState) {
        this.stateStack.push(this.state);
        this.state = newState;
        return this.state;
    }

    private byte popState() {
        byte oldState = this.state;
        this.state = this.stateStack.isEmpty() ? (byte)1 : this.stateStack.pop();
        return oldState;
    }
}

