/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

public class Type {
    public static final Type UNKNOWN = new Type("Object", false, null);
    public static final Type STRING = new Type("String", false, null);
    public static final Type LONG = new Type("long", true, 0);
    public static final Type DOUBLE = new Type("double", true, 0.0);
    public static final Type BOOLEAN = new Type("boolean", true, false);
    public static final Type MAP = new Type("java.util.Map", false, null);
    private String nativeClass;
    private final boolean isPrimitive;
    private final Object defaultValue;

    private Type(String nativeClass, boolean isPrimitive, Object defaultValue) {
        this.nativeClass = nativeClass;
        this.isPrimitive = isPrimitive;
        this.defaultValue = defaultValue;
    }

    public String getNativeClass() {
        return this.nativeClass;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public static Type dynamic(String type) {
        return new Type(type, false, null);
    }
}

