/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;

public class RoutinePermsDescriptor
extends PermissionsDescriptor {
    private UUID routineUUID;
    private String routineName;
    private boolean hasExecutePermission;

    public RoutinePermsDescriptor(DataDictionary dataDictionary, String string, String string2, UUID uUID, boolean bl) throws StandardException {
        super(dataDictionary, string, string2);
        this.routineUUID = uUID;
        this.hasExecutePermission = bl;
        if (uUID != null) {
            this.routineName = dataDictionary.getAliasDescriptor(uUID).getObjectName();
        }
    }

    public RoutinePermsDescriptor(DataDictionary dataDictionary, String string, String string2, UUID uUID) throws StandardException {
        this(dataDictionary, string, string2, uUID, true);
    }

    public RoutinePermsDescriptor(DataDictionary dataDictionary, String string, String string2) throws StandardException {
        this(dataDictionary, string, string2, null);
    }

    public RoutinePermsDescriptor(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        this(dataDictionary, null, null, null, true);
        this.oid = uUID;
    }

    public int getCatalogNumber() {
        return 18;
    }

    public UUID getRoutineUUID() {
        return this.routineUUID;
    }

    public boolean getHasExecutePermission() {
        return this.hasExecutePermission;
    }

    public String toString() {
        return "routinePerms: grantee=" + this.getGrantee() + ",routinePermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",routineUUID=" + this.getRoutineUUID();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RoutinePermsDescriptor)) {
            return false;
        }
        RoutinePermsDescriptor routinePermsDescriptor = (RoutinePermsDescriptor)object;
        return super.keyEquals(routinePermsDescriptor) && this.routineUUID.equals(routinePermsDescriptor.routineUUID);
    }

    public int hashCode() {
        return super.keyHashCode() + this.routineUUID.hashCode();
    }

    public boolean checkOwner(String string) throws StandardException {
        UUID uUID = this.getDataDictionary().getAliasDescriptor(this.routineUUID).getSchemaUUID();
        return this.getDataDictionary().getSchemaDescriptor(uUID, null).getAuthorizationId().equals(string);
    }

    public String getObjectName() {
        return "Routine Privilege on " + this.routineName;
    }

    public String getClassType() {
        return "RoutinePrivilege";
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(461);
    }
}

