/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Util;

public class SqlLikeOperator
extends SqlSpecialOperator {
    private final boolean negated;

    SqlLikeOperator(String name, SqlKind kind, boolean negated) {
        super(name, kind, 32, false, ReturnTypes.BOOLEAN_NULLABLE, InferTypes.FIRST_KNOWN, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME_SAME);
        this.negated = negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        switch (callBinding.getOperandCount()) {
            case 2: {
                if (OperandTypes.STRING_SAME_SAME.checkOperandTypes(callBinding, throwOnFailure)) break;
                return false;
            }
            case 3: {
                if (OperandTypes.STRING_SAME_SAME_SAME.checkOperandTypes(callBinding, throwOnFailure)) break;
                return false;
            }
            default: {
                throw Util.newInternal("unexpected number of args to " + callBinding.getCall());
            }
        }
        return SqlTypeUtil.isCharTypeComparable(callBinding, callBinding.operands(), throwOnFailure);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        ((SqlNode)call.operand(0)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        writer.sep(this.getName());
        ((SqlNode)call.operand(1)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        if (call.operandCount() == 3) {
            writer.sep("ESCAPE");
            ((SqlNode)call.operand(2)).unparse(writer, this.getLeftPrec(), this.getRightPrec());
        }
        writer.endList(frame);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int opOrdinal, SqlSpecialOperator.TokenSequence list) {
        int end;
        SqlNode[] operands;
        SqlOperator op2;
        SqlNode exp0 = list.node(opOrdinal - 1);
        SqlOperator op = list.op(opOrdinal);
        assert (op instanceof SqlLikeOperator);
        SqlNode exp1 = SqlParserUtil.toTreeEx(list, opOrdinal + 1, this.getRightPrec(), SqlKind.ESCAPE);
        SqlNode exp2 = null;
        if (opOrdinal + 2 < list.size() && list.isOp(opOrdinal + 2) && (op2 = list.op(opOrdinal + 2)).getKind() == SqlKind.ESCAPE) {
            exp2 = SqlParserUtil.toTreeEx(list, opOrdinal + 3, this.getRightPrec(), SqlKind.ESCAPE);
        }
        if (exp2 != null) {
            operands = new SqlNode[]{exp0, exp1, exp2};
            end = opOrdinal + 4;
        } else {
            operands = new SqlNode[]{exp0, exp1};
            end = opOrdinal + 2;
        }
        SqlCall call = this.createCall(SqlParserPos.ZERO, operands);
        return new SqlSpecialOperator.ReduceResult(this, opOrdinal - 1, end, call);
    }
}

