/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;

public class BinaryCellToTextConverter
implements Converter<MatrixIndexes, MatrixCell, NullWritable, Text> {
    private Text value = new Text();
    private Pair<NullWritable, Text> pair = new Pair<NullWritable, Text>(NullWritable.get(), this.value);
    private boolean hasValue = false;

    @Override
    public void convert(MatrixIndexes k1, MatrixCell v1) {
        double v = v1.getValue();
        this.value.set(k1.getRowIndex() + " " + k1.getColumnIndex() + " " + v);
        this.hasValue = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasValue;
    }

    @Override
    public Pair<NullWritable, Text> next() {
        if (!this.hasValue) {
            return null;
        }
        this.hasValue = false;
        return this.pair;
    }

    @Override
    public void setBlockSize(int rl, int cl) {
    }
}

