/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.ColumnGroupPartitioner;
import org.apache.sysds.runtime.compress.cocode.ColumnGroupPartitionerBinPacking;
import org.apache.sysds.runtime.compress.cocode.ColumnGroupPartitionerStatic;
import org.apache.sysds.runtime.compress.cocode.PlanningCoCodingGroup;
import org.apache.sysds.runtime.compress.cocode.PlanningMemoTable;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class PlanningCoCoder {
    private static final Log LOG = LogFactory.getLog((String)PlanningCoCoder.class.getName());

    public static List<int[]> findCoCodesByPartitioning(CompressedSizeEstimator sizeEstimator, CompressedSizeInfo colInfos, int numRows, int k, CompressionSettings cs) {
        List<Integer> cols = colInfos.colsC;
        CompressedSizeInfoColGroup[] colGroups = colInfos.compressionInfo;
        int numCols = cols.size();
        ArrayList<Integer> groupCols = new ArrayList<Integer>();
        HashMap<Integer, GroupableColInfo> groupColsInfo = new HashMap<Integer, GroupableColInfo>();
        for (int i = 0; i < numCols; ++i) {
            int colIx = cols.get(i);
            double cardinality = colGroups[colIx].getEstCard();
            double weight = cardinality / (double)numRows;
            groupCols.add(colIx);
            groupColsInfo.put(colIx, new GroupableColInfo(weight, colGroups[colIx].getMinSize()));
        }
        List<int[]> bins = PlanningCoCoder.createColumnGroupPartitioner(cs.columnPartitioner).partitionColumns(groupCols, groupColsInfo, cs);
        return k > 1 ? PlanningCoCoder.getCocodingGroupsBruteForce(bins, groupColsInfo, sizeEstimator, numRows, k) : PlanningCoCoder.getCocodingGroupsBruteForce(bins, groupColsInfo, sizeEstimator, numRows);
    }

    private static List<int[]> getCocodingGroupsBruteForce(List<int[]> bins, HashMap<Integer, GroupableColInfo> groupColsInfo, CompressedSizeEstimator estimator, int rlen) {
        ArrayList<int[]> retGroups = new ArrayList<int[]>();
        for (int[] bin : bins) {
            PlanningCoCodingGroup[] outputGroups;
            ArrayList<PlanningCoCodingGroup> sgroups = new ArrayList<PlanningCoCodingGroup>();
            for (int col : bin) {
                sgroups.add(new PlanningCoCodingGroup(col, groupColsInfo.get(col)));
            }
            for (PlanningCoCodingGroup grp : outputGroups = PlanningCoCoder.findCocodesBruteForce(estimator, rlen, sgroups.toArray(new PlanningCoCodingGroup[0]))) {
                retGroups.add(grp.getColIndices());
            }
        }
        return retGroups;
    }

    private static List<int[]> getCocodingGroupsBruteForce(List<int[]> bins, HashMap<Integer, GroupableColInfo> groupColsInfo, CompressedSizeEstimator estimator, int rlen, int k) {
        ArrayList<int[]> retGroups = new ArrayList<int[]>();
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<CocodeTask> tasks = new ArrayList<CocodeTask>();
            for (int[] bin : bins) {
                ArrayList<PlanningCoCodingGroup> sgroups = new ArrayList<PlanningCoCodingGroup>();
                for (int col : bin) {
                    sgroups.add(new PlanningCoCodingGroup(col, groupColsInfo.get(col)));
                }
                tasks.add(new CocodeTask(estimator, sgroups, rlen));
            }
            List rtask = pool.invokeAll(tasks);
            for (Future lrtask : rtask) {
                for (PlanningCoCodingGroup grp : (PlanningCoCodingGroup[])lrtask.get()) {
                    retGroups.add(grp.getColIndices());
                }
            }
            pool.shutdown();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return retGroups;
    }

    private static PlanningCoCodingGroup[] findCocodesBruteForce(CompressedSizeEstimator estimator, int numRows, PlanningCoCodingGroup[] singletonGroups) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Cocoding: process " + singletonGroups.length));
        }
        ArrayList<PlanningCoCodingGroup> workset = new ArrayList<PlanningCoCodingGroup>(Arrays.asList(singletonGroups));
        PlanningMemoTable memo = new PlanningMemoTable();
        boolean changed = true;
        while (changed && workset.size() > 1) {
            PlanningCoCodingGroup tmp = null;
            for (int i = 0; i < workset.size(); ++i) {
                for (int j = i + 1; j < workset.size(); ++j) {
                    PlanningCoCodingGroup c1 = (PlanningCoCodingGroup)workset.get(i);
                    PlanningCoCodingGroup c2 = (PlanningCoCodingGroup)workset.get(j);
                    memo.incrStats(1, 0, 0);
                    if ((double)(-Math.min(c1.getEstSize(), c2.getEstSize())) > memo.getOptChangeInSize()) continue;
                    PlanningCoCodingGroup c1c2 = memo.getOrCreate(c1, c2, estimator, numRows);
                    if (tmp != null && !(c1c2.getChangeInSize() < tmp.getChangeInSize()) && (c1c2.getChangeInSize() != tmp.getChangeInSize() || c1c2.getColIndices().length >= tmp.getColIndices().length)) continue;
                    tmp = c1c2;
                }
            }
            if (tmp != null && tmp.getChangeInSize() < 0.0) {
                workset.remove(tmp.getLeftGroup());
                workset.remove(tmp.getRightGroup());
                workset.add(tmp);
                memo.remove(tmp);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("--merge groups: " + Arrays.toString(tmp.getLeftGroup().getColIndices()) + " and " + Arrays.toString(tmp.getRightGroup().getColIndices())));
                continue;
            }
            changed = false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("--stats: " + Arrays.toString(memo.getStats())));
        }
        return workset.toArray(new PlanningCoCodingGroup[0]);
    }

    private static ColumnGroupPartitioner createColumnGroupPartitioner(PartitionerType type) {
        switch (type) {
            case BIN_PACKING: {
                return new ColumnGroupPartitionerBinPacking();
            }
            case STATIC: {
                return new ColumnGroupPartitionerStatic();
            }
        }
        throw new RuntimeException("Unsupported column group partitioner: " + type.toString());
    }

    private static class CocodeTask
    implements Callable<PlanningCoCodingGroup[]> {
        private CompressedSizeEstimator _estim = null;
        private ArrayList<PlanningCoCodingGroup> _sgroups = null;
        private int _rlen = -1;

        protected CocodeTask(CompressedSizeEstimator estim, ArrayList<PlanningCoCodingGroup> sgroups, int rlen) {
            this._estim = estim;
            this._sgroups = sgroups;
            this._rlen = rlen;
        }

        @Override
        public PlanningCoCodingGroup[] call() {
            return PlanningCoCoder.findCocodesBruteForce(this._estim, this._rlen, this._sgroups.toArray(new PlanningCoCodingGroup[0]));
        }
    }

    public static class GroupableColInfo {
        public final double cardRatio;
        public final long size;

        public GroupableColInfo(double lcardRatio, long lsize) {
            this.cardRatio = lcardRatio;
            this.size = lsize;
        }
    }

    public static enum PartitionerType {
        BIN_PACKING,
        STATIC;

    }
}

