/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionSparse
extends ReaderColumnSelection {
    private DblArray reusableReturn;
    private double[] reusableArr;
    private SparseRow[] sparseCols = null;
    private int[] sparsePos = null;

    public ReaderColumnSelectionSparse(MatrixBlock data, int[] colIndexes, CompressionSettings compSettings) {
        super(colIndexes, compSettings.transposeInput ? data.getNumColumns() : data.getNumRows(), compSettings);
        this.reusableArr = new double[colIndexes.length];
        this.reusableReturn = null;
        if (!this._compSettings.transposeInput) {
            throw new RuntimeException("SparseColumnSelectionReader should not be used without transposed input.");
        }
        this.sparseCols = new SparseRow[colIndexes.length];
        this.sparsePos = new int[colIndexes.length];
        if (data.getSparseBlock() != null) {
            for (int i = 0; i < colIndexes.length; ++i) {
                this.sparseCols[i] = data.getSparseBlock().get(colIndexes[i]);
            }
        }
    }

    @Override
    protected DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        if (!this._compSettings.transposeInput) {
            throw new RuntimeException("SparseColumnSelectionReader should not be used without transposed input.");
        }
        for (int i = 0; i < this._colIndexes.length; ++i) {
            if (this.sparseCols[i] == null || this.sparseCols[i].indexes().length > this.sparsePos[i] && this.sparseCols[i].indexes()[this.sparsePos[i]] >= this._lastRow) continue;
            int n = i;
            this.sparsePos[n] = this.sparsePos[n] + 1;
        }
        Arrays.fill(this.reusableArr, 0.0);
        boolean zeroResult = true;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            if (this.sparseCols[i] == null || this.sparseCols[i].indexes().length <= this.sparsePos[i] || this.sparseCols[i].indexes()[this.sparsePos[i]] != this._lastRow) continue;
            this.reusableArr[i] = this.sparseCols[i].values()[this.sparsePos[i]];
            zeroResult = false;
        }
        return zeroResult ? null : this.reusableReturn;
    }
}

