/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.sysds.test.functions.lineage;

import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.test.TestConfiguration;
import org.apache.sysds.test.TestUtils;
import org.junit.Test;
import org.junit.Assert;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;

public class LineageExploitationBufferPoolTest extends LineageBase
{
	protected static final String TEST_DIR = "functions/lineage/";
	protected static final String TEST_NAME1 = "LineageExploitationBufferPool1";
	protected static final String TEST_NAME2 = "LineageExploitationBufferPool2";
	protected String TEST_CLASS_DIR = TEST_DIR + LineageExploitationBufferPoolTest.class.getSimpleName() + "/";

	@Override
	public void setUp() {
		TestUtils.clearAssertionInformation();
		addTestConfiguration(TEST_NAME1, new TestConfiguration(TEST_CLASS_DIR, TEST_NAME1));
		addTestConfiguration(TEST_NAME2, new TestConfiguration(TEST_CLASS_DIR, TEST_NAME2));
	}

	@Test
	public void testLineageInBufferpool1() {
		testLineageExploitationBufferPool(TEST_NAME1);
	}
	
	@Test
	public void testLineageInBufferpool2() {
		testLineageExploitationBufferPool(TEST_NAME2);
	}

	public void testLineageExploitationBufferPool(String testname) {
		boolean old_simplification = OptimizerUtils.ALLOW_ALGEBRAIC_SIMPLIFICATION;
		boolean old_sum_product = OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES;

		try {
			LOG.debug("------------ BEGIN " + testname + "------------");

			OptimizerUtils.ALLOW_ALGEBRAIC_SIMPLIFICATION = false;
			OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES = false;

			getAndLoadTestConfiguration(testname);
			fullDMLScriptName = getScript();
			programArgs = new String[]{"-stats", "-explain", "-args", output("Z")};

			runTest(true, EXCEPTION_NOT_EXPECTED, null, -1);

			if( testname.equals(TEST_NAME1) ) {
				Assert.assertEquals(6, CacheStatistics.getLinWrites());
				String[] writes = CacheStatistics.displayWrites().split("/");
				Assert.assertEquals(6, Long.parseLong(writes[0])); // writes WB
				Assert.assertEquals(5, Long.parseLong(writes[1])); // writes WB
			}
			else {
				Assert.assertTrue(heavyHittersContainsString("+", 1, 22));
				Assert.assertTrue(CacheStatistics.getLinWrites()==5); //2 (+ 3 for 2x restore)
				Assert.assertTrue(CacheStatistics.getLinHits()==2);
			}
		} finally {
			OptimizerUtils.ALLOW_ALGEBRAIC_SIMPLIFICATION = old_simplification;
			OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES = old_sum_product;
			Recompiler.reinitRecompiler();
		}

	}
}
