/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.transform.encode.EncoderFactory;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;

public class MultiReturnParameterizedBuiltinCPInstruction
extends ComputationCPInstruction {
    protected final ArrayList<CPOperand> _outputs;
    protected final boolean _metaReturn;

    private MultiReturnParameterizedBuiltinCPInstruction(Operator op, CPOperand input1, CPOperand input2, boolean metaReturn, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, input2, outputs.get(0), opcode, istr);
        this._outputs = outputs;
        this._metaReturn = metaReturn;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public List<CPOperand> getOutputs() {
        return this._outputs;
    }

    public String[] getOutputNames() {
        return (String[])this._outputs.stream().map(CPOperand::getName).toArray(String[]::new);
    }

    public static MultiReturnParameterizedBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase(Opcodes.TRANSFORMENCODE.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            int pos = 3;
            boolean metaReturn = true;
            if (parts.length == 7) {
                metaReturn = new CPOperand(parts[pos++]).getLiteral().getBooleanValue();
            }
            outputs.add(new CPOperand(parts[pos], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[pos + 1], Types.ValueType.STRING, Types.DataType.FRAME));
            return new MultiReturnParameterizedBuiltinCPInstruction(null, in1, in2, metaReturn, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        FrameBlock fin = ec.getFrameInput(this.input1.getName());
        String spec = ec.getScalarInput(this.input2).getStringValue();
        String[] colnames = fin.getColumnNames();
        MultiColumnEncoder encoder = EncoderFactory.createEncoder(spec, colnames, fin.getNumColumns(), null);
        int k = OptimizerUtils.getTransformNumThreads();
        MatrixBlock data = encoder.encode(fin, OptimizerUtils.getTransformNumThreads());
        FrameBlock meta = !this._metaReturn ? new FrameBlock() : encoder.getMetaData(new FrameBlock(fin.getNumColumns(), Types.ValueType.STRING), k);
        meta.setColumnNames(colnames);
        ec.releaseFrameInput(this.input1.getName());
        ec.setMatrixOutput(this.getOutput(0).getName(), data);
        ec.setFrameOutput(this.getOutput(1).getName(), meta);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Memory size of metadata: " + meta.getInMemorySize()));
        }
    }

    @Override
    public boolean hasSingleLineage() {
        return false;
    }

    @Override
    public Pair<String, LineageItem>[] getLineageItems(ExecutionContext ec) {
        LineageItem[] inputLineage = LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3);
        Pair[] ret = new Pair[this._outputs.size()];
        for (int i = 0; i < this._outputs.size(); ++i) {
            CPOperand out = this._outputs.get(i);
            ret[i] = Pair.of((Object)out.getName(), (Object)new LineageItem(this.getOpcode(), inputLineage));
        }
        return ret;
    }

    public boolean getMetaReturn() {
        return this._metaReturn;
    }
}

