/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.io.WriterCompressed;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.functions.ComputeBinaryBlockNnzFunction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FileFormatPropertiesLIBSVM;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageTraceable;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.HDFSTool;

public class WriteSPInstruction
extends SPInstruction
implements LineageTraceable {
    public CPOperand input1 = null;
    private CPOperand input2 = null;
    private CPOperand input3 = null;
    private CPOperand input4 = null;
    private FileFormatProperties formatProperties;

    private WriteSPInstruction(CPOperand in1, CPOperand in2, CPOperand in3, String opcode, String str) {
        super(SPInstruction.SPType.Write, opcode, str);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this.formatProperties = null;
    }

    public static WriteSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equals(Opcodes.WRITE.toString())) {
            throw new DMLRuntimeException("Unsupported opcode");
        }
        if (parts.length != 6 && parts.length != 10) {
            throw new DMLRuntimeException("Invalid number of operands in write instruction: " + str);
        }
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        WriteSPInstruction inst = new WriteSPInstruction(in1, in2, in3, opcode, str);
        if (in3.getName().equalsIgnoreCase("csv")) {
            CPOperand in4;
            boolean hasHeader = Boolean.parseBoolean(parts[4]);
            String delim = parts[5];
            boolean sparse = Boolean.parseBoolean(parts[6]);
            FileFormatPropertiesCSV formatProperties = new FileFormatPropertiesCSV(hasHeader, delim, sparse);
            inst.setFormatProperties(formatProperties);
            inst.input4 = in4 = new CPOperand(parts[8]);
        } else if (in3.getName().equalsIgnoreCase("libsvm")) {
            CPOperand in4;
            String delim = parts[4];
            String indexDelim = parts[5];
            boolean sparse = Boolean.parseBoolean(parts[6]);
            FileFormatPropertiesLIBSVM formatProperties = new FileFormatPropertiesLIBSVM(delim, indexDelim, sparse);
            inst.setFormatProperties(formatProperties);
            inst.input4 = in4 = new CPOperand(parts[8]);
        } else {
            CPOperand in4;
            FileFormatProperties ffp = new FileFormatProperties();
            inst.input4 = in4 = new CPOperand(parts[5]);
            inst.setFormatProperties(ffp);
        }
        return inst;
    }

    public FileFormatProperties getFormatProperties() {
        return this.formatProperties;
    }

    public void setFormatProperties(FileFormatProperties prop) {
        this.formatProperties = prop;
    }

    public CPOperand getInput1() {
        return this.input1;
    }

    public CPOperand getInput2() {
        return this.input2;
    }

    public CPOperand getInput3() {
        return this.input3;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        String fname = ec.getScalarInput(this.input2).getStringValue();
        String desc = ec.getScalarInput(this.input4).getStringValue();
        this.formatProperties.setDescription(desc);
        Types.ValueType[] schema = this.input1.getDataType() == Types.DataType.FRAME ? sec.getFrameObject(this.input1.getName()).getSchema() : null;
        try {
            HDFSTool.deleteFileIfExistOnHDFS(fname);
            String fmtStr = ec.getScalarInput(this.input3).getStringValue();
            Types.FileFormat fmt = Types.FileFormat.safeValueOf(fmtStr);
            switch (this.input1.getDataType()) {
                case MATRIX: {
                    this.processMatrixWriteInstruction(sec, fname, fmt);
                    break;
                }
                case FRAME: {
                    this.processFrameWriteInstruction(sec, fname, fmt, schema);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Unsupported data type " + this.input1.getDataType() + " in WriteSPInstruction.");
                }
            }
        }
        catch (IOException ex) {
            throw new DMLRuntimeException("Failed to process write instruction", ex);
        }
    }

    protected void processMatrixWriteInstruction(SparkExecutionContext sec, String fname, Types.FileFormat fmt) throws IOException {
        DataCharacteristics mc;
        JavaPairRDD in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        DataCharacteristics mcOut = mc = sec.getDataCharacteristics(this.input1.getName());
        if (fmt == Types.FileFormat.MM || fmt == Types.FileFormat.TEXT) {
            LongAccumulator aNnz = null;
            if (!mc.nnzKnown()) {
                aNnz = sec.getSparkContext().sc().longAccumulator("nnz");
                in1 = in1.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
            }
            JavaRDD header = null;
            if (fmt == Types.FileFormat.MM) {
                ArrayList<CallSite> headerContainer = new ArrayList<CallSite>(1);
                String headerStr = "%%MatrixMarket matrix coordinate real general\n" + mc.getRows() + " " + mc.getCols() + " " + mc.getNonZeros();
                headerContainer.add((CallSite)((Object)headerStr));
                header = sec.getSparkContext().parallelize(headerContainer);
            }
            JavaRDD<String> ijv = RDDConverterUtils.binaryBlockToTextCell(in1, mc);
            if (header != null) {
                WriteSPInstruction.customSaveTextFile((JavaRDD<String>)header.union(ijv), fname, true);
            } else {
                WriteSPInstruction.customSaveTextFile(ijv, fname, false);
            }
            if (!mc.nnzKnown()) {
                mc.setNonZeros(aNnz.value());
            }
        } else if (fmt == Types.FileFormat.CSV) {
            if (mc.getRows() == 0L || mc.getCols() == 0L) {
                throw new IOException("Write of matrices with zero rows or columns not supported (" + mc.getRows() + "x" + mc.getCols() + ").");
            }
            FileFormatProperties fprop = this.formatProperties instanceof FileFormatPropertiesCSV ? this.formatProperties : new FileFormatPropertiesCSV();
            LongAccumulator aNnz = null;
            if (!mc.nnzKnown()) {
                aNnz = sec.getSparkContext().sc().longAccumulator("nnz");
                in1 = in1.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
            }
            JavaRDD<String> out = RDDConverterUtils.binaryBlockToCsv(in1, mc, (FileFormatPropertiesCSV)fprop, true);
            WriteSPInstruction.customSaveTextFile(out, fname, false);
            if (!mc.nnzKnown()) {
                mc.setNonZeros(aNnz.value());
            }
        } else if (fmt == Types.FileFormat.BINARY) {
            boolean nonDefaultBlen;
            int blen = Integer.parseInt(this.input4.getName());
            boolean bl = nonDefaultBlen = ConfigurationManager.getBlocksize() != blen && blen > 0;
            if (nonDefaultBlen) {
                in1 = RDDConverterUtils.binaryBlockToBinaryBlock((JavaPairRDD<MatrixIndexes, MatrixBlock>)in1, mc, new MatrixCharacteristics(mc).setBlocksize(blen));
            }
            LongAccumulator aNnz = null;
            if (!mc.nnzKnown()) {
                aNnz = sec.getSparkContext().sc().longAccumulator("nnz");
                in1 = in1.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
            }
            in1.saveAsHadoopFile(fname, MatrixIndexes.class, MatrixBlock.class, SequenceFileOutputFormat.class);
            if (!mc.nnzKnown()) {
                mc.setNonZeros(aNnz.value());
            }
            if (nonDefaultBlen) {
                mcOut = new MatrixCharacteristics(mc).setBlocksize(blen);
            }
        } else if (fmt == Types.FileFormat.COMPRESSED) {
            int blen = Integer.parseInt(this.input4.getName());
            boolean nonDefaultBlen = ConfigurationManager.getBlocksize() != blen;
            mc.setNonZeros(-1L);
            if (nonDefaultBlen) {
                WriterCompressed.writeRDDToHDFS(in1, fname, blen, mc);
            } else {
                WriterCompressed.writeRDDToHDFS(in1, fname);
            }
            if (nonDefaultBlen) {
                mcOut = new MatrixCharacteristics(mc).setBlocksize(blen);
            }
        } else if (fmt == Types.FileFormat.LIBSVM) {
            if (mc.getRows() == 0L || mc.getCols() == 0L) {
                throw new IOException("Write of matrices with zero rows or columns not supported (" + mc.getRows() + "x" + mc.getCols() + ").");
            }
            LongAccumulator aNnz = null;
            if (!mc.nnzKnown()) {
                aNnz = sec.getSparkContext().sc().longAccumulator("nnz");
                in1 = in1.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
            }
            JavaRDD<String> out = RDDConverterUtils.binaryBlockToLibsvm(in1, mc, (FileFormatPropertiesLIBSVM)this.formatProperties, true);
            WriteSPInstruction.customSaveTextFile(out, fname, false);
            if (!mc.nnzKnown()) {
                mc.setNonZeros(aNnz.value());
            }
        } else {
            throw new DMLRuntimeException("Unexpected data format: " + fmt.toString());
        }
        HDFSTool.writeMetaDataFile(fname + ".mtd", Types.ValueType.FP64, mcOut, fmt, this.formatProperties);
    }

    protected void processFrameWriteInstruction(SparkExecutionContext sec, String fname, Types.FileFormat fmt, Types.ValueType[] schema) throws IOException {
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        DataCharacteristics mc = sec.getDataCharacteristics(this.input1.getName());
        switch (fmt) {
            case TEXT: {
                JavaRDD<String> out = FrameRDDConverterUtils.binaryBlockToTextCell(in1, mc);
                WriteSPInstruction.customSaveTextFile(out, fname, false);
                break;
            }
            case CSV: {
                FileFormatPropertiesCSV props = this.formatProperties != null ? (FileFormatPropertiesCSV)this.formatProperties : null;
                JavaRDD<String> out = FrameRDDConverterUtils.binaryBlockToCsv(in1, mc, props, true);
                WriteSPInstruction.customSaveTextFile(out, fname, false);
                break;
            }
            case LIBSVM: {
                break;
            }
            case BINARY: {
                JavaPairRDD out = in1.mapToPair((PairFunction)new FrameRDDConverterUtils.LongFrameToLongWritableFrameFunction());
                out.saveAsHadoopFile(fname, LongWritable.class, FrameBlock.class, SequenceFileOutputFormat.class);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected data format: " + fmt.toString());
            }
        }
        HDFSTool.writeMetaDataFile(fname + ".mtd", this.input1.getValueType(), schema, Types.DataType.FRAME, mc, fmt, this.formatProperties);
    }

    private static void customSaveTextFile(JavaRDD<String> rdd, String fname, boolean inSingleFile) {
        if (inSingleFile) {
            Random rand = new Random();
            String randFName = fname + "_" + rand.nextLong() + "_" + rand.nextLong();
            try {
                while (HDFSTool.existsFileOnHDFS(randFName)) {
                    randFName = fname + "_" + rand.nextLong() + "_" + rand.nextLong();
                }
                rdd.saveAsTextFile(randFName);
                HDFSTool.mergeIntoSingleFile(randFName, fname);
            }
            catch (IOException e) {
                throw new DMLRuntimeException("Cannot merge the output into single file: " + e.getMessage());
            }
            finally {
                try {
                    HDFSTool.deleteFileIfExistOnHDFS(randFName);
                }
                catch (IOException e) {
                    throw new DMLRuntimeException("Cannot merge the output into single file: " + e.getMessage());
                }
            }
        }
        rdd.saveAsTextFile(fname);
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        Object[] ret = LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3, this.input4);
        if (this.formatProperties != null && this.formatProperties.getDescription() != null && !this.formatProperties.getDescription().isEmpty()) {
            ret = (LineageItem[])ArrayUtils.add((Object[])ret, (Object)new LineageItem(this.formatProperties.getDescription()));
        }
        return Pair.of((Object)this.input1.getName(), (Object)new LineageItem(this.getOpcode(), (LineageItem[])ret));
    }
}

