/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.fastdoubleparser;

import ch.randelshofer.fastdoubleparser.AbstractFloatValueParser;
import ch.randelshofer.fastdoubleparser.FastDoubleSwar;

abstract class AbstractJsonFloatingPointBitsFromCharArray
extends AbstractFloatValueParser {
    AbstractJsonFloatingPointBitsFromCharArray() {
    }

    public final long parseNumber(char[] str, int offset, int length) {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = offset + length;
        if (offset < 0 || endIndex < offset || endIndex > str.length || length > 0x7FFFFFFB) {
            throw new IllegalArgumentException("offset < 0 or length > str.length");
        }
        int index = offset;
        char ch = AbstractJsonFloatingPointBitsFromCharArray.charAt(str, index, endIndex);
        boolean bl = isNegative = ch == '-';
        if (isNegative && (ch = AbstractJsonFloatingPointBitsFromCharArray.charAt(str, ++index, endIndex)) == '\u0000') {
            throw new NumberFormatException("illegal syntax");
        }
        boolean bl2 = hasLeadingZero = ch == '0';
        if (hasLeadingZero && (ch = AbstractJsonFloatingPointBitsFromCharArray.charAt(str, ++index, endIndex)) == '0') {
            throw new NumberFormatException("illegal syntax");
        }
        long significand = 0L;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        while (index < endIndex) {
            ch = str[index];
            if (FastDoubleSwar.isDigit(ch)) {
                significand = 10L * significand + (long)ch - 48L;
            } else {
                int digits;
                if (ch != '.') break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
                while (index < endIndex - 8 && (digits = this.tryToParseEightDigits(str, index + 1)) >= 0) {
                    significand = 100000000L * significand + (long)digits;
                    index += 8;
                }
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = index - significandStartIndex;
            virtualIndexOfPoint = index;
            exponent = 0;
        } else {
            digitCount = index - significandStartIndex - 1;
            exponent = virtualIndexOfPoint - index + 1;
        }
        int expNumber = 0;
        if ((ch | 0x20) == 101) {
            boolean isExponentNegative;
            boolean bl3 = isExponentNegative = (ch = AbstractJsonFloatingPointBitsFromCharArray.charAt(str, ++index, endIndex)) == '-';
            if (isExponentNegative || ch == '+') {
                ch = AbstractJsonFloatingPointBitsFromCharArray.charAt(str, ++index, endIndex);
            }
            illegal |= !FastDoubleSwar.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastDoubleSwar.isDigit(ch = AbstractJsonFloatingPointBitsFromCharArray.charAt(str, ++index, endIndex)));
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (illegal || index < endIndex || !hasLeadingZero && digitCount == 0) {
            throw new NumberFormatException("illegal syntax");
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                ch = str[index];
                if (ch == '.') {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)ch - 48L;
            }
            isSignificandTruncated = index < significandEndIndex;
            exponentOfTruncatedSignificand = virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return this.valueOfFloatLiteral(str, offset, endIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
    }

    private int tryToParseEightDigits(char[] str, int offset) {
        return FastDoubleSwar.tryToParseEightDigits(str, offset);
    }

    abstract long valueOfFloatLiteral(char[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);
}

