/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.Serializable;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public abstract class ADictionary
implements IDictionary,
Serializable {
    private static final long serialVersionUID = 9118692576356558592L;

    @Override
    public abstract IDictionary clone();

    @Override
    public final CM_COV_Object centralMoment(ValueFunction fn, int[] counts, int nRows) {
        return this.centralMoment(new CM_COV_Object(), fn, counts, nRows);
    }

    @Override
    public final CM_COV_Object centralMomentWithDefault(ValueFunction fn, int[] counts, double def, int nRows) {
        return this.centralMomentWithDefault(new CM_COV_Object(), fn, counts, def, nRows);
    }

    @Override
    public final CM_COV_Object centralMomentWithReference(ValueFunction fn, int[] counts, double reference, int nRows) {
        return this.centralMomentWithReference(new CM_COV_Object(), fn, counts, reference, nRows);
    }

    @Override
    public final boolean equals(Object o) {
        if (o != null && o instanceof IDictionary) {
            return this.equals((IDictionary)o);
        }
        return false;
    }

    @Override
    public final boolean equals(double[] v) {
        return this.equals(new Dictionary(v));
    }

    protected static String doubleToString(double v) {
        if (v == (double)((long)v)) {
            return Long.toString((long)v);
        }
        return Double.toString(v);
    }

    public static void correctNan(double[] res, IColIndex colIndexes) {
        for (int j = 0; j < colIndexes.size(); ++j) {
            int cix = colIndexes.get(j);
            res[cix] = Double.isNaN(res[cix]) ? 0.0 : res[cix];
        }
    }

    @Override
    public IDictionary rightMMPreAggSparse(int numVals, SparseBlock b, IColIndex thisCols, IColIndex aggregateColumns, int nColRight) {
        if (aggregateColumns.size() < nColRight) {
            return this.rightMMPreAggSparseSelectedCols(numVals, b, thisCols, aggregateColumns);
        }
        return this.rightMMPreAggSparseAllColsRight(numVals, b, thisCols, nColRight);
    }

    @Override
    public void putSparse(SparseBlock sb, int idx, int rowOut, int nCol, IColIndex columns) {
        for (int i = 0; i < nCol; ++i) {
            sb.append(rowOut, columns.get(i), this.getValue(idx, i, nCol));
        }
    }

    @Override
    public void putDense(DenseBlock dr, int idx, int rowOut, int nCol, IColIndex columns) {
        double[] dv = dr.values(rowOut);
        int off = dr.pos(rowOut);
        for (int i = 0; i < nCol; ++i) {
            int n = off + columns.get(i);
            dv[n] = dv[n] + this.getValue(idx, i, nCol);
        }
    }

    @Override
    public double[] getRow(int i, int nCol) {
        double[] ret = new double[nCol];
        for (int c = 0; c < nCol; ++c) {
            ret[c] = this.getValue(i, c, nCol);
        }
        return ret;
    }

    public MatrixBlockDictionary getMBDict() {
        throw new RuntimeException("Invalid call to getMBDict for " + this.getClass().getSimpleName());
    }

    @Override
    public void product(double[] ret, int[] counts, int nCol) {
        this.getMBDict().product(ret, counts, nCol);
    }

    @Override
    public void productWithDefault(double[] ret, int[] counts, double[] def, int defCount) {
        this.getMBDict().productWithDefault(ret, counts, def, defCount);
    }

    @Override
    public void productWithReference(double[] ret, int[] counts, double[] reference, int refCount) {
        this.getMBDict().productWithReference(ret, counts, reference, refCount);
    }

    @Override
    public CM_COV_Object centralMoment(CM_COV_Object ret, ValueFunction fn, int[] counts, int nRows) {
        return this.getMBDict().centralMoment(ret, fn, counts, nRows);
    }

    @Override
    public double getSparsity() {
        return this.getMBDict().getSparsity();
    }

    @Override
    public CM_COV_Object centralMomentWithDefault(CM_COV_Object ret, ValueFunction fn, int[] counts, double def, int nRows) {
        return this.getMBDict().centralMomentWithDefault(ret, fn, counts, def, nRows);
    }

    @Override
    public CM_COV_Object centralMomentWithReference(CM_COV_Object ret, ValueFunction fn, int[] counts, double reference, int nRows) {
        return this.getMBDict().centralMomentWithReference(ret, fn, counts, reference, nRows);
    }

    @Override
    public IDictionary rexpandCols(int max, boolean ignore, boolean cast, int nCol) {
        return this.getMBDict().rexpandCols(max, ignore, cast, nCol);
    }

    @Override
    public IDictionary rexpandColsWithReference(int max, boolean ignore, boolean cast, int reference) {
        return this.getMBDict().rexpandColsWithReference(max, ignore, cast, reference);
    }

    @Override
    public void TSMMWithScaling(int[] counts, IColIndex rows, IColIndex cols, MatrixBlock ret) {
        this.getMBDict().TSMMWithScaling(counts, rows, cols, ret);
    }

    @Override
    public void MMDict(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().MMDict(right, rowsLeft, colsRight, result);
    }

    @Override
    public void MMDictScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        this.getMBDict().MMDictScaling(right, rowsLeft, colsRight, result, scaling);
    }

    @Override
    public void MMDictSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().MMDictSparse(left, rowsLeft, colsRight, result);
    }

    @Override
    public void MMDictScalingSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        this.getMBDict().MMDictScalingSparse(left, rowsLeft, colsRight, result, scaling);
    }

    @Override
    public void TSMMToUpperTriangle(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangle(right, rowsLeft, colsRight, result);
    }

    @Override
    public void TSMMToUpperTriangleDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleDense(left, rowsLeft, colsRight, result);
    }

    @Override
    public void TSMMToUpperTriangleSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleSparse(left, rowsLeft, colsRight, result);
    }

    @Override
    public void TSMMToUpperTriangleScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleScaling(right, rowsLeft, colsRight, scale, result);
    }

    @Override
    public void TSMMToUpperTriangleDenseScaling(double[] left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleDenseScaling(left, rowsLeft, colsRight, scale, result);
    }

    @Override
    public void TSMMToUpperTriangleSparseScaling(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        this.getMBDict().TSMMToUpperTriangleSparseScaling(left, rowsLeft, colsRight, scale, result);
    }

    @Override
    public IDictionary reorder(int[] reorder) {
        return this.getMBDict().reorder(reorder);
    }

    @Override
    public IDictionary cbind(IDictionary that, int nCol) {
        return this.getMBDict().cbind(that, nCol);
    }

    @Override
    public IDictionary append(double[] row) {
        return this.getMBDict().append(row);
    }

    @Override
    public IDictionary replace(double pattern, double replace, int nCol) {
        if (this.containsValue(pattern)) {
            return this.getMBDict().replace(pattern, replace, nCol);
        }
        return this;
    }

    @Override
    public IDictionary replaceWithReference(double pattern, double replace, double[] reference) {
        if (this.containsValueWithReference(pattern, reference)) {
            return this.getMBDict().replaceWithReference(pattern, replace, reference);
        }
        return this;
    }

    @Override
    public IDictionary subtractTuple(double[] tuple) {
        return this.getMBDict().subtractTuple(tuple);
    }

    @Override
    public long getNumberNonZerosWithReference(int[] counts, double[] reference, int nRows) {
        return this.getMBDict().getNumberNonZerosWithReference(counts, reference, nRows);
    }

    @Override
    public boolean containsValueWithReference(double pattern, double[] reference) {
        if (Double.isNaN(pattern)) {
            for (int i = 0; i < reference.length; ++i) {
                if (!Double.isNaN(reference[i])) continue;
                return true;
            }
            return this.containsValue(pattern);
        }
        return this.getMBDict().containsValueWithReference(pattern, reference);
    }

    @Override
    public double sumSqWithReference(int[] counts, double[] reference) {
        return this.getMBDict().sumSqWithReference(counts, reference);
    }

    @Override
    public void colProductWithReference(double[] res, int[] counts, IColIndex colIndexes, double[] reference) {
        this.getMBDict().colProductWithReference(res, counts, colIndexes, reference);
    }

    @Override
    public void colSumSqWithReference(double[] c, int[] counts, IColIndex colIndexes, double[] reference) {
        this.getMBDict().colSumSqWithReference(c, counts, colIndexes, reference);
    }

    @Override
    public void multiplyScalar(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        this.getMBDict().multiplyScalar(v, ret, off, dictIdx, cols);
    }

    @Override
    public void MMDictDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        this.getMBDict().MMDictDense(left, rowsLeft, colsRight, result);
    }

    protected IDictionary rightMMPreAggSparseAllColsRight(int numVals, SparseBlock b, IColIndex thisCols, int nColRight) {
        return this.getMBDict().rightMMPreAggSparseAllColsRight(numVals, b, thisCols, nColRight);
    }

    protected IDictionary rightMMPreAggSparseSelectedCols(int numVals, SparseBlock b, IColIndex thisCols, IColIndex aggregateColumns) {
        return this.getMBDict().rightMMPreAggSparseSelectedCols(numVals, b, thisCols, aggregateColumns);
    }

    @Override
    public double[] productAllRowsToDoubleWithReference(double[] reference) {
        return this.getMBDict().productAllRowsToDoubleWithReference(reference);
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithDefault(double[] defaultTuple) {
        return this.getMBDict().sumAllRowsToDoubleSqWithDefault(defaultTuple);
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithReference(double[] reference) {
        return this.getMBDict().sumAllRowsToDoubleSqWithReference(reference);
    }

    @Override
    public IDictionary binOpRightWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        return this.getMBDict().binOpRightWithReference(op, v, colIndexes, reference, newReference);
    }

    @Override
    public IDictionary binOpRightAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpRightAndAppend(op, v, colIndexes);
    }

    @Override
    public IDictionary binOpRight(BinaryOperator op, double[] v) {
        return this.getMBDict().binOpRight(op, v);
    }

    @Override
    public IDictionary applyScalarOp(ScalarOperator op) {
        return this.getMBDict().applyScalarOp(op);
    }

    @Override
    public IDictionary applyScalarOpAndAppend(ScalarOperator op, double v0, int nCol) {
        return this.getMBDict().applyScalarOpAndAppend(op, v0, nCol);
    }

    @Override
    public IDictionary applyUnaryOp(UnaryOperator op) {
        return this.getMBDict().applyUnaryOp(op);
    }

    @Override
    public IDictionary applyUnaryOpAndAppend(UnaryOperator op, double v0, int nCol) {
        return this.getMBDict().applyUnaryOpAndAppend(op, v0, nCol);
    }

    @Override
    public IDictionary applyScalarOpWithReference(ScalarOperator op, double[] reference, double[] newReference) {
        return this.getMBDict().applyScalarOpWithReference(op, reference, newReference);
    }

    @Override
    public IDictionary applyUnaryOpWithReference(UnaryOperator op, double[] reference, double[] newReference) {
        return this.getMBDict().applyUnaryOpWithReference(op, reference, newReference);
    }

    @Override
    public IDictionary binOpLeft(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpLeft(op, v, colIndexes);
    }

    @Override
    public IDictionary binOpLeftAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpLeftAndAppend(op, v, colIndexes);
    }

    @Override
    public IDictionary binOpLeftWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        return this.getMBDict().binOpLeftWithReference(op, v, colIndexes, reference, newReference);
    }

    @Override
    public void aggregateColsWithReference(double[] c, Builtin fn, IColIndex colIndexes, double[] reference, boolean def) {
        this.getMBDict().aggregateColsWithReference(c, fn, colIndexes, reference, def);
    }

    @Override
    public double[] aggregateRowsWithDefault(Builtin fn, double[] defaultTuple) {
        return this.getMBDict().aggregateRowsWithDefault(fn, defaultTuple);
    }

    @Override
    public double[] aggregateRowsWithReference(Builtin fn, double[] reference) {
        return this.getMBDict().aggregateRowsWithReference(fn, reference);
    }

    @Override
    public double aggregateWithReference(double init, Builtin fn, double[] reference, boolean def) {
        return this.getMBDict().aggregateWithReference(init, fn, reference, def);
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        return this.getMBDict().aggregate(init, fn);
    }

    @Override
    public void colSumSq(double[] c, int[] counts, IColIndex colIndexes) {
        this.getMBDict().colSumSq(c, counts, colIndexes);
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol) {
        this.getMBDict().addToEntry(v, fr, to, nCol);
    }

    @Override
    public void colProduct(double[] res, int[] counts, IColIndex colIndexes) {
        this.getMBDict().colProduct(res, counts, colIndexes);
    }

    @Override
    public void MMDictScalingDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        this.getMBDict().MMDictScalingDense(left, rowsLeft, colsRight, result, scaling);
    }

    @Override
    public int[] countNNZZeroColumns(int[] counts) {
        return this.getMBDict().countNNZZeroColumns(counts);
    }

    @Override
    public IDictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        return this.getMBDict().sliceOutColumnRange(idxStart, idxEnd, previousNumberOfColumns);
    }

    @Override
    public IDictionary scaleTuples(int[] scaling, int nCol) {
        return this.getMBDict().scaleTuples(scaling, nCol);
    }

    @Override
    public IDictionary binOpRight(BinaryOperator op, double[] v, IColIndex colIndexes) {
        return this.getMBDict().binOpRight(op, v, colIndexes);
    }

    @Override
    public IDictionary preaggValuesFromDense(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut) {
        return this.getMBDict().preaggValuesFromDense(numVals, colIndexes, aggregateColumns, b, cut);
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        this.getMBDict().addToEntryVectorized(v, f1, f2, f3, f4, f5, f6, f7, f8, t1, t2, t3, t4, t5, t6, t7, t8, nCol);
    }

    @Override
    public double[] getValues() {
        return this.getMBDict().getValues();
    }

    @Override
    public double getValue(int i) {
        return this.getMBDict().getValue(i);
    }

    @Override
    public double getValue(int r, int col, int nCol) {
        return this.getMBDict().getValue(r, col, nCol);
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        return this.getMBDict().aggregateRows(fn, nCol);
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, IColIndex colIndexes) {
        this.getMBDict().aggregateCols(c, fn, colIndexes);
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        return this.getMBDict().sumAllRowsToDouble(nrColumns);
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        return this.getMBDict().sumAllRowsToDoubleWithDefault(defaultTuple);
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        return this.getMBDict().sumAllRowsToDoubleWithReference(reference);
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        return this.getMBDict().sumAllRowsToDoubleSq(nrColumns);
    }

    @Override
    public double[] productAllRowsToDouble(int nrColumns) {
        return this.getMBDict().productAllRowsToDouble(nrColumns);
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        return this.getMBDict().productAllRowsToDoubleWithDefault(defaultTuple);
    }

    @Override
    public void colSum(double[] c, int[] counts, IColIndex colIndexes) {
        this.getMBDict().colSum(c, counts, colIndexes);
    }

    @Override
    public double sum(int[] counts, int nCol) {
        return this.getMBDict().sum(counts, nCol);
    }

    @Override
    public double sumSq(int[] counts, int nCol) {
        return this.getMBDict().sumSq(counts, nCol);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this.getMBDict().containsValue(pattern);
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        this.getMBDict().addToEntry(v, fr, to, nCol, rep);
    }

    @Override
    public MatrixBlockDictionary getMBDict(int nCol) {
        return this.getMBDict();
    }
}

