/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.CombinedIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.TwoRangesIndex;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class RangeIndex
extends AColIndex {
    private final int l;
    private final int u;

    public RangeIndex(int nCol) {
        this(0, nCol);
    }

    public RangeIndex(int l, int u) {
        this.l = l;
        this.u = u;
        if (l >= u) {
            throw new DMLCompressionException("Invalid construction of Range Index with l: " + l + " u: " + u);
        }
    }

    @Override
    public int size() {
        return this.u - this.l;
    }

    @Override
    public int get(int i) {
        return this.l + i;
    }

    @Override
    public RangeIndex shift(int i) {
        return new RangeIndex(this.l + i, this.u + i);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(IColIndex.ColIndexType.RANGE.ordinal());
        out.writeInt(this.l);
        out.writeInt(this.u);
    }

    public static RangeIndex read(DataInput in) throws IOException {
        int l = in.readInt();
        int u = in.readInt();
        return new RangeIndex(l, u);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9L;
    }

    @Override
    public long estimateInMemorySize() {
        return RangeIndex.estimateInMemorySizeStatic();
    }

    public static long estimateInMemorySizeStatic() {
        return 24L;
    }

    @Override
    public IIterate iterator() {
        return new RangeIterator();
    }

    @Override
    public int findIndex(int i) {
        if (i < this.l) {
            return -1;
        }
        if (i < this.u) {
            return i - this.l;
        }
        return -1 * this.u - 1 + this.l;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        if (u <= this.l) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        if (l >= this.u) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        if (l <= this.l && u >= this.u) {
            return new IColIndex.SliceResult(0, this.size(), new RangeIndex(this.l - l, this.u - l));
        }
        int maxL = Math.max(l, this.l);
        int minU = Math.min(u, this.u);
        int offL = maxL - this.l;
        int offR = minU - this.l;
        return new IColIndex.SliceResult(offL, offR, new RangeIndex(maxL - l, minU - l));
    }

    @Override
    public boolean equals(IColIndex other) {
        if (other instanceof RangeIndex) {
            RangeIndex ot = (RangeIndex)other;
            return ot.l == this.l && ot.u == this.u;
        }
        return other.equals(this);
    }

    @Override
    public boolean containsAny(IColIndex idx) {
        if (idx instanceof RangeIndex) {
            RangeIndex o = (RangeIndex)idx;
            if (o.l >= this.u) {
                return false;
            }
            if (o.u <= this.l) {
                return false;
            }
            if (o.l <= this.l && o.u > this.l) {
                return true;
            }
            if (o.l < this.u && o.u > this.u) {
                return true;
            }
            throw new NotImplementedException(idx + " " + this);
        }
        return super.containsAny(idx);
    }

    @Override
    public IColIndex combine(IColIndex other) {
        int sr = other.size();
        if (other.size() == 1) {
            int v = other.get(0);
            if (v + 1 == this.l) {
                return new RangeIndex(this.l - 1, this.u);
            }
            if (v == this.u) {
                return new RangeIndex(this.l, this.u + 1);
            }
            if (v < this.l) {
                return new CombinedIndex(other, this);
            }
            return new CombinedIndex(this, other);
        }
        if (other instanceof RangeIndex) {
            if (other.get(0) == this.u) {
                return new RangeIndex(this.l, other.get(other.size() - 1) + 1);
            }
            if (other.get(other.size() - 1) == this.l - 1) {
                return new RangeIndex(other.get(0), this.u);
            }
            if (other.get(0) < this.get(0)) {
                return new TwoRangesIndex((RangeIndex)other, this);
            }
            return new TwoRangesIndex(this, (RangeIndex)other);
        }
        if (other.get(sr - 1) < this.l) {
            return new CombinedIndex(other, this);
        }
        if (other.get(0) > this.u) {
            return new CombinedIndex(this, other);
        }
        int sl = this.size();
        int[] ret = new int[sr + sl];
        int pl = 0;
        int pr = 0;
        int i = 0;
        while (pl < sl && pr < sr) {
            int vr;
            int vl = this.get(pl);
            if (vl < (vr = other.get(pr))) {
                ret[i++] = vl;
                ++pl;
                continue;
            }
            ret[i++] = vr;
            ++pr;
        }
        while (pl < sl) {
            ret[i++] = this.get(pl++);
        }
        while (pr < sr) {
            ret[i++] = other.get(pr++);
        }
        return ColIndexFactory.create(ret);
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    protected static boolean isValidRange(int[] indexes) {
        return RangeIndex.isValidRange(indexes, indexes.length);
    }

    protected static boolean isValidRange(IntArrayList indexes) {
        return RangeIndex.isValidRange(indexes.extractValues(), indexes.size());
    }

    private static boolean isValidRange(int[] indexes, int length) {
        boolean isPossibleFistAndLast;
        int last = indexes[length - 1];
        int first = indexes[0];
        int len = length;
        boolean bl = isPossibleFistAndLast = last - first + 1 >= len;
        if (!isPossibleFistAndLast) {
            throw new DMLCompressionException("Invalid Index " + Arrays.toString(indexes));
        }
        if (last - first + 1 == len) {
            for (int i = 1; i < length; ++i) {
                if (indexes[i - 1] < indexes[i]) continue;
                throw new DMLCompressionException("Invalid Index");
            }
            return true;
        }
        return false;
    }

    @Override
    public int[] getReorderingIndex() {
        throw new DMLCompressionException("not valid to get reordering Index for range");
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public IColIndex sort() {
        throw new DMLCompressionException("range is always sorted");
    }

    @Override
    public boolean contains(int i) {
        return this.l <= i && i < this.u;
    }

    @Override
    public double avgOfIndex() {
        double diff = this.u - 1 - this.l;
        return (double)this.l + diff * 0.5;
    }

    @Override
    public int hashCode() {
        return 31 * this.l + this.u;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.l);
        sb.append(" -> ");
        sb.append(this.u);
        sb.append("]");
        return sb.toString();
    }

    protected class RangeIterator
    implements IIterate {
        int cl;

        protected RangeIterator() {
            this.cl = RangeIndex.this.l;
        }

        @Override
        public int next() {
            return this.cl++;
        }

        @Override
        public boolean hasNext() {
            return this.cl < RangeIndex.this.u;
        }

        @Override
        public int v() {
            return this.cl;
        }

        @Override
        public int i() {
            return this.cl - RangeIndex.this.l;
        }
    }
}

