/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.cache;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.eclipse.ebam.adapters.AdapterConfiguration;
import org.eclipse.ebam.cache.process.MsgProcess;
import org.eclipse.ebam.emf.interfaces.ICacheTransaction;
import org.eclipse.ebam.emf.interfaces.IMessageTransaction;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Journal;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.MessageContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgReadUtils {
    private static Logger logger = LoggerFactory.getLogger(MsgReadUtils.class);

    public static String extractMsgType(IEbamMessage message) {
        logger.debug("IN");
        Document doc = null;
        String msgType = null;
        String content = message.getMsg();
        content = content.substring(content.indexOf(";") + 1);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(content);
            ByteArrayInputStream bais = new ByteArrayInputStream(strBufferContent.toString().getBytes("UTF-8"));
            InputSource inputSource = new InputSource(bais);
            logger.debug("This is the MESSAGE " + content);
            doc = db.parse(inputSource);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            msgType = root.getNodeName();
            Map<String, String> mapRules = AdapterConfiguration.getInstance().getJournalRules();
            String val = mapRules.get("msgType");
            msgType = XPathAPI.eval((Node)doc, (String)val).toString().trim();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.debug("OUT:msgType=" + msgType);
        return msgType;
    }

    public static String extractService(IEbamMessage message) {
        logger.debug("IN");
        Document doc = null;
        String serviceName = null;
        String content = message.getMsg();
        content = content.substring(content.indexOf(";") + 1);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(content);
            ByteArrayInputStream bais = new ByteArrayInputStream(strBufferContent.toString().getBytes("UTF-8"));
            InputSource inputSource = new InputSource(bais);
            doc = db.parse(inputSource);
            doc.getDocumentElement().normalize();
            serviceName = XPathAPI.eval((Node)doc, (String)AdapterConfiguration.getInstance().getJournalRules().get("serviceName")).toString().trim();
            message.setService(serviceName);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.debug("OUT.serviceName=" + serviceName);
        return serviceName;
    }

    public static String extractServiceInstance(IEbamMessage message) {
        logger.debug("IN");
        Document doc = null;
        String serviceInstance = null;
        String content = message.getMsg();
        content = content.substring(content.indexOf(";") + 1);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(content);
            ByteArrayInputStream bais = new ByteArrayInputStream(strBufferContent.toString().getBytes("UTF-8"));
            InputSource inputSource = new InputSource(bais);
            doc = db.parse(inputSource);
            doc.getDocumentElement().normalize();
            serviceInstance = XPathAPI.eval((Node)doc, (String)AdapterConfiguration.getInstance().getJournalRules().get("serviceInstLabel")).toString().trim();
            message.setServiceInstance(serviceInstance);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.debug("serviceInstance=" + serviceInstance);
        return serviceInstance;
    }

    public static String extractByQuery(IEbamMessage message, String xpath, String dataType) {
        logger.debug("IN");
        Document doc = null;
        String data = null;
        String content = message.getMsg();
        content = content.substring(content.indexOf(";") + 1);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(content);
            ByteArrayInputStream bais = new ByteArrayInputStream(strBufferContent.toString().getBytes("UTF-8"));
            InputSource inputSource = new InputSource(bais);
            doc = db.parse(inputSource);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (dataType == null || dataType.equals("") || dataType.equalsIgnoreCase("STRING")) {
                XObject tmp = XPathAPI.eval(doc, (String)xpath);
                if (tmp != null) {
                    data = tmp.toString();
                }
            } else if (dataType != null && dataType.equalsIgnoreCase("LIST")) {
                Node n;
                data = "";
                NodeIterator nl = XPathAPI.selectNodeIterator((Node)doc, (String)xpath);
                while ((n = nl.nextNode()) != null) {
                    data = String.valueOf(data) + n.getTextContent() + " ";
                }
            }
        }
        catch (TransformerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NullPointerException n) {
            logger.error("NullPointerException (Check the EBAM_DATA_ATTRIBUTE)", (Throwable)n);
        }
        logger.debug("OUT.data=" + data);
        return data;
    }

    public static final List<MessageContent> createRelevantData(Journal j, IEbamMessage message, Message messageTypeBean, IMessageTransaction msgTransaction) {
        ArrayList<MessageContent> result = null;
        try {
            List dataAttrs;
            Integer msgId = messageTypeBean.getMessageId();
            if (msgId != null && (dataAttrs = msgTransaction.getDataAttributeByMsgId(msgId)) != null && dataAttrs.size() != 0) {
                result = new ArrayList<MessageContent>();
                int i = 0;
                while (i < dataAttrs.size()) {
                    DataAttribute dataAttr = (DataAttribute)dataAttrs.get(i);
                    String relevantData = MsgReadUtils.extractByQuery(message, dataAttr.getExpression(), dataAttr.getDataType());
                    if (relevantData != null && !relevantData.equals("")) {
                        MessageContent msgContent = new MessageContent();
                        msgContent.setDataAttribute(dataAttr);
                        msgContent.setJournal(j);
                        msgContent.setName(dataAttr.getName());
                        msgContent.setValue(relevantData);
                        result.add(msgContent);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static final Journal createJournaleFromMessage(IEbamMessage message, Message msgTypeAndService, ICacheTransaction cacheTransaction) throws Exception {
        Journal j = new Journal();
        try {
            MsgProcess msgProcess = new MsgProcess();
            msgProcess.fillCommonFieldsFromXML(j, message, msgTypeAndService, cacheTransaction);
        }
        catch (Exception e) {
            logger.error("Error filling journal");
            throw e;
        }
        return j;
    }
}

