/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.cache.process;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.ebam.adapters.AdapterConfiguration;
import org.eclipse.ebam.cache.MsgReadUtils;
import org.eclipse.ebam.emf.interfaces.ICacheTransaction;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.Journal;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.SbiResources;
import org.eclipse.ebam.model.entities.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgProcess {
    private static Logger logger = LoggerFactory.getLogger(MsgProcess.class);
    private static AdapterConfiguration config = AdapterConfiguration.getInstance();
    private SimpleDateFormat sdf = new SimpleDateFormat(config.getJournalRules().get("format_date"));
    private final String MONITOR_CHECK_ENABLED = "1";

    public final Journal fillCommonFieldsFromXML(Journal j, IEbamMessage message, Message msg, ICacheTransaction cacheTransaction) throws Exception {
        MsgReadUtils.extractByQuery(message, config.getJournalRules().get("serviceInstState"), null);
        String error = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("error"), null);
        String phaseName = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("phaseName"), null);
        String phaseDescr = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("phaseDescr"), null);
        String phaseProg = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("phaseProg"), null);
        String state = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("state"), null);
        MsgReadUtils.extractByQuery(message, config.getJournalRules().get("serviceSrc"), null);
        String startDate = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("startDate"), null);
        String endDate = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("endDate"), null);
        String execTime = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("execTime"), null);
        String alarmLabel = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("alarmLabel"), null);
        if (alarmLabel != null && !alarmLabel.equals("")) {
            message.setAlarmLabel(alarmLabel);
        }
        try {
            if (startDate != null && !startDate.equals("")) {
                Date dtBegin = this.sdf.parse(startDate);
                j.setStartDate(dtBegin);
            }
            if (endDate != null && !endDate.equals("")) {
                Date dtEnd = this.sdf.parse(endDate);
                j.setEndDate(dtEnd);
            }
            if (execTime != null && !execTime.equals("")) {
                Date dtExec = this.sdf.parse(execTime);
                j.setExecutionTime(dtExec);
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        j.setTimestampIn(new Date());
        j.setPhaseName(phaseName);
        j.setPhaseDescr(phaseDescr);
        j.setPhaseProg(phaseProg);
        j.setError(error);
        j.setMessage(msg);
        j.setLabel(message.getKey());
        j.setServiceSrcOrig(message.getFileName());
        j.setXmlData(message.getMsg());
        j.setName(msg.getName());
        j.setSourceName(message.getSource());
        j.setStateDescr(state);
        j.setAlarm(alarmLabel);
        ServiceInstance serviceInstance = this.createServiceInstanceByType(message, msg, cacheTransaction);
        j.setServiceInstance(serviceInstance);
        return j;
    }

    private ServiceInstance createServiceInstanceByType(IEbamMessage message, Message msgTypeAndService, ICacheTransaction cacheTransaction) throws Exception {
        String serviceInstLabel = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("serviceInstLabel"), null);
        String serviceStartDate = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("serviceStartDate"), null);
        String serviceEndDate = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("serviceEndDate"), null);
        String azienda = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("aziendaFromDetail"), null);
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setLabel(serviceInstLabel);
        serviceInstance.setService(msgTypeAndService.getService());
        serviceInstance.setMonitorCheck("1");
        if (azienda != null && !azienda.equals("")) {
            try {
                SbiResources resource = cacheTransaction.getSbiResourcesByName(azienda);
                serviceInstance.setResource(resource);
            }
            catch (Exception e) {
                logger.error("SbiResources for name:" + azienda + " not found");
                throw e;
            }
        }
        String serviceInstState = MsgReadUtils.extractByQuery(message, config.getJournalRules().get("serviceInstState"), null);
        try {
            if (serviceStartDate != null && !serviceStartDate.equals("")) {
                Date dtBegin = this.sdf.parse(serviceStartDate);
                serviceInstance.setStartdate(dtBegin);
            }
            if (serviceEndDate != null && !serviceEndDate.equals("")) {
                Date dtEnd = this.sdf.parse(serviceEndDate);
                serviceInstance.setEnddate(dtEnd);
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (serviceInstState != null && !serviceInstState.equals("")) {
            serviceInstance.setState(Double.parseDouble(serviceInstState));
        }
        return serviceInstance;
    }
}

