/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.internal.filters.InvalidAttributeNameException;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;

public class CBEHelper
implements ICBEPropertyConstants {
    public static String getValueFromPath(CommonBaseEvent cbe, List path) throws InvalidAttributeNameException {
        if (cbe == null | path == null) {
            return null;
        }
        Iterator i = path.iterator();
        if (path.isEmpty() || !i.next().equals("CommonBaseEvent")) {
            throw new InvalidAttributeNameException();
        }
        if (i.hasNext()) {
            String node = (String)i.next();
            if (node.equals("creationTime")) {
                return cbe.getCreationTime();
            }
            if (node.equals("elapsedTime")) {
                return String.valueOf(cbe.getElapsedTime());
            }
            if (node.equals("extensionName")) {
                return cbe.getExtensionName();
            }
            if (node.equals("globalInstanceId")) {
                return cbe.getGlobalInstanceId();
            }
            if (node.equals("localInstanceId")) {
                return cbe.getLocalInstanceId();
            }
            if (node.equals("msg")) {
                return cbe.getMsg();
            }
            if (node.equals("priority")) {
                return String.valueOf(cbe.getPriority());
            }
            if (node.equals("repeatCount")) {
                return String.valueOf(cbe.getRepeatCount());
            }
            if (node.equals("sequenceNumber")) {
                return String.valueOf(cbe.getSequenceNumber());
            }
            if (node.equals("severity")) {
                return String.valueOf(cbe.getSeverity());
            }
            if (node.equals("version")) {
                return cbe.getVersion();
            }
            if (node.equals("associatedEvents")) {
                if (!i.hasNext()) {
                    return null;
                }
                String nextNode = (String)i.next();
                if (!(nextNode.equals("associationEngine") || nextNode.equals("associationEngineInfo") || nextNode.equals("resolvedEvents"))) {
                    return null;
                }
                return null;
            }
            if (node.equals("contextDataElements")) {
                if (!i.hasNext()) {
                    return null;
                }
                String nextNode = (String)i.next();
                if (!(nextNode.equals("contextId") || nextNode.equals("name") || nextNode.equals("type") || nextNode.equals("contextValue"))) {
                    return null;
                }
                return null;
            }
            if (node.equals("extendedDataElements")) {
                EList edeList = cbe.getExtendedDataElements();
                if (i.hasNext() && !edeList.isEmpty()) {
                    return null;
                }
                return null;
            }
            if (node.equals("msgDataElement")) {
                MsgDataElement mde = cbe.getMsgDataElement();
                if (i.hasNext() && mde != null) {
                    String nextNode = (String)i.next();
                    if (nextNode.equals("msgId")) {
                        return mde.getMsgId();
                    }
                    if (nextNode.equals("msgIdType")) {
                        return mde.getMsgIdType();
                    }
                    if (nextNode.equals("msgCatalog")) {
                        return mde.getMsgCatalog();
                    }
                    if (nextNode.equals("msgCatalogId")) {
                        return mde.getMsgCatalogId();
                    }
                    if (nextNode.equals("msgCatalogTokens")) {
                        String[] tokenArray = mde.getMsgCatalogTokensAsStrings();
                        return tokenArray[0];
                    }
                    if (nextNode.equals("msgCatalogType")) {
                        return mde.getMsgCatalogType();
                    }
                    if (nextNode.equals("msgLocale")) {
                        return mde.getMsgLocale();
                    }
                }
                return null;
            }
            if (node.equals("otherData")) {
                if (!i.hasNext()) {
                    return null;
                }
                return null;
            }
            if (node.equals("reporterComponentId") || node.equals("sourceComponentId")) {
                ComponentIdentification cid = node.equals("reporterComponentId") ? cbe.getReporterComponentId() : cbe.getSourceComponentId();
                if (i.hasNext() && cid != null) {
                    String nextNode = (String)i.next();
                    if (nextNode.equals("application")) {
                        return cid.getApplication();
                    }
                    if (nextNode.equals("component")) {
                        return cid.getComponent();
                    }
                    if (nextNode.equals("componentIdType")) {
                        return cid.getComponentIdType();
                    }
                    if (nextNode.equals("componentType")) {
                        return cid.getComponentType();
                    }
                    if (nextNode.equals("executionEnvironment")) {
                        return cid.getExecutionEnvironment();
                    }
                    if (nextNode.equals("instanceId")) {
                        return cid.getInstanceId();
                    }
                    if (nextNode.equals("location")) {
                        return cid.getLocation();
                    }
                    if (nextNode.equals("locationType")) {
                        return cid.getLocationType();
                    }
                    if (nextNode.equals("processId")) {
                        return cid.getProcessId();
                    }
                    if (nextNode.equals("subComponent")) {
                        return cid.getSubComponent();
                    }
                    if (nextNode.equals("threadId")) {
                        return cid.getThreadId();
                    }
                }
                return null;
            }
            if (node.equals("situation")) {
                Situation sit = cbe.getSituation();
                if (i.hasNext() && sit != null) {
                    String sitNode = (String)i.next();
                    if (sitNode.equals("categoryName")) {
                        return sit.getCategoryName();
                    }
                    if (sitNode.equals("situationType")) {
                        return null;
                    }
                    if (sitNode.equals("AvailableSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof AvailableSituation) {
                            AvailableSituation realSitType = (AvailableSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("operationDisposition")) {
                                return realSitType.getOperationDisposition();
                            }
                            if (sitAttrNode.equals("processingDisposition")) {
                                return realSitType.getProcessingDisposition();
                            }
                            if (sitAttrNode.equals("availabilityDisposition")) {
                                return realSitType.getAvailabilityDisposition();
                            }
                        }
                    } else if (sitNode.equals("RequestSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof RequestSituation) {
                            RequestSituation realSitType = (RequestSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("successDisposition")) {
                                return realSitType.getSuccessDisposition();
                            }
                            if (sitAttrNode.equals("situationQualifier")) {
                                return realSitType.getSituationQualifier();
                            }
                        }
                    } else if (sitNode.equals("StartSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof StartSituation) {
                            StartSituation realSitType = (StartSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("successDisposition")) {
                                return realSitType.getSuccessDisposition();
                            }
                            if (sitAttrNode.equals("situationQualifier")) {
                                return realSitType.getSituationQualifier();
                            }
                        }
                    } else if (sitNode.equals("StopSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof StopSituation) {
                            StopSituation realSitType = (StopSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("successDisposition")) {
                                return realSitType.getSuccessDisposition();
                            }
                            if (sitAttrNode.equals("situationQualifier")) {
                                return realSitType.getSituationQualifier();
                            }
                        }
                    } else if (sitNode.equals("ConfigureSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof ConfigureSituation) {
                            ConfigureSituation realSitType = (ConfigureSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("successDisposition")) {
                                return realSitType.getSuccessDisposition();
                            }
                        }
                    } else if (sitNode.equals("CreateSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof CreateSituation) {
                            CreateSituation realSitType = (CreateSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("successDisposition")) {
                                return realSitType.getSuccessDisposition();
                            }
                        }
                    } else if (sitNode.equals("DestroySituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof DestroySituation) {
                            DestroySituation realSitType = (DestroySituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("successDisposition")) {
                                return realSitType.getSuccessDisposition();
                            }
                        }
                    } else if (sitNode.equals("ConnectSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof ConnectSituation) {
                            ConnectSituation realSitType = (ConnectSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("successDisposition")) {
                                return realSitType.getSuccessDisposition();
                            }
                            if (sitAttrNode.equals("situationDisposition")) {
                                return realSitType.getSituationDisposition();
                            }
                        }
                    } else if (sitNode.equals("ReportSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof ReportSituation) {
                            ReportSituation realSitType = (ReportSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("reportCategory")) {
                                return realSitType.getReportCategory();
                            }
                        }
                    } else if (sitNode.equals("FeatureSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof FeatureSituation) {
                            FeatureSituation realSitType = (FeatureSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("featureDisposition")) {
                                return realSitType.getFeatureDisposition();
                            }
                        }
                    } else if (sitNode.equals("DependencySituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof DependencySituation) {
                            DependencySituation realSitType = (DependencySituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("dependencyDisposition")) {
                                return realSitType.getDependencyDisposition();
                            }
                        }
                    } else if (sitNode.equals("OtherSituation")) {
                        SituationType sitType = sit.getSituationType();
                        if (i.hasNext() && sitType instanceof OtherSituation) {
                            OtherSituation realSitType = (OtherSituation)sitType;
                            String sitAttrNode = (String)i.next();
                            if (sitAttrNode.equals("reasoningScope")) {
                                return realSitType.getReasoningScope();
                            }
                            if (sitAttrNode.equals("##any")) {
                                return realSitType.getAny();
                            }
                        }
                    }
                }
            }
        }
        throw new InvalidAttributeNameException();
    }
}

