/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.outputters.CBEFileOutputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

public class CBEConvergentFileOutputter
extends CBEFileOutputter {
    private static Hashtable fileWriters = new Hashtable();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFileWriter() throws AdapterException {
        Hashtable hashtable = fileWriters;
        synchronized (hashtable) {
            if (fileWriters.containsKey(this.rawLogFileName)) {
                this.fw = (ConvergentWriter)fileWriters.get(this.rawLogFileName);
                ((ConvergentWriter)this.fw).incrementUserCount();
            } else {
                try {
                    this.fw = new ConvergentWriter(this.rawLogFileName);
                }
                catch (IOException ioe) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Create_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName, ioe.getMessage()});
                    event.setSeverity((short)60);
                    this.log(event);
                    throw new AdapterException(Messages.getString("HyadesGA_CBE_File_Outputter_Create_ERROR_", this.getUniqueID(), this.rawLogFileName, ioe.getMessage()));
                }
                ((ConvergentWriter)this.fw).incrementUserCount();
                fileWriters.put(this.rawLogFileName, this.fw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(String event) throws IOException {
        FileWriter fileWriter = this.fw;
        synchronized (fileWriter) {
            this.fw.write(event);
            this.fw.write(LINE_SEPARATOR);
            this.fw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.fw != null) {
                FileWriter fileWriter = this.fw;
                synchronized (fileWriter) {
                    ConvergentWriter cw = (ConvergentWriter)this.fw;
                    if (cw.getUserCount() > 1) {
                        cw.decrementUserCount();
                    } else if (cw.getUserCount() == 1) {
                        cw.decrementUserCount();
                        try {
                            cw.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private class ConvergentWriter
    extends FileWriter {
        private int userCount = 0;
        private Object lock = new Object();

        public ConvergentWriter(String fileName) throws IOException {
            super(fileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getUserCount() {
            Object object = this.lock;
            synchronized (object) {
                return this.userCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementUserCount() {
            Object object = this.lock;
            synchronized (object) {
                ++this.userCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrementUserCount() {
            Object object = this.lock;
            synchronized (object) {
                --this.userCount;
            }
        }
    }
}

