/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf.interfaces;

import java.util.List;

import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.SbiDomain;

public interface IMessageTransaction {
	



public  List<DataAttribute> getDataAttributeByMsgId(
	final Integer msgType) throws Exception ;

/**
* Method that executes database query to extract message id by message
* name.
* 
* @param msgTypeName
*            name
* @return <code>Integer</code> messageId
* @throws Exception
*             error on select
*/

public  Integer getMsgIdByName(final String msgTypeName)
	throws Exception;


public  Message getMessageByType(final String msgType,
	final String serviceName) throws Exception ;

public  Message getMessageByXmlRoot(final String root) throws Exception ;


public List<SbiDomain> getSbiDomainsbyMessageId(Integer idType) throws Exception;

}
