/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;


/**
 * The persistent class for the sbi_alarm database table.
 * 
 */
@Entity
@Table(name="SBI_ALARM")
public class SbiAlarm implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableGenerator(name="AlarmId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="ALARM_ID", allocationSize=1)
	@Id
    @GeneratedValue(generator="AlarmId", strategy=GenerationType.TABLE)   	
	@Column(name="ALARM_ID")
	private Integer alarmId;

	@Column(name="AUTO_DISABLED")
	private String autoDisabled;

	@Column(name="DESCR")
	private String descr;

	@Column(name="DOCUMENT_ID")
	private int documentId;

	@Column(name="LABEL")
	private String label;

	@Column(name="MODALITY_ID")
	private int modalityId;

	@Column(name="NAME")
	private String name;

	@Column(name="SINGLE_EVENT")
	private String singleEvent;

	@Column(name="TEXT")
	private String text;

	@Column(name="URL")
	private String url;

	//bi-directional many-to-one association to SbiThresholdValue
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="ID_THRESHOLD_VALUE")
	private SbiThresholdValue sbiThresholdValue;

	//bi-directional many-to-one association to SbiAlarmEvent
	@OneToMany(mappedBy="sbiAlarm",fetch=FetchType.LAZY)
	private Set<SbiAlarmEvent> sbiAlarmEvents;

	//bi-directional many-to-many association to SbiAlarmContact
	@ManyToMany(mappedBy="sbiAlarms",fetch=FetchType.LAZY, cascade = CascadeType.ALL)
	private Set<SbiAlarmContact> sbiAlarmContacts;
	
	//bi-directional many-to-one association to SbiAlarm
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="EVENT_ID")
	private Event event;

    public SbiAlarm() {
    }

	public int getAlarmId() {
		return this.alarmId;
	}

	public void setAlarmId(int alarmId) {
		this.alarmId = alarmId;
	}

	public String getAutoDisabled() {
		return this.autoDisabled;
	}

	public void setAutoDisabled(String autoDisabled) {
		this.autoDisabled = autoDisabled;
	}

	public String getDescr() {
		return this.descr;
	}

	public void setDescr(String descr) {
		this.descr = descr;
	}

	public int getDocumentId() {
		return this.documentId;
	}

	public void setDocumentId(int documentId) {
		this.documentId = documentId;
	}

	public String getLabel() {
		return this.label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public int getModalityId() {
		return this.modalityId;
	}

	public void setModalityId(int modalityId) {
		this.modalityId = modalityId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSingleEvent() {
		return this.singleEvent;
	}

	public void setSingleEvent(String singleEvent) {
		this.singleEvent = singleEvent;
	}

	public String getText() {
		return this.text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String getUrl() {
		return this.url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public SbiThresholdValue getSbiThresholdValue() {
		return this.sbiThresholdValue;
	}

	public void setSbiThresholdValue(SbiThresholdValue sbiThresholdValue) {
		this.sbiThresholdValue = sbiThresholdValue;
	}
	
	public Set<SbiAlarmEvent> getSbiAlarmEvents() {
		return this.sbiAlarmEvents;
	}

	public void setSbiAlarmEvents(Set<SbiAlarmEvent> sbiAlarmEvents) {
		this.sbiAlarmEvents = sbiAlarmEvents;
	}
	
	public Event getEvent() {
		return this.event;
	}	
	
	public void setEvent(Event event) {
		this.event = event;
	}
	
	public Set<SbiAlarmContact> getSbiAlarmContacts() {
		return this.sbiAlarmContacts;
	}

	public void setSbiAlarmContacts(Set<SbiAlarmContact> sbiAlarmContacts) {
		this.sbiAlarmContacts = sbiAlarmContacts;
	}
	
}