/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.ReadOnly;

/**
 * Entity implementation class for Entity: SbiResources
 *
 */

@Entity
@Table(name="SBI_RESOURCES")
@ReadOnly

public class SbiResources implements Serializable {

	   
    @TableGenerator(name="sbiResId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="RESOURCE_ID", allocationSize=1)
	@Id
    @GeneratedValue(generator="sbiResId", strategy=GenerationType.TABLE)   
	@Column(name="RESOURCE_ID")
	private Integer resourceId; 
  
	
	@Column(name="RESOURCE_NAME")
	private String resourceName;
	
	@Column(name="RESOURCE_DESCR")
	private String resourceDescr;
	
	//bi-directional many-to-one association to Domain
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="RESOURCE_TYPE_ID")
	private SbiDomain sbiDomain; 
	
	//bi-directional many-to-one association to ServiceInstance
	@OneToMany(mappedBy="resource",fetch=FetchType.LAZY)
	private Set<ServiceInstance> serviceInstances;

	
	private static final long serialVersionUID = 1L;

	public SbiResources() {
		super();
	}   

	public String getResourceName() {
		return this.resourceName;
	}

	public void setResourceName(String resourceName) {
		this.resourceName = resourceName;
	}   
	public String getResourceDescr() {
		return this.resourceDescr;
	}

	public void setResourceDescr(String resourceDescr) {
		this.resourceDescr = resourceDescr;
	}

	public int getResourceId() {
		return resourceId;
	}

	public void setResourceId(int resourceId) {
		this.resourceId = resourceId;
	}

	public SbiDomain getSbiDomain() {
		return sbiDomain;
	}

	public void setSbiDomain(SbiDomain sbiDomain) {
		this.sbiDomain = sbiDomain;
	}

	public Set<ServiceInstance> getServiceInstances() {
		return serviceInstances;
	}

	public void setServiceInstances(Set<ServiceInstance> serviceInstances) {
		this.serviceInstances = serviceInstances;
	}
   
}
