/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the service_instance database table.
 * 
 */
@Entity
@Table(name="SERVICE_INSTANCE")
public class ServiceInstance implements Serializable {
	private static final long serialVersionUID = 1L;
	
    @TableGenerator(name="siId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="SERVICE_INSTANCE_ID", allocationSize=100)
	@Id
    @GeneratedValue(generator="siId", strategy=GenerationType.TABLE)
	@Column(name="ID_SERVICE_INSTANCE")
	private Double idServiceInstance;

	@Column(name="CORRELATION_ID")
	private String correlationId;

    @Temporal( TemporalType.TIMESTAMP)
	private Date enddate;

    @Temporal( TemporalType.TIMESTAMP)
	private Date startdate;

    @Column(name="STATE")
	private double state;
	
	@Column(name="LABEL")
	private String label;
	
	@Column(name="MARKER")
	private String marker;
	
	@Column(name="MONITOR_CHECK")
	private String monitorCheck;
	
	@Column(name="ERRORS_CHECK")
	private String errorsCheck;
	
	@Column(name="ALARMS_CHECK")
	private String alarmsCheck;
	
	@Column(name="VIEWS_CHECK")
	private String viewsCheck;
	
	@Column(name="USER_ID")
	private String userId;
	
	@Temporal( TemporalType.TIMESTAMP)
	@Column(name="TS_UPDATE")
	private Date tsUpdate;
/*
	//bi-directional many-to-one association to Journal
	@OneToMany(mappedBy="serviceInstance",fetch=FetchType.EAGER, cascade = CascadeType.PERSIST)
	@MapKey(name="ID_SERVICE_INSTANCE")
	private Set<Journal> journals;
*/
	//bi-directional many-to-one association to ServiceInstance
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="ID_TARGET_SERVICE_INSTANCE")
	private ServiceInstance serviceInstance;

	//bi-directional many-to-one association to ServiceInstance
	@OneToMany(mappedBy="serviceInstance",fetch=FetchType.LAZY)
	private Set<ServiceInstance> serviceInstances;

	//bi-directional many-to-one association to Service
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="ID_SERVICE")
	private Service service;
    
	//bi-directional many-to-one association to Service
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="RESOURCE_ID")
	private SbiResources resource;

    public ServiceInstance() {
    }

	public Double getIdServiceInstance() {
		return this.idServiceInstance;
	}

	public void setIdServiceInstance(Double idServiceInstance) {
		this.idServiceInstance = idServiceInstance;
	}

	public String getCorrelationId() {
		return this.correlationId;
	}

	public void setCorrelationId(String correlationId) {
		this.correlationId = correlationId;
	}

	public Date getEnddate() {
		return this.enddate;
	}

	public void setEnddate(Date enddate) {
		this.enddate = enddate;
	}

	public Date getStartdate() {
		return this.startdate;
	}

	public void setStartdate(Date startdate) {
		this.startdate = startdate;
	}

	public double getState() {
		return this.state;
	}

	public void setState(double state) {
		this.state = state;
	}
/*
	public Set<Journal> getJournals() {
		return this.journals;
	}

	public void setJournals(Set<Journal> journals) {
		this.journals = journals;
	}
*/	
	public ServiceInstance getServiceInstance() {
		return this.serviceInstance;
	}

	public void setServiceInstance(ServiceInstance serviceInstance) {
		this.serviceInstance = serviceInstance;
	}
	
	public Set<ServiceInstance> getServiceInstances() {
		return this.serviceInstances;
	}

	public void setServiceInstances(Set<ServiceInstance> serviceInstances) {
		this.serviceInstances = serviceInstances;
	}
	
	public Service getService() {
		return this.service;
	}

	public void setService(Service service) {
		this.service = service;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getMarker() {
		return marker;
	}

	public void setMarker(String marker) {
		this.marker = marker;
	}

	public String getMonitorCheck() {
		return monitorCheck;
	}

	public void setMonitorCheck(String monitorCheck) {
		this.monitorCheck = monitorCheck;
	}

	public String getErrorsCheck() {
		return errorsCheck;
	}

	public void setErrorsCheck(String errorsCheck) {
		this.errorsCheck = errorsCheck;
	}

	public String getAlarmsCheck() {
		return alarmsCheck;
	}

	public void setAlarmsCheck(String alarmsCheck) {
		this.alarmsCheck = alarmsCheck;
	}

	public String getViewsCheck() {
		return viewsCheck;
	}

	public void setViewsCheck(String viewsCheck) {
		this.viewsCheck = viewsCheck;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public Date getTsUpdate() {
		return tsUpdate;
	}

	public void setTsUpdate(Date tsUpdate) {
		this.tsUpdate = tsUpdate;
	}

	public SbiResources getResource() {
		return resource;
	}

	public void setResource(SbiResources resource) {
		this.resource = resource;
	}

	
}