/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.zip;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.zip.ZipFileIndexEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileIndex {
    private static final String MIN_CHAR = String.valueOf('\u0000');
    private static final String MAX_CHAR = String.valueOf('\uffff');
    public static final long NOT_MODIFIED = Long.MIN_VALUE;
    private static final List EMPTY_LIST = List.nil();
    private static Map<File, ZipFileIndex> zipFileIndexCache = new HashMap<File, ZipFileIndex>();
    private static ReentrantLock lock = new ReentrantLock();
    private static boolean NON_BATCH_MODE = System.getProperty("nonBatchMode") != null;
    private Map<String, DirectoryEntry> directories = Collections.EMPTY_MAP;
    private Set<String> allDirs = Collections.EMPTY_SET;
    private File zipFile;
    private long zipFileLastModified = Long.MIN_VALUE;
    private RandomAccessFile zipRandomFile;
    private ZipFileIndexEntry[] entries;
    private boolean readFromIndex = false;
    private File zipIndexFile = null;
    private boolean triedToReadIndex = false;
    private int symbolFilePrefixLength = 0;
    private boolean hasPopulatedData = false;
    private long lastReferenceTimeStamp = Long.MIN_VALUE;
    private boolean usePreindexedCache = false;
    private String preindexedCacheLocation = null;
    private boolean writeIndex = false;
    private static Inflater inflater;

    public static java.util.List<ZipFileIndex> getZipFileIndexes() {
        return ZipFileIndex.getZipFileIndexes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.util.List<ZipFileIndex> getZipFileIndexes(boolean bl) {
        ArrayList<ZipFileIndex> arrayList = new ArrayList<ZipFileIndex>();
        lock.lock();
        try {
            arrayList.addAll(zipFileIndexCache.values());
            if (bl) {
                for (ZipFileIndex zipFileIndex : arrayList) {
                    if (zipFileIndex.isOpen()) continue;
                    arrayList.remove(zipFileIndex);
                }
            }
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        lock.lock();
        try {
            boolean bl = this.zipRandomFile != null;
            Object var3_2 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFileIndex getZipFileIndex(File file, int n, boolean bl, String string, boolean bl2) throws IOException {
        ZipFileIndex zipFileIndex = null;
        lock.lock();
        try {
            zipFileIndex = ZipFileIndex.getExistingZipIndex(file);
            if (zipFileIndex == null || zipFileIndex != null && file.lastModified() != zipFileIndex.zipFileLastModified) {
                zipFileIndex = new ZipFileIndex(file, n, bl2, bl, string);
                zipFileIndexCache.put(file, zipFileIndex);
            }
            Object var7_6 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
        return zipFileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipFileIndex getExistingZipIndex(File file) {
        lock.lock();
        try {
            ZipFileIndex zipFileIndex = zipFileIndexCache.get(file);
            Object var3_2 = null;
            lock.unlock();
            return zipFileIndex;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        lock.lock();
        try {
            zipFileIndexCache.clear();
            Object var1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(long l) {
        lock.lock();
        try {
            for (File file : zipFileIndexCache.keySet()) {
                long l2;
                ZipFileIndex zipFileIndex = zipFileIndexCache.get(file);
                if (zipFileIndex == null || (l2 = zipFileIndex.lastReferenceTimeStamp + l) >= zipFileIndex.lastReferenceTimeStamp && System.currentTimeMillis() <= l2) continue;
                zipFileIndexCache.remove(file);
            }
            Object var8_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromCache(File file) {
        lock.lock();
        try {
            zipFileIndexCache.remove(file);
            Object var2_1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOpenedIndexes(java.util.List<ZipFileIndex> list) throws IllegalStateException {
        lock.lock();
        try {
            if (zipFileIndexCache.isEmpty()) {
                throw new IllegalStateException("Setting opened indexes should be called only when the ZipFileCache is empty. Call JavacFileManager.flush() before calling this method.");
            }
            for (ZipFileIndex zipFileIndex : list) {
                zipFileIndexCache.put(zipFileIndex.zipFile, zipFileIndex);
            }
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private ZipFileIndex(File file, int n, boolean bl, boolean bl2, String string) throws IOException {
        this.zipFile = file;
        this.symbolFilePrefixLength = n;
        this.writeIndex = bl;
        this.usePreindexedCache = bl2;
        this.preindexedCacheLocation = string;
        if (file != null) {
            this.zipFileLastModified = file.lastModified();
        }
        this.checkIndex();
    }

    public String toString() {
        return "ZipFileIndex of file:(" + this.zipFile + ")";
    }

    protected void finalize() {
        this.closeFile();
    }

    private boolean isUpToDate() {
        return this.zipFile != null && (!NON_BATCH_MODE || this.zipFileLastModified == this.zipFile.lastModified()) && this.hasPopulatedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndex() throws IOException {
        boolean bl = true;
        if (!this.isUpToDate()) {
            this.closeFile();
            bl = false;
        }
        if (this.zipRandomFile != null || bl) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.hasPopulatedData = true;
        if (this.readIndex()) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.directories = Collections.EMPTY_MAP;
        this.allDirs = Collections.EMPTY_SET;
        try {
            this.openFile();
            long l = this.zipRandomFile.length();
            ZipDirectory zipDirectory = new ZipDirectory(this.zipRandomFile, 0L, l, this);
            zipDirectory.buildIndex();
            Object var6_4 = null;
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
            throw throwable;
        }
        this.lastReferenceTimeStamp = System.currentTimeMillis();
    }

    private void openFile() throws FileNotFoundException {
        if (this.zipRandomFile == null && this.zipFile != null) {
            this.zipRandomFile = new RandomAccessFile(this.zipFile, "r");
        }
    }

    private void cleanupState() {
        this.entries = ZipFileIndexEntry.EMPTY_ARRAY;
        this.directories = Collections.EMPTY_MAP;
        this.zipFileLastModified = Long.MIN_VALUE;
        this.allDirs = Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        lock.lock();
        try {
            this.writeIndex();
            this.closeFile();
            Object var2_1 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private void closeFile() {
        if (this.zipRandomFile != null) {
            try {
                this.zipRandomFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipRandomFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileIndexEntry getZipIndexEntry(String string) {
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        lock.lock();
        try {
            this.checkIndex();
            String string2 = "";
            int n = string.lastIndexOf(File.separatorChar);
            boolean bl = false;
            if (n == -1) {
                bl = true;
            }
            DirectoryEntry directoryEntry = this.directories.get(bl ? "" : string.substring(0, n));
            string2 = string.substring(bl ? 0 : n + 1);
            ZipFileIndexEntry zipFileIndexEntry = directoryEntry == null ? null : directoryEntry.getEntry(string2);
            Object var8_9 = null;
            lock.unlock();
            return zipFileIndexEntry;
        }
        catch (IOException iOException) {
            try {
                ZipFileIndexEntry zipFileIndexEntry = null;
                Object var8_10 = null;
                lock.unlock();
                return zipFileIndexEntry;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFiles(String string) {
        List list;
        block6: {
            if (File.separatorChar != '/') {
                string = string.replace('/', File.separatorChar);
            }
            lock.lock();
            this.checkIndex();
            DirectoryEntry directoryEntry = this.directories.get(string);
            List list2 = list = directoryEntry == null ? null : directoryEntry.getFiles();
            if (list != null) break block6;
            List list3 = EMPTY_LIST;
            Object var6_7 = null;
            lock.unlock();
            return list3;
        }
        try {
            List list4 = list;
            Object var6_8 = null;
            lock.unlock();
            return list4;
        }
        catch (IOException iOException) {
            try {
                list = EMPTY_LIST;
                Object var6_9 = null;
                lock.unlock();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<String> getAllDirectories(String string) {
        List list;
        block6: {
            if (File.separatorChar != '/') {
                string = string.replace('/', File.separatorChar);
            }
            lock.lock();
            this.checkIndex();
            string = string.intern();
            DirectoryEntry directoryEntry = this.directories.get(string);
            List list2 = list = directoryEntry == null ? null : directoryEntry.getDirectories();
            if (list != null) break block6;
            List list3 = EMPTY_LIST;
            Object var6_7 = null;
            lock.unlock();
            return list3;
        }
        try {
            List list4 = list;
            Object var6_8 = null;
            lock.unlock();
            return list4;
        }
        catch (IOException iOException) {
            try {
                list = EMPTY_LIST;
                Object var6_9 = null;
                lock.unlock();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllDirectories() {
        lock.lock();
        try {
            Set<String> set;
            this.checkIndex();
            if (this.allDirs == Collections.EMPTY_SET) {
                set = new HashSet<String>();
                Iterator<String> iterator = this.directories.keySet().iterator();
                while (iterator.hasNext()) {
                    set.add(new String(iterator.next()));
                }
                this.allDirs = set;
            }
            set = this.allDirs;
            Object var4_5 = null;
            lock.unlock();
            return set;
        }
        catch (IOException iOException) {
            try {
                Set set = Collections.EMPTY_SET;
                Object var4_6 = null;
                lock.unlock();
                return set;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) {
        lock.lock();
        try {
            this.checkIndex();
            boolean bl = this.getZipIndexEntry(string) != null;
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (IOException iOException) {
            try {
                boolean bl = false;
                Object var5_5 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String string) throws IOException {
        block4: {
            lock.lock();
            try {
                if (string.length() != 0) break block4;
                this.lastReferenceTimeStamp = System.currentTimeMillis();
                boolean bl = true;
                Object var4_4 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        this.checkIndex();
        boolean bl = this.directories.get(string) != null;
        Object var4_5 = null;
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String string) throws IOException {
        lock.lock();
        try {
            ZipFileIndexEntry zipFileIndexEntry = this.getZipIndexEntry(string);
            if (zipFileIndexEntry == null) {
                throw new FileNotFoundException();
            }
            long l = zipFileIndexEntry.getLastModified();
            Object var6_4 = null;
            lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length(String string) throws IOException {
        ZipFileIndexEntry zipFileIndexEntry;
        block6: {
            block5: {
                lock.lock();
                try {
                    zipFileIndexEntry = this.getZipIndexEntry(string);
                    if (zipFileIndexEntry == null) {
                        throw new FileNotFoundException();
                    }
                    if (!zipFileIndexEntry.isDir) break block5;
                    int n = 0;
                    Object var6_5 = null;
                    lock.unlock();
                    return n;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            byte[] byArray = this.getHeader(zipFileIndexEntry);
            if (ZipFileIndex.get2ByteLittleEndian(byArray, 8) != 0) break block6;
            int n = zipFileIndexEntry.compressedSize;
            Object var6_6 = null;
            lock.unlock();
            return n;
        }
        int n = zipFileIndexEntry.size;
        Object var6_7 = null;
        lock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String string) throws IOException {
        lock.lock();
        try {
            ZipFileIndexEntry zipFileIndexEntry = this.getZipIndexEntry(string);
            if (zipFileIndexEntry == null) {
                throw new FileNotFoundException(MessageFormat.format("Path not found in ZIP: {0}", string));
            }
            byte[] byArray = this.read(zipFileIndexEntry);
            Object var5_4 = null;
            lock.unlock();
            return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(ZipFileIndexEntry zipFileIndexEntry) throws IOException {
        lock.lock();
        try {
            this.openFile();
            byte[] byArray = this.readBytes(zipFileIndexEntry);
            this.closeFile();
            byte[] byArray2 = byArray;
            Object var5_4 = null;
            lock.unlock();
            return byArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(String string, byte[] byArray) throws IOException {
        lock.lock();
        try {
            ZipFileIndexEntry zipFileIndexEntry = this.getZipIndexEntry(string);
            if (zipFileIndexEntry == null) {
                throw new FileNotFoundException();
            }
            int n = this.read(zipFileIndexEntry, byArray);
            Object var6_5 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ZipFileIndexEntry zipFileIndexEntry, byte[] byArray) throws IOException {
        lock.lock();
        try {
            int n;
            int n2 = n = this.readBytes(zipFileIndexEntry, byArray);
            Object var6_5 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private byte[] readBytes(ZipFileIndexEntry zipFileIndexEntry) throws IOException {
        byte[] byArray = this.getHeader(zipFileIndexEntry);
        int n = zipFileIndexEntry.compressedSize;
        byte[] byArray2 = new byte[n];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray, 26) + ZipFileIndex.get2ByteLittleEndian(byArray, 28));
        this.zipRandomFile.readFully(byArray2, 0, n);
        if (ZipFileIndex.get2ByteLittleEndian(byArray, 8) == 0) {
            return byArray2;
        }
        int n2 = zipFileIndexEntry.size;
        byte[] byArray3 = new byte[n2];
        if (this.inflate(byArray2, byArray3) != n2) {
            throw new ZipException("corrupted zip file");
        }
        return byArray3;
    }

    private int readBytes(ZipFileIndexEntry zipFileIndexEntry, byte[] byArray) throws IOException {
        byte[] byArray2 = this.getHeader(zipFileIndexEntry);
        if (ZipFileIndex.get2ByteLittleEndian(byArray2, 8) == 0) {
            int n;
            this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray2, 26) + ZipFileIndex.get2ByteLittleEndian(byArray2, 28));
            int n2 = byArray.length;
            for (int i = 0; i < n2 && (n = this.zipRandomFile.read(byArray, i, n2 - i)) != -1; i += n) {
            }
            return zipFileIndexEntry.size;
        }
        int n = zipFileIndexEntry.compressedSize;
        byte[] byArray3 = new byte[n];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray2, 26) + ZipFileIndex.get2ByteLittleEndian(byArray2, 28));
        this.zipRandomFile.readFully(byArray3, 0, n);
        int n3 = this.inflate(byArray3, byArray);
        if (n3 == -1) {
            throw new ZipException("corrupted zip file");
        }
        return zipFileIndexEntry.size;
    }

    private byte[] getHeader(ZipFileIndexEntry zipFileIndexEntry) throws IOException {
        this.zipRandomFile.seek(zipFileIndexEntry.offset);
        byte[] byArray = new byte[30];
        this.zipRandomFile.readFully(byArray);
        if (ZipFileIndex.get4ByteLittleEndian(byArray, 0) != 67324752) {
            throw new ZipException("corrupted zip file");
        }
        if ((ZipFileIndex.get2ByteLittleEndian(byArray, 6) & 1) != 0) {
            throw new ZipException("encrypted zip file");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int inflate(byte[] byArray, byte[] byArray2) {
        if (inflater == null) {
            inflater = new Inflater(true);
        }
        Inflater inflater = ZipFileIndex.inflater;
        synchronized (inflater) {
            ZipFileIndex.inflater.reset();
            ZipFileIndex.inflater.setInput(byArray);
            try {
                return ZipFileIndex.inflater.inflate(byArray2);
            }
            catch (DataFormatException dataFormatException) {
                return -1;
            }
        }
    }

    private static int get2ByteLittleEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    private static int get4ByteLittleEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZipFileLastModified() throws IOException {
        lock.lock();
        try {
            this.checkIndex();
            long l = this.zipFileLastModified;
            Object var4_2 = null;
            lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean readIndex() {
        if (this.triedToReadIndex || !this.usePreindexedCache) {
            return false;
        }
        var1_1 = false;
        ZipFileIndex.lock.lock();
        try {
            block18: {
                this.triedToReadIndex = true;
                var2_2 = null;
                try {
                    block17: {
                        var3_3 = this.getIndexFile();
                        var2_2 = new RandomAccessFile(var3_3, "r");
                        var4_5 = var2_2.readLong();
                        if (this.zipFile.lastModified() != var4_5) {
                            var1_1 = false;
                            break block17;
                        }
                        this.directories = new HashMap<String, DirectoryEntry>();
                        var6_6 = var2_2.readInt();
                        for (var7_7 = 0; var7_7 < var6_6; ++var7_7) {
                            var8_8 = var2_2.readInt();
                            var9_9 = new byte[var8_8];
                            var2_2.read(var9_9);
                            var10_10 = new String(var9_9, "UTF-8");
                            var11_11 = new DirectoryEntry(var10_10, this);
                            DirectoryEntry.access$1502(var11_11, var2_2.readInt());
                            DirectoryEntry.access$1602(var11_11, var2_2.readLong());
                            this.directories.put(var10_10, var11_11);
                        }
                        var1_1 = true;
                        this.zipFileLastModified = var4_5;
                    }
                    var13_12 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var12_18) {
                    var13_14 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (Throwable var14_17) {
                            // empty catch block
                        }
                    }
                    throw var12_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_2.close();
                    }
                    catch (Throwable var14_15) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                    catch (Throwable var3_4) {
                        var13_13 = null;
                        if (var2_2 != null) {
                            try {
                                var2_2.close();
                            }
                            catch (Throwable var14_16) {}
                        }
                    }
                }
            }
            if (var1_1) {
                this.readFromIndex = true;
            }
            var16_19 = null;
            ZipFileIndex.lock.unlock();
        }
        catch (Throwable var15_21) {
            var16_20 = null;
            ZipFileIndex.lock.unlock();
            throw var15_21;
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writeIndex() {
        boolean bl;
        block17: {
            bl = false;
            if (this.readFromIndex || !this.usePreindexedCache) {
                return true;
            }
            if (!this.writeIndex) {
                return true;
            }
            File file = this.getIndexFile();
            if (file == null) {
                return false;
            }
            RandomAccessFile randomAccessFile = null;
            long l = 0L;
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeLong(this.zipFileLastModified);
            l += 8L;
            Iterator<String> iterator = this.directories.keySet().iterator();
            ArrayList<DirectoryEntry> arrayList = new ArrayList<DirectoryEntry>();
            HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
            randomAccessFile.writeInt(this.directories.keySet().size());
            l += 4L;
            while (iterator.hasNext()) {
                String string = iterator.next();
                DirectoryEntry directoryEntry = this.directories.get(string);
                arrayList.add(directoryEntry);
                byte[] byArray = string.getBytes("UTF-8");
                int n = byArray.length;
                randomAccessFile.writeInt(n);
                l += 4L;
                randomAccessFile.write(byArray);
                l += (long)n;
                java.util.List<ZipFileIndexEntry> list = directoryEntry.getEntriesAsCollection();
                randomAccessFile.writeInt(list.size());
                hashMap.put(string, new Long(l += 4L));
                directoryEntry.writtenOffsetOffset = 0L;
                randomAccessFile.writeLong(0L);
                l += 8L;
            }
            for (DirectoryEntry directoryEntry : arrayList) {
                long l2 = randomAccessFile.getFilePointer();
                long l3 = (Long)hashMap.get(directoryEntry.dirName);
                randomAccessFile.seek(l3);
                randomAccessFile.writeLong(l);
                randomAccessFile.seek(l2);
                java.util.List<ZipFileIndexEntry> list = directoryEntry.getEntriesAsCollection();
                for (ZipFileIndexEntry zipFileIndexEntry : list) {
                    byte[] byArray = zipFileIndexEntry.name.getBytes("UTF-8");
                    int n = byArray.length;
                    randomAccessFile.writeInt(n);
                    l += 4L;
                    randomAccessFile.write(byArray);
                    l += (long)n;
                    randomAccessFile.writeByte(zipFileIndexEntry.isDir ? 1 : 0);
                    ++l;
                    randomAccessFile.writeInt(zipFileIndexEntry.offset);
                    l += 4L;
                    randomAccessFile.writeInt(zipFileIndexEntry.size);
                    l += 4L;
                    randomAccessFile.writeInt(zipFileIndexEntry.compressedSize);
                    l += 4L;
                    randomAccessFile.writeLong(zipFileIndexEntry.getLastModified());
                    l += 8L;
                }
            }
            Object var21_21 = null;
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                break block17;
            }
            catch (IOException iOException) {}
            break block17;
            {
                catch (Throwable throwable) {
                    Object var21_22 = null;
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeZipIndex() {
        lock.lock();
        try {
            boolean bl = this.writeIndex();
            Object var3_2 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private File getIndexFile() {
        if (this.zipIndexFile == null) {
            if (this.zipFile == null) {
                return null;
            }
            this.zipIndexFile = new File((this.preindexedCacheLocation == null ? "" : this.preindexedCacheLocation) + this.zipFile.getName() + ".index");
        }
        return this.zipIndexFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    static /* synthetic */ ZipFileIndexEntry[] access$602(ZipFileIndex zipFileIndex, ZipFileIndexEntry[] zipFileIndexEntryArray) {
        zipFileIndex.entries = zipFileIndexEntryArray;
        return zipFileIndexEntryArray;
    }

    static /* synthetic */ List access$1000() {
        return EMPTY_LIST;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DirectoryEntry {
        private boolean filesInited = false;
        private boolean directoriesInited = false;
        private boolean zipFileEntriesInited;
        private boolean entriesInited = false;
        private long writtenOffsetOffset = 0L;
        private String dirName;
        private List<String> zipFileEntriesFiles = ZipFileIndex.access$1000();
        private List<String> zipFileEntriesDirectories = ZipFileIndex.access$1000();
        private List<ZipFileIndexEntry> zipFileEntries = ZipFileIndex.access$1000();
        private java.util.List<ZipFileIndexEntry> entries = new ArrayList<ZipFileIndexEntry>();
        private ZipFileIndex zipFileIndex;
        private int numEntries;

        DirectoryEntry(String string, ZipFileIndex zipFileIndex) {
            if (File.separatorChar == '/') {
                string.replace('\\', '/');
            } else {
                string.replace('/', '\\');
            }
            this.dirName = string.intern();
            this.zipFileIndex = zipFileIndex;
        }

        private List<String> getFiles() {
            if (this.filesInited) {
                return this.zipFileEntriesFiles;
            }
            this.initEntries();
            for (ZipFileIndexEntry zipFileIndexEntry : this.entries) {
                if (zipFileIndexEntry.isDir) continue;
                this.zipFileEntriesFiles = this.zipFileEntriesFiles.append(zipFileIndexEntry.name);
            }
            this.filesInited = true;
            return this.zipFileEntriesFiles;
        }

        private List<String> getDirectories() {
            if (this.directoriesInited) {
                return this.zipFileEntriesFiles;
            }
            this.initEntries();
            for (ZipFileIndexEntry zipFileIndexEntry : this.entries) {
                if (!zipFileIndexEntry.isDir) continue;
                this.zipFileEntriesDirectories = this.zipFileEntriesDirectories.append(zipFileIndexEntry.name);
            }
            this.directoriesInited = true;
            return this.zipFileEntriesDirectories;
        }

        private List<ZipFileIndexEntry> getEntries() {
            if (this.zipFileEntriesInited) {
                return this.zipFileEntries;
            }
            this.initEntries();
            this.zipFileEntries = List.nil();
            for (ZipFileIndexEntry zipFileIndexEntry : this.entries) {
                this.zipFileEntries = this.zipFileEntries.append(zipFileIndexEntry);
            }
            this.zipFileEntriesInited = true;
            return this.zipFileEntries;
        }

        private ZipFileIndexEntry getEntry(String string) {
            this.initEntries();
            int n = Collections.binarySearch(this.entries, new ZipFileIndexEntry(this.dirName, string));
            if (n < 0) {
                return null;
            }
            return this.entries.get(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void initEntries() {
            block15: {
                block16: {
                    if (this.entriesInited) {
                        return;
                    }
                    if (this.zipFileIndex.readFromIndex) break block16;
                    int n = -Arrays.binarySearch(this.zipFileIndex.entries, new ZipFileIndexEntry(this.dirName, MIN_CHAR)) - 1;
                    int n2 = -Arrays.binarySearch(this.zipFileIndex.entries, new ZipFileIndexEntry(this.dirName, MAX_CHAR)) - 1;
                    boolean bl = false;
                    for (int i = n; i < n2; ++i) {
                        this.entries.add(this.zipFileIndex.entries[i]);
                    }
                    break block15;
                }
                File file = this.zipFileIndex.getIndexFile();
                if (file != null) {
                    RandomAccessFile randomAccessFile = null;
                    randomAccessFile = new RandomAccessFile(file, "r");
                    randomAccessFile.seek(this.writtenOffsetOffset);
                    for (int i = 0; i < this.numEntries; ++i) {
                        int n = randomAccessFile.readInt();
                        byte[] byArray = new byte[n];
                        randomAccessFile.read(byArray);
                        String string = new String(byArray, "UTF-8");
                        boolean bl = randomAccessFile.readByte() != 0;
                        int n3 = randomAccessFile.readInt();
                        int n4 = randomAccessFile.readInt();
                        int n5 = randomAccessFile.readInt();
                        long l = randomAccessFile.readLong();
                        ZipFileIndexEntry zipFileIndexEntry = new ZipFileIndexEntry(this.dirName, string);
                        zipFileIndexEntry.isDir = bl;
                        zipFileIndexEntry.offset = n3;
                        zipFileIndexEntry.size = n4;
                        zipFileIndexEntry.compressedSize = n5;
                        zipFileIndexEntry.javatime = l;
                        this.entries.add(zipFileIndexEntry);
                    }
                    Object var15_18 = null;
                    try {
                        if (randomAccessFile == null) {
                            randomAccessFile.close();
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {}
                    break block15;
                    {
                        catch (Throwable throwable) {
                            Object var15_19 = null;
                            try {
                                if (randomAccessFile == null) {
                                    randomAccessFile.close();
                                }
                                break block15;
                            }
                            catch (Throwable throwable2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_20 = null;
                        try {
                            if (randomAccessFile == null) {
                                randomAccessFile.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            this.entriesInited = true;
        }

        java.util.List<ZipFileIndexEntry> getEntriesAsCollection() {
            this.initEntries();
            return this.entries;
        }

        static /* synthetic */ int access$1502(DirectoryEntry directoryEntry, int n) {
            directoryEntry.numEntries = n;
            return directoryEntry.numEntries;
        }
    }

    private class ZipDirectory {
        private String lastDir;
        private int lastStart;
        private int lastLen;
        byte[] zipDir;
        RandomAccessFile zipRandomFile = null;
        ZipFileIndex zipFileIndex = null;

        public ZipDirectory(RandomAccessFile randomAccessFile, long l, long l2, ZipFileIndex zipFileIndex2) throws IOException {
            this.zipRandomFile = randomAccessFile;
            this.zipFileIndex = zipFileIndex2;
            this.findCENRecord(l, l2);
        }

        private void findCENRecord(long l, long l2) throws IOException {
            long l3 = l2 - l;
            int n = 1024;
            byte[] byArray = new byte[n];
            long l4 = l2 - l;
            while (l4 >= 22L) {
                int n2;
                if (l4 < (long)n) {
                    n = (int)l4;
                }
                long l5 = l4 - (long)n;
                this.zipRandomFile.seek(l + l5);
                this.zipRandomFile.readFully(byArray, 0, n);
                for (n2 = n - 22; n2 >= 0 && (byArray[n2] != 80 || byArray[n2 + 1] != 75 || byArray[n2 + 2] != 5 || byArray[n2 + 3] != 6 || l5 + (long)n2 + 22L + (long)ZipFileIndex.get2ByteLittleEndian(byArray, n2 + 20) != l3); --n2) {
                }
                if (n2 >= 0) {
                    this.zipDir = new byte[ZipFileIndex.get4ByteLittleEndian(byArray, n2 + 12) + 2];
                    this.zipDir[0] = byArray[n2 + 10];
                    this.zipDir[1] = byArray[n2 + 11];
                    this.zipRandomFile.seek(l + (long)ZipFileIndex.get4ByteLittleEndian(byArray, n2 + 16));
                    this.zipRandomFile.readFully(this.zipDir, 2, this.zipDir.length - 2);
                    return;
                }
                l4 = l5 + 21L;
            }
            throw new ZipException("cannot read zip file");
        }

        private void buildIndex() throws IOException {
            int n = ZipFileIndex.get2ByteLittleEndian(this.zipDir, 0);
            ZipFileIndex.access$602(ZipFileIndex.this, new ZipFileIndexEntry[n]);
            if (n > 0) {
                ZipFileIndex.this.directories = new HashMap();
                ArrayList<ZipFileIndexEntry> arrayList = new ArrayList<ZipFileIndexEntry>();
                int n2 = 2;
                for (int i = 0; i < n; ++i) {
                    n2 = this.readEntry(n2, arrayList, ZipFileIndex.this.directories);
                }
                Iterator iterator = ZipFileIndex.this.directories.keySet().iterator();
                while (iterator.hasNext()) {
                    ZipFileIndexEntry zipFileIndexEntry = new ZipFileIndexEntry((String)iterator.next());
                    zipFileIndexEntry.isDir = true;
                    arrayList.add(zipFileIndexEntry);
                }
                ZipFileIndex.access$602(ZipFileIndex.this, arrayList.toArray(new ZipFileIndexEntry[arrayList.size()]));
                Arrays.sort(ZipFileIndex.this.entries);
            } else {
                ZipFileIndex.this.cleanupState();
            }
        }

        private int readEntry(int n, java.util.List list, Map map) throws IOException {
            int n2;
            int n3;
            if (ZipFileIndex.get4ByteLittleEndian(this.zipDir, n) != 33639248) {
                throw new ZipException("cannot read zip file entry");
            }
            int n4 = n3 = n + 46;
            int n5 = n4 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 28);
            if (this.zipFileIndex.symbolFilePrefixLength != 0 && n5 - n4 >= ZipFileIndex.this.symbolFilePrefixLength) {
                n3 += this.zipFileIndex.symbolFilePrefixLength;
                n4 += this.zipFileIndex.symbolFilePrefixLength;
            }
            for (int i = n4; i < n5; ++i) {
                n2 = this.zipDir[i];
                if (n2 != 92 && n2 != 47) continue;
                this.zipDir[i] = (byte)File.separatorChar;
                n4 = i + 1;
            }
            String string = null;
            if (n4 == n3) {
                string = "";
            } else if (this.lastDir != null && this.lastLen == n4 - n3 - 1) {
                n2 = this.lastLen - 1;
                while (this.zipDir[this.lastStart + n2] == this.zipDir[n3 + n2]) {
                    if (n2 == 0) {
                        string = this.lastDir;
                        break;
                    }
                    --n2;
                }
            }
            if (string == null) {
                this.lastStart = n3;
                this.lastLen = n4 - n3 - 1;
                this.lastDir = string = new String(this.zipDir, n3, this.lastLen, "UTF-8").intern();
                String string2 = string;
                while (map.get(string2) == null) {
                    map.put(string2, new DirectoryEntry(string2, this.zipFileIndex));
                    int n6 = string2.lastIndexOf(File.separatorChar);
                    if (n6 != -1) {
                        string2 = string2.substring(0, n6);
                        continue;
                    }
                    break;
                }
            } else if (map.get(string = string.intern()) == null) {
                map.put(string, new DirectoryEntry(string, this.zipFileIndex));
            }
            if (n4 != n5) {
                ZipFileIndexEntry zipFileIndexEntry = new ZipFileIndexEntry(string, new String(this.zipDir, n4, n5 - n4, "UTF-8"));
                zipFileIndexEntry.setNativeTime(ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 12));
                zipFileIndexEntry.compressedSize = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 20);
                zipFileIndexEntry.size = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 24);
                zipFileIndexEntry.offset = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 42);
                list.add(zipFileIndexEntry);
            }
            return n + 46 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 28) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 30) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 32);
        }
    }
}

