/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.fx.ui.panes.AbstractLayoutPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FillLayoutPane
extends AbstractLayoutPane<FillData> {
    private static final CssMetaData<FillLayoutPane, Number> MARGIN_WIDTH = new CssMetaData<FillLayoutPane, Number>("-fx-inner-margin-width", SizeConverter.getInstance(), (Number)0){

        public boolean isSettable(FillLayoutPane node) {
            return !node.marginWidthProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(FillLayoutPane node) {
            return (StyleableProperty)node.marginWidthProperty();
        }
    };
    private static final CssMetaData<FillLayoutPane, Number> MARGIN_HEIGHT = new CssMetaData<FillLayoutPane, Number>("-fx-inner-margin-height", SizeConverter.getInstance(), (Number)0){

        public boolean isSettable(FillLayoutPane node) {
            return !node.marginHeightProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(FillLayoutPane node) {
            return (StyleableProperty)node.marginHeightProperty();
        }
    };
    private static final CssMetaData<FillLayoutPane, Number> SPACING = new CssMetaData<FillLayoutPane, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0){

        public boolean isSettable(FillLayoutPane node) {
            return !node.spacingProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(FillLayoutPane node) {
            return (StyleableProperty)node.spacingProperty();
        }
    };
    private static final CssMetaData<FillLayoutPane, Boolean> HORIZONTAL = new CssMetaData<FillLayoutPane, Boolean>("-fx-horizontal", BooleanConverter.getInstance(), Boolean.TRUE){

        public boolean isSettable(FillLayoutPane node) {
            return !node.horizontalProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(FillLayoutPane node) {
            return (StyleableProperty)node.horizontalProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private final @NonNull BooleanProperty horizontal = new SimpleStyleableBooleanProperty(HORIZONTAL, (Object)this, "horizontal", true);
    private final @NonNull IntegerProperty marginWidth = new SimpleStyleableIntegerProperty(MARGIN_WIDTH, (Object)this, "marginWidth", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginHeight = new SimpleStyleableIntegerProperty(MARGIN_HEIGHT, (Object)this, "marginHeight", Integer.valueOf(0));
    private final @NonNull IntegerProperty spacing = new SimpleStyleableIntegerProperty(SPACING, (Object)this, "spacing", Integer.valueOf(0));
    private static final @NonNull String LAYOUT_KEY = "fillData";

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(AbstractLayoutPane.getClassCssMetaData());
        styleables.add(MARGIN_WIDTH);
        styleables.add(MARGIN_HEIGHT);
        styleables.add(SPACING);
        styleables.add(HORIZONTAL);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FillLayoutPane.getClassCssMetaData();
    }

    public static final void setConstraint(@NonNull Node n, @NonNull FillData data) {
        FillLayoutPane.setConstraint(n, LAYOUT_KEY, data);
    }

    public static final @Nullable FillData getConstraint(@NonNull Node n) {
        return (FillData)FillLayoutPane.getConstraint(n, LAYOUT_KEY);
    }

    public final void setHorizontal(boolean horizontal) {
        this.horizontal.set(horizontal);
    }

    public final boolean isHorizontal() {
        return this.horizontal.get();
    }

    public final @NonNull BooleanProperty horizontalProperty() {
        return this.horizontal;
    }

    public final void setMarginWidth(int marginWidth) {
        this.marginWidth.set(marginWidth);
    }

    public final int getMarginWidth() {
        return this.marginWidth.get();
    }

    public final @NonNull IntegerProperty marginWidthProperty() {
        return this.marginWidth;
    }

    public final @NonNull IntegerProperty marginHeightProperty() {
        return this.marginHeight;
    }

    public final void setMarginHeight(int marginHeight) {
        this.marginHeight.set(marginHeight);
    }

    public final int getMarginHeight() {
        return this.marginHeight.get();
    }

    public final @NonNull IntegerProperty spacingProperty() {
        return this.spacing;
    }

    public final int getSpacing() {
        return this.spacing.get();
    }

    public final void setSpacing(int spacing) {
        this.spacing.set(spacing);
    }

    @Override
    protected AbstractLayoutPane.Size computeSize(double wHint, double hHint, boolean flushCache) {
        @NonNull Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = children.length;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        int i = 0;
        while (i < count) {
            Node child = children[i];
            double w = wHint;
            double h = hHint;
            if (count > 0) {
                if (this.horizontal.get() && wHint != -1.0) {
                    w = Math.max(0.0, (wHint - (double)((count - 1) * this.spacing.get())) / (double)count);
                }
                if (!this.horizontal.get() && hHint != -1.0) {
                    h = Math.max(0.0, (hHint - (double)((count - 1) * this.spacing.get())) / (double)count);
                }
            }
            AbstractLayoutPane.Size size = FillLayoutPane.computeChildSize(child, w, h, flushCache);
            maxWidth = Math.max(maxWidth, size.width);
            maxHeight = Math.max(maxHeight, size.height);
            ++i;
        }
        double width = 0.0;
        double height = 0.0;
        if (this.horizontal.get()) {
            width = (double)count * maxWidth;
            if (count != 0) {
                width += (double)((count - 1) * this.spacing.get());
            }
            height = maxHeight;
        } else {
            width = maxWidth;
            height = (double)count * maxHeight;
            if (count != 0) {
                height += (double)((count - 1) * this.spacing.get());
            }
        }
        width += (double)(this.marginWidth.get() * 2) + this.getPadding().getLeft() + this.getPadding().getRight();
        height += (double)(this.marginHeight.get() * 2) + this.getPadding().getTop() + this.getPadding().getBottom();
        if (wHint != -1.0) {
            width = wHint;
        }
        if (hHint != -1.0) {
            height = hHint;
        }
        return new AbstractLayoutPane.Size(width, height);
    }

    static AbstractLayoutPane.Size computeChildSize(@NonNull Node control, double wHint, double hHint, boolean flushCache) {
        FillData data = FillLayoutPane.getConstraint(control);
        if (data == null) {
            data = new FillData();
            FillLayoutPane.setConstraint(control, data);
        }
        AbstractLayoutPane.Size size = null;
        if (wHint == -1.0 && hHint == -1.0) {
            size = data.computeSize(control, wHint, hHint, flushCache);
        } else {
            boolean trimY = false;
            boolean trimX = false;
            double w = wHint == -1.0 ? wHint : Math.max(0.0, wHint - (double)trimX);
            double h = hHint == -1.0 ? hHint : Math.max(0.0, hHint - (double)trimY);
            size = data.computeSize(control, w, h, flushCache);
        }
        return size;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Bounds rect = this.getLayoutBounds();
        Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = children.length;
        if (count == 0) {
            return;
        }
        double width = rect.getWidth() - (double)(this.marginWidth.get() * 2) - this.getPadding().getLeft() - this.getPadding().getRight();
        double height = rect.getHeight() - (double)(this.marginHeight.get() * 2) - this.getPadding().getTop() - this.getPadding().getBottom();
        if (this.horizontal.get()) {
            double x = rect.getMinX() + this.getPadding().getLeft() + (double)this.marginWidth.get();
            double extra = (width -= (double)((count - 1) * this.spacing.get())) % (double)count;
            double y = rect.getMinY() + this.getPadding().getTop() + (double)this.marginHeight.get();
            double cellWidth = width / (double)count;
            int i = 0;
            while (i < count) {
                Node child = children[i];
                double childWidth = cellWidth;
                if (i == 0) {
                    childWidth += extra / 2.0;
                } else if (i == count - 1) {
                    childWidth += (extra + 1.0) / 2.0;
                }
                childWidth = Math.max(childWidth, child.minWidth(height));
                child.resizeRelocate(x, y, childWidth, Math.max(height, child.minHeight(childWidth)));
                x += childWidth + (double)this.spacing.get();
                ++i;
            }
        } else {
            double x = rect.getMinX() + this.getPadding().getLeft() + (double)this.marginWidth.get();
            double cellHeight = (height -= (double)((count - 1) * this.spacing.get())) / (double)count;
            double y = rect.getMinY() + this.getPadding().getTop() + (double)this.marginHeight.get();
            double extra = height % (double)count;
            int i = 0;
            while (i < count) {
                Node child = children[i];
                double childHeight = cellHeight;
                if (i == 0) {
                    childHeight += extra / 2.0;
                } else if (i == count - 1) {
                    childHeight += (extra + 1.0) / 2.0;
                }
                childHeight = Math.max(childHeight, child.minHeight(width));
                child.resizeRelocate(x, y, Math.max(width, child.minWidth(childHeight)), childHeight);
                y += childHeight + (double)this.spacing.get();
                ++i;
            }
        }
    }

    static class FillData {
        double defaultWidth = -1.0;
        double defaultHeight = -1.0;
        double currentWhint;
        double currentHhint;
        double currentWidth = -1.0;
        double currentHeight = -1.0;

        FillData() {
        }

        AbstractLayoutPane.Size computeSize(Node control, double wHint, double hHint, boolean flushCache) {
            if (flushCache) {
                this.flushCache();
            }
            if (wHint == -1.0 && hHint == -1.0) {
                if (this.defaultWidth == -1.0 || this.defaultHeight == -1.0) {
                    this.defaultWidth = control.prefWidth(hHint);
                    this.defaultHeight = control.prefHeight(wHint);
                }
                return new AbstractLayoutPane.Size(this.defaultWidth, this.defaultHeight);
            }
            if (this.currentWidth == -1.0 || this.currentHeight == -1.0 || wHint != this.currentWhint || hHint != this.currentHhint) {
                this.currentWhint = wHint;
                this.currentHhint = hHint;
                this.currentWidth = control.getLayoutBounds().getWidth();
                this.currentHeight = control.getLayoutBounds().getHeight();
            }
            return new AbstractLayoutPane.Size(this.currentWidth, this.currentHeight);
        }

        void flushCache() {
            this.defaultHeight = -1.0;
            this.defaultWidth = -1.0;
            this.currentHeight = -1.0;
            this.currentWidth = -1.0;
        }
    }
}

