/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.contentassist;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.fxgraph.fXGraph.BindValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ConstValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FXGraphPackage;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.MapValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.ui.contentassist.AbstractFXGraphProposalProvider;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXCollectionProperty;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.IFXEnumProperty;
import org.eclipse.fx.ide.model.IFXEventHandlerProperty;
import org.eclipse.fx.ide.model.IFXMapProperty;
import org.eclipse.fx.ide.model.IFXObjectProperty;
import org.eclipse.fx.ide.model.IFXPrimitiveProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.fx.ide.model.Util;
import org.eclipse.fx.ide.ui.editor.IValueOfContributor;
import org.eclipse.fx.ide.ui.editor.ValueOfContributionCollector;
import org.eclipse.fx.ide.ui.util.IconKeys;
import org.eclipse.fx.ide.ui.util.RelativeFileLocator;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.JdtHoverProvider;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;

public class FXGraphProposalProvider
extends AbstractFXGraphProposalProvider {
    private static final Logger LOGGER = Logger.getLogger(FXGraphProposalProvider.class);
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private ITypesProposalProvider typeProposalProviders;
    @Inject
    private IJvmTypeProvider.Factory jdtTypeProvider;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private ValueOfContributionCollector valueOfCollector;

    private int getPropertiesProposalsProposals() {
        return this.getPriorityHelper().getDefaultPriority() + 1;
    }

    @Override
    public void completeElement_DefaultChildren(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            IFXProperty prop;
            IFXClass fxClazz;
            IJavaProject javaProject;
            IType type;
            Element el = (Element)model;
            if ("void".equals(el.getType().getQualifiedName())) {
                if (!(model.eContainer() instanceof Element)) {
                    return;
                }
                el = (Element)model.eContainer();
            }
            if ((type = (javaProject = this.projectProvider.getJavaProject(el.eResource().getResourceSet())).findType(el.getType().getQualifiedName())) != null && (fxClazz = FXPlugin.getClassmodel().findClass(javaProject, type)) != null && (prop = fxClazz.getDefaultProperty()) != null) {
                this.completeElement_DefaultChildrenProposals(prop, (EObject)el, context, FXGraphPackage.Literals.ELEMENT__DEFAULT_CHILDREN, acceptor);
            }
        }
        catch (JavaModelException e) {
            LOGGER.error((Object)"Failed to complete default children", (Throwable)e);
        }
    }

    private void completeElement_DefaultChildrenProposals(IFXProperty prop, EObject model, ContentAssistContext context, EReference typeReference, ICompletionProposalAcceptor acceptor) {
        if (prop instanceof IFXCollectionProperty) {
            this.createCollectionClassProposals((IFXCollectionProperty)prop, model, context, typeReference, acceptor);
        }
    }

    private void createCollectionClassProposals(IFXCollectionProperty prop, EObject model, ContentAssistContext context, EReference typeReference, ICompletionProposalAcceptor acceptor) {
        IType jdtSuperType = prop.getElementType();
        if (jdtSuperType != null) {
            JvmType superType = this.jdtTypeProvider.findOrCreateTypeProvider(model.eResource().getResourceSet()).findTypeByName(jdtSuperType.getFullyQualifiedName());
            FXClassFilter f = new FXClassFilter(this.projectProvider.getJavaProject(model.eResource().getResourceSet()));
            this.typeProposalProviders.createSubTypeProposals(superType, (ICompletionProposalFactory)this, context, typeReference, (ITypesProposalProvider.Filter)f, acceptor);
        }
    }

    @Override
    public void completeElement_Properties(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            IFXClass fxClazz;
            IJavaProject javaProject;
            IType type;
            IFXClass fxClazz2;
            Element el = (Element)model;
            if ("void".equals(el.getType().getQualifiedName())) {
                if (!(model.eContainer() instanceof Element)) {
                    return;
                }
                el = (Element)model.eContainer();
            }
            Element propertyTarget = el;
            IJavaProject javaProject2 = this.projectProvider.getJavaProject(el.eResource().getResourceSet());
            IType type2 = javaProject2.findType(el.getType().getQualifiedName());
            if (type2 != null && (fxClazz2 = FXPlugin.getClassmodel().findClass(javaProject2, type2)) != null) {
                Map map = fxClazz2.getAllProperties();
                for (IFXProperty p : map.values()) {
                    this.completeElement_PropertiesProposals(p, (EObject)el, context, (EStructuralFeature)FXGraphPackage.Literals.ELEMENT__PROPERTIES, acceptor, propertyTarget, (EStructuralFeature)FXGraphPackage.Literals.ELEMENT__PROPERTIES);
                }
            }
            Element o = el;
            el = null;
            while (o.eContainer() != null) {
                if (o.eContainer() instanceof Element) {
                    el = (Element)o.eContainer();
                    break;
                }
                if (o.eContainer() instanceof MapValueProperty) {
                    el = null;
                    break;
                }
                o = o.eContainer();
            }
            if (el instanceof Element && (type = (javaProject = this.projectProvider.getJavaProject(el.eResource().getResourceSet())).findType(el.getType().getQualifiedName())) != null && (fxClazz = FXPlugin.getClassmodel().findClass(javaProject, type)) != null) {
                Map map = fxClazz.getAllStaticProperties();
                for (IFXProperty p : map.values()) {
                    this.completeElement_PropertiesProposals(p, (EObject)el, context, (EStructuralFeature)FXGraphPackage.Literals.ELEMENT__STATIC_PROPERTIES, acceptor, propertyTarget, (EStructuralFeature)FXGraphPackage.Literals.ELEMENT__STATIC_PROPERTIES);
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.error((Object)"Failed to complete properties", (Throwable)e);
        }
    }

    private void completeElement_PropertiesProposals(IFXProperty prop, EObject model, ContentAssistContext context, EStructuralFeature typeReference, ICompletionProposalAcceptor acceptor, Element propertyTarget, EStructuralFeature propertyListFeature) {
        if (propertyTarget instanceof Element) {
            System.err.println(propertyTarget.getType());
            List items = (List)propertyTarget.eGet(propertyListFeature);
            System.err.println("ITEMS: " + items);
            for (EObject i : items) {
                System.err.println(i);
                if (i instanceof Property) {
                    if (!((Property)i).getName().equals(prop.getName())) continue;
                    return;
                }
                if (i instanceof StaticValueProperty) {
                    System.err.println("CHECKING STATIC");
                    if (!((StaticValueProperty)i).getName().equals(prop.getName())) continue;
                    return;
                }
                if (!(i instanceof StaticCallValueProperty) || !((StaticCallValueProperty)i).getName().equals(prop.getName())) continue;
                return;
            }
        }
        if (prop instanceof IFXCollectionProperty) {
            this.createCollectionPropnameProposals((IFXCollectionProperty)prop, model, context, typeReference, acceptor);
        } else if (prop instanceof IFXMapProperty) {
            this.createMapPropnameProposals((IFXMapProperty)prop, model, context, typeReference, acceptor);
        } else if (prop.isSetable()) {
            if (prop instanceof IFXEnumProperty) {
                this.createEnumPropnameProposals((IFXEnumProperty)prop, model, context, typeReference, acceptor);
            } else if (prop instanceof IFXEventHandlerProperty) {
                this.createEventHandlerPropnameProposals((IFXEventHandlerProperty)prop, model, context, typeReference, acceptor);
            } else if (prop instanceof IFXObjectProperty) {
                this.createObjectPropnameProposals((IFXObjectProperty)prop, model, context, typeReference, acceptor);
            } else if (prop instanceof IFXPrimitiveProperty) {
                this.createPrimitivePropnameProposals((IFXPrimitiveProperty)prop, model, context, typeReference, acceptor);
            }
        }
    }

    private void createCollectionPropnameProposals(IFXCollectionProperty prop, EObject model, ContentAssistContext context, EStructuralFeature typeReference, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal p;
        StyledString s;
        if (prop.isSetable()) {
            s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getCollectionAsString());
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            p = this.createCompletionProposal(String.valueOf(prop.getName()) + " : ", s, IconKeys.getIcon((String)IconKeys.LIST_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
        } else {
            s = new StyledString(String.valueOf(prop.getName()) + " : [" + (prop.getElementType() != null ? prop.getElementType().getElementName() : "?") + "]");
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            p = this.createCompletionProposal(String.valueOf(prop.getName()) + " : []", s, IconKeys.getIcon((String)IconKeys.LIST_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
        }
        if (p instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
            cp.setAdditionalProposalInfo((Object)model);
            cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            if (!prop.isSetable()) {
                cp.setCursorPosition(cp.getCursorPosition() - 1);
            }
        }
        acceptor.accept(p);
    }

    private void createMapPropnameProposals(IFXMapProperty prop, EObject model, ContentAssistContext context, EStructuralFeature typeReference, ICompletionProposalAcceptor acceptor) {
        StyledString s = new StyledString(String.valueOf(prop.getName()) + " : {}");
        s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
        ICompletionProposal p = this.createCompletionProposal(String.valueOf(prop.getName()) + " : ", s, IconKeys.getIcon((String)IconKeys.MAP_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
        if (p instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
            cp.setAdditionalProposalInfo((Object)model);
            cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
        }
        acceptor.accept(p);
    }

    private void createEnumPropnameProposals(IFXEnumProperty prop, EObject model, ContentAssistContext context, EStructuralFeature typeReference, ICompletionProposalAcceptor acceptor) {
        if (prop.isStatic() && typeReference.equals(FXGraphPackage.Literals.ELEMENT__STATIC_PROPERTIES)) {
            StyledString s = new StyledString();
            s.append("(static) ", StyledString.COUNTER_STYLER);
            s.append(String.valueOf(prop.getFXClass().getSimpleName()) + "." + prop.getName() + " : " + prop.getEnumTypeAsString(false));
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            context = context.copy().setMatcher((PrefixMatcher)new StaticPrefixMatcher(context.getMatcher())).toContext();
            ICompletionProposal p = this.createCompletionProposal("static " + prop.getName() + " : ", s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), this.getPropertiesProposalsProposals() - 10, context.getPrefix(), context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            }
            acceptor.accept(p);
        } else {
            StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getEnumTypeAsString(false));
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            ICompletionProposal p = this.createCompletionProposal(String.valueOf(prop.getName()) + " : ", s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            }
            acceptor.accept(p);
        }
    }

    private void createEventHandlerPropnameProposals(IFXEventHandlerProperty prop, EObject model, ContentAssistContext context, EStructuralFeature typeReference, ICompletionProposalAcceptor acceptor) {
        StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getEventTypeAsString(false));
        s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
        ICompletionProposal p = this.createCompletionProposal(String.valueOf(prop.getName()) + " : ", s, IconKeys.getIcon((String)IconKeys.EVENT_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
        if (p instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
            cp.setAdditionalProposalInfo((Object)model);
            cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
        }
        acceptor.accept(p);
    }

    private void createObjectPropnameProposals(IFXObjectProperty prop, EObject model, ContentAssistContext context, EStructuralFeature typeReference, ICompletionProposalAcceptor acceptor) {
        if (prop.isStatic() && typeReference.equals(FXGraphPackage.Literals.ELEMENT__STATIC_PROPERTIES)) {
            StyledString s = new StyledString();
            s.append("(static) ", StyledString.COUNTER_STYLER);
            s.append(String.valueOf(prop.getFXClass().getSimpleName()) + "." + prop.getName() + " : " + prop.getElementTypeAsString(false));
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            context = context.copy().setMatcher((PrefixMatcher)new StaticPrefixMatcher(context.getMatcher())).toContext();
            ICompletionProposal p = this.createCompletionProposal("static " + prop.getName() + " : ", s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), this.getPropertiesProposalsProposals() - 10, context.getPrefix(), context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            }
            acceptor.accept(p);
        } else {
            StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + prop.getElementTypeAsString(false));
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            ICompletionProposal p = this.createCompletionProposal(String.valueOf(prop.getName()) + " : ", s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            }
            acceptor.accept(p);
        }
    }

    private void createPrimitivePropnameProposals(IFXPrimitiveProperty prop, EObject model, ContentAssistContext context, EStructuralFeature typeReference, ICompletionProposalAcceptor acceptor) {
        String typeName;
        String proposalValue = String.valueOf(prop.getName()) + " : ";
        switch (prop.getType()) {
            case BOOLEAN: {
                typeName = "boolean";
                break;
            }
            case BYTE: {
                typeName = "byte";
                break;
            }
            case CHAR: {
                typeName = "char";
                break;
            }
            case DOUBLE: {
                typeName = "double";
                break;
            }
            case FLOAT: {
                typeName = "float";
                break;
            }
            case INTEGER: {
                typeName = "integer";
                break;
            }
            case LONG: {
                typeName = "long";
                break;
            }
            case SHORT: {
                typeName = "short";
                break;
            }
            default: {
                typeName = "String";
                proposalValue = String.valueOf(proposalValue) + "\"\"";
            }
        }
        if (prop.isStatic() && typeReference.equals(FXGraphPackage.Literals.ELEMENT__STATIC_PROPERTIES)) {
            StyledString s = new StyledString();
            s.append("(static) ", StyledString.COUNTER_STYLER);
            s.append(String.valueOf(prop.getFXClass().getSimpleName()) + "." + prop.getName() + " : " + typeName);
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            proposalValue = "static " + proposalValue;
            context = context.copy().setMatcher((PrefixMatcher)new StaticPrefixMatcher(context.getMatcher())).toContext();
            ICompletionProposal p = this.createCompletionProposal(proposalValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), this.getPropertiesProposalsProposals() - 10, context.getPrefix(), context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            }
            acceptor.accept(p);
        } else {
            StyledString s = new StyledString(String.valueOf(prop.getName()) + " : " + typeName);
            s.append(" - " + prop.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
            if (proposalValue.equals("id : \"\"")) {
                proposalValue = "^" + proposalValue;
            }
            context = context.copy().setMatcher((PrefixMatcher)new EscapePrefixMatcher(context.getMatcher())).toContext();
            ICompletionProposal p = this.createCompletionProposal(proposalValue, s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
                if (prop.getType() == IFXPrimitiveProperty.Type.STRING) {
                    cp.setCursorPosition(cp.getCursorPosition() - 1);
                }
            }
            acceptor.accept(p);
        }
    }

    @Override
    public void completeProperty_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Property prop;
        if (model instanceof Property) {
            prop = (Property)model;
        } else if (model instanceof Element) {
            prop = (Property)model.eContainer();
        } else {
            return;
        }
        if (prop.eContainer() instanceof Element) {
            Element el = (Element)prop.eContainer();
            try {
                IFXClass fxClazz;
                IFXProperty fxProp;
                IJavaProject javaProject = this.projectProvider.getJavaProject(el.eResource().getResourceSet());
                IType type = javaProject.findType(el.getType().getQualifiedName());
                if (type != null && (fxProp = (fxClazz = FXPlugin.getClassmodel().findClass(javaProject, type)).getProperty(prop.getName())) != null) {
                    this.completeProperty_ValueProposals(fxProp, model, context, FXGraphPackage.Literals.PROPERTY__VALUE, acceptor);
                }
            }
            catch (JavaModelException e) {
                LOGGER.error((Object)"Failed to retrieve property value proposals", (Throwable)e);
            }
        } else {
            boolean cfr_ignored_0 = prop.eContainer() instanceof MapValueProperty;
        }
    }

    private void completeProperty_ValueProposals(IFXProperty prop, EObject model, ContentAssistContext context, EReference typeReference, ICompletionProposalAcceptor acceptor) {
        if (prop instanceof IFXPrimitiveProperty) {
            this.createPrimitivePropvalueProposals((IFXPrimitiveProperty)prop, model, context, typeReference, acceptor);
        } else if (prop instanceof IFXEnumProperty) {
            this.createEnumPropvalueProposals((IFXEnumProperty)prop, model, context, typeReference, acceptor);
        } else if (!(prop instanceof IFXCollectionProperty) && !(prop instanceof IFXEventHandlerProperty) && !(prop instanceof IFXMapProperty) && prop instanceof IFXObjectProperty) {
            this.createObjectPropvalueProposals((IFXObjectProperty)prop, model, context, typeReference, acceptor);
        }
    }

    private void createPrimitivePropvalueProposals(IFXPrimitiveProperty prop, EObject model, ContentAssistContext context, EReference typeReference, ICompletionProposalAcceptor acceptor) {
        switch (prop.getType()) {
            case BOOLEAN: {
                ConfigurableCompletionProposal cp;
                ICompletionProposal p = this.createCompletionProposal("true", context);
                if (p instanceof ConfigurableCompletionProposal) {
                    cp = (ConfigurableCompletionProposal)p;
                    cp.setAdditionalProposalInfo((Object)model);
                    cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
                }
                acceptor.accept(p);
                p = this.createCompletionProposal("false", context);
                if (p instanceof ConfigurableCompletionProposal) {
                    cp = (ConfigurableCompletionProposal)p;
                    cp.setAdditionalProposalInfo((Object)model);
                    cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
                }
                acceptor.accept(p);
                break;
            }
            case LONG: 
            case INTEGER: 
            case CHAR: 
            case SHORT: 
            case BYTE: {
                ICompletionProposal p = this.createCompletionProposal("1", context);
                if (p instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                    cp.setAdditionalProposalInfo((Object)model);
                    cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
                }
                acceptor.accept(p);
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                ICompletionProposal p = this.createCompletionProposal("1.0", context);
                if (p instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                    cp.setAdditionalProposalInfo((Object)model);
                    cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
                }
                acceptor.accept(p);
                break;
            }
            case STRING: {
                ICompletionProposal p = this.createCompletionProposal("\"<String>\"", context);
                if (p instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                    cp.setAdditionalProposalInfo((Object)model);
                    cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
                }
                acceptor.accept(p);
                break;
            }
        }
    }

    private void createEnumPropvalueProposals(IFXEnumProperty prop, EObject model, ContentAssistContext context, EReference typeReference, ICompletionProposalAcceptor acceptor) {
        IType t = prop.getEnumType();
        if (t != null) {
            try {
                IField[] iFieldArray = t.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField f = iFieldArray[n2];
                    if (Flags.isEnum((int)f.getFlags())) {
                        ICompletionProposal p = this.createCompletionProposal("\"" + f.getElementName() + "\"", new StyledString(f.getElementName()).append(" - " + prop.getEnumTypeAsString(false), StyledString.QUALIFIER_STYLER), IconKeys.getIcon((String)IconKeys.ENUM_KEY), this.getPriorityHelper().getDefaultPriority(), "\"" + context.getPrefix(), context);
                        if (p instanceof ConfigurableCompletionProposal) {
                            ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                            cp.setAdditionalProposalInfo((Object)model);
                            cp.setHover((IEObjectHover)new HoverImpl((IJavaElement)f));
                        }
                        acceptor.accept(p);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isIntegerType(String fqnType) {
        if ("java.lang.Integer".equals(fqnType)) {
            return true;
        }
        if ("java.lang.Long".equals(fqnType)) {
            return true;
        }
        if ("java.lang.Short".equals(fqnType)) {
            return true;
        }
        return "java.lang.Byte".equals(fqnType);
    }

    private static boolean isDoubleType(String fqnType) {
        if ("java.lang.Float".equals(fqnType)) {
            return true;
        }
        return "java.lang.Double".equals(fqnType);
    }

    private void createObjectPropvalueProposals(IFXObjectProperty prop, EObject model, ContentAssistContext context, EReference typeReference, ICompletionProposalAcceptor acceptor) {
        String type = prop.getElementTypeAsString(true);
        if ("java.lang.Boolean".equals(type)) {
            ConfigurableCompletionProposal cp;
            ICompletionProposal p = this.createCompletionProposal("true", context);
            if (p instanceof ConfigurableCompletionProposal) {
                cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl((IJavaElement)prop.getValueOfMethod()));
            }
            acceptor.accept(p);
            p = this.createCompletionProposal("false", context);
            if (p instanceof ConfigurableCompletionProposal) {
                cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl((IJavaElement)prop.getValueOfMethod()));
            }
            acceptor.accept(p);
        } else if (FXGraphProposalProvider.isIntegerType(type)) {
            ICompletionProposal p = this.createCompletionProposal("1", context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            }
            acceptor.accept(p);
        } else if (FXGraphProposalProvider.isDoubleType(type)) {
            ICompletionProposal p = this.createCompletionProposal("1.0", context);
            if (p instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                cp.setAdditionalProposalInfo((Object)model);
                cp.setHover((IEObjectHover)new HoverImpl(prop.getJavaElement()));
            }
            acceptor.accept(p);
        } else {
            IType jdtSuperType;
            if (prop.hasValueOf()) {
                ICompletionProposal p = this.createCompletionProposal("\"\"", new StyledString("\"<String>\""), null, this.getPriorityHelper().getDefaultPriority() + 1, context.getPrefix(), context);
                if (p instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                    cp.setAdditionalProposalInfo((Object)model);
                    cp.setHover((IEObjectHover)new HoverImpl((IJavaElement)prop.getValueOfMethod()));
                }
                acceptor.accept(p);
                for (IValueOfContributor contrib : this.valueOfCollector.getContributors(prop.getElementTypeAsString(true))) {
                    for (IValueOfContributor.Proposal vProp : contrib.getProposals()) {
                        int prio = this.getPriorityHelper().getDefaultPriority() + vProp.getPriority() + 2;
                        p = this.createCompletionProposal("\"" + vProp.getValue() + "\"", new StyledString(vProp.getValue()), IconKeys.getIcon((String)IconKeys.VALUE_OF_KEY), prio, "\"" + context.getPrefix(), context);
                        if (p instanceof ConfigurableCompletionProposal && vProp instanceof IValueOfContributor.DialogProposal) {
                            ConfigurableCompletionProposal cp = (ConfigurableCompletionProposal)p;
                            final IValueOfContributor.DialogProposal dProp = (IValueOfContributor.DialogProposal)vProp;
                            cp.setTextApplier((ConfigurableCompletionProposal.IReplacementTextApplier)new ReplacementTextApplier(){

                                public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
                                    return "\"" + dProp.openDialogValue() + "\"";
                                }
                            });
                        }
                        acceptor.accept(p);
                    }
                }
            }
            if ((jdtSuperType = prop.getElementType()) != null) {
                IJvmTypeProvider tProvider = this.jdtTypeProvider.findOrCreateTypeProvider(model.eResource().getResourceSet());
                JvmType superType = tProvider.findTypeByName(jdtSuperType.getFullyQualifiedName());
                FXClassFilter f = new FXClassFilter(this.projectProvider.getJavaProject(model.eResource().getResourceSet()));
                this.typeProposalProviders.createSubTypeProposals(superType, (ICompletionProposalFactory)this, context, typeReference, (ITypesProposalProvider.Filter)f, acceptor);
            }
        }
    }

    public void completeJvmParameterizedTypeReference_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeResourceValueProperty_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Model m;
        if (!model.eResource().getContents().isEmpty() && (m = (Model)model.eResource().getContents().get(0)).getComponentDef() != null && m.getComponentDef().getPreviewResourceBundle() != null) {
            Properties p;
            block21: {
                File f = RelativeFileLocator.locateFile((URI)model.eResource().getURI(), (String)m.getComponentDef().getPreviewResourceBundle());
                p = null;
                if (f != null) {
                    FileInputStream fi = null;
                    try {
                        fi = new FileInputStream(f);
                        p = new Properties();
                        p.load(fi);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.warn((Object)"Unable to load resource bundle", (Throwable)e);
                        if (fi != null) {
                            try {
                                fi.close();
                            }
                            catch (IOException e2) {
                                LOGGER.error((Object)"Unable to close resource filehandle", (Throwable)e2);
                            }
                        }
                        break block21;
                    }
                    catch (IOException e) {
                        try {
                            LOGGER.warn((Object)"Unable to load resource bundle", (Throwable)e);
                            break block21;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (fi != null) {
                                try {
                                    fi.close();
                                }
                                catch (IOException e3) {
                                    LOGGER.error((Object)"Unable to close resource filehandle", (Throwable)e3);
                                }
                            }
                        }
                    }
                    if (fi == null) break block21;
                    try {
                        fi.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Unable to close resource filehandle", (Throwable)e);
                    }
                }
            }
            if (p != null) {
                for (String k : p.stringPropertyNames()) {
                    StyledString s = new StyledString(k);
                    s.append(" - " + p.getProperty(k), StyledString.DECORATIONS_STYLER);
                    acceptor.accept(this.createCompletionProposal("\"" + k + "\"", s, IconKeys.getIcon((String)IconKeys.EXTERNALIZED_STRING_KEY), context));
                }
            }
        }
    }

    @Override
    public void completeBindValueProperty_ElementReference(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TreeIterator it = model.eResource().getAllContents();
        while (it.hasNext()) {
            Element e;
            EObject o = (EObject)it.next();
            if (!(o instanceof Element) || (e = (Element)o).getName() == null || e.getName().trim().length() <= 0) continue;
            StyledString s = new StyledString(e.getName());
            s.append(" - " + e.getType().getQualifiedName(), StyledString.DECORATIONS_STYLER);
            acceptor.accept(this.createCompletionProposal(e.getName(), s, IconKeys.getIcon((String)IconKeys.CLASS_KEY), context));
        }
    }

    @Override
    public void completeBindValueProperty_Attribute(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        BindValueProperty b = (BindValueProperty)model;
        if (b.getElementReference() != null && b.getElementReference().getType() != null) {
            Property property = (Property)b.eContainer();
            Element targetClass = (Element)property.eContainer();
            Element element = b.getElementReference();
            try {
                IJavaProject javaProject = this.projectProvider.getJavaProject(element.eResource().getResourceSet());
                IType sourceType = javaProject.findType(element.getType().getQualifiedName());
                IType targetType = javaProject.findType(targetClass.getType().getQualifiedName());
                IFXClass fxSourceClazz = FXPlugin.getClassmodel().findClass(javaProject, sourceType);
                IFXClass fxTargetClass = FXPlugin.getClassmodel().findClass(javaProject, targetType);
                IFXProperty targetProperty = fxTargetClass.getProperty(property.getName());
                if (targetProperty instanceof IFXPrimitiveProperty) {
                    IFXPrimitiveProperty pp = (IFXPrimitiveProperty)targetProperty;
                    for (IFXProperty sourceProp : fxSourceClazz.getAllProperties().values()) {
                        if (sourceProp instanceof IFXEventHandlerProperty) continue;
                        boolean select = false;
                        if (pp.getType() == IFXPrimitiveProperty.Type.STRING) {
                            select = true;
                        } else if (sourceProp instanceof IFXPrimitiveProperty) {
                            IFXPrimitiveProperty sp = (IFXPrimitiveProperty)sourceProp;
                            if (pp.getType() == IFXPrimitiveProperty.Type.BOOLEAN) {
                                select = sp.getType() == IFXPrimitiveProperty.Type.BOOLEAN;
                            } else if (sp.getType() != IFXPrimitiveProperty.Type.STRING && sp.getType() != IFXPrimitiveProperty.Type.BOOLEAN) {
                                select = true;
                            }
                        }
                        if (!select) continue;
                        String typeName = "";
                        if (sourceProp instanceof IFXPrimitiveProperty) {
                            IFXPrimitiveProperty sp = (IFXPrimitiveProperty)sourceProp;
                            typeName = sp.getType() == IFXPrimitiveProperty.Type.STRING ? "String" : sp.getType().jvmType();
                        } else if (sourceProp instanceof IFXCollectionProperty) {
                            typeName = ((IFXCollectionProperty)sourceProp).getCollectionAsString();
                        } else if (sourceProp instanceof IFXEnumProperty) {
                            typeName = ((IFXEnumProperty)sourceProp).getEnumTypeAsString(false);
                        } else if (sourceProp instanceof IFXMapProperty) {
                            typeName = "{}";
                        } else if (sourceProp instanceof IFXObjectProperty) {
                            typeName = ((IFXObjectProperty)sourceProp).getElementTypeAsString(false);
                        }
                        StyledString s = new StyledString(String.valueOf(sourceProp.getName()) + " : " + typeName);
                        s.append(" - " + sourceProp.getFXClass().getSimpleName(), StyledString.QUALIFIER_STYLER);
                        ICompletionProposal cp = this.createCompletionProposal(sourceProp.getName(), s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), this.getPropertiesProposalsProposals(), context.getPrefix(), context);
                        acceptor.accept(cp);
                    }
                }
            }
            catch (JavaModelException e1) {
                LOGGER.error((Object)"Unable to extract java informations", (Throwable)e1);
            }
        }
    }

    @Override
    public void completeElement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeListValueProperty_Value(EObject m, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Property property;
        ListValueProperty listProp = null;
        if (m instanceof ListValueProperty) {
            listProp = (ListValueProperty)m;
        } else if (m instanceof Element && m.eContainer() instanceof ListValueProperty) {
            listProp = (ListValueProperty)m.eContainer();
        }
        if (listProp != null && listProp.eContainer() instanceof Property && (property = (Property)listProp.eContainer()).eContainer() instanceof Element) {
            try {
                Element element = (Element)property.eContainer();
                IJavaProject javaProject = this.projectProvider.getJavaProject(element.eResource().getResourceSet());
                IType ownerType = javaProject.findType(element.getType().getQualifiedName());
                IFXClass fxOwnerClazz = FXPlugin.getClassmodel().findClass(javaProject, ownerType);
                IFXProperty ownerProperty = fxOwnerClazz.getProperty(property.getName());
                if (ownerProperty instanceof IFXCollectionProperty) {
                    IFXCollectionProperty cp = (IFXCollectionProperty)ownerProperty;
                    String type = cp.getElementType().getElementName();
                    if ("String".equals(type)) {
                        ICompletionProposal p = this.createCompletionProposal("\"\"", new StyledString("\"<String>\""), IconKeys.getIcon((String)IconKeys.CLASS_KEY), context);
                        if (p instanceof ConfigurableCompletionProposal) {
                            ConfigurableCompletionProposal ccp = (ConfigurableCompletionProposal)p;
                            ccp.setAdditionalProposalInfo((Object)listProp);
                            ccp.setHover((IEObjectHover)new HoverImpl(ownerProperty.getJavaElement()));
                            ccp.setCursorPosition(ccp.getCursorPosition() - 1);
                        }
                        acceptor.accept(p);
                    } else if ("Double".equals(type)) {
                        ICompletionProposal p = this.createCompletionProposal("1.0", context);
                        if (p instanceof ConfigurableCompletionProposal) {
                            ConfigurableCompletionProposal ccp = (ConfigurableCompletionProposal)p;
                            ccp.setAdditionalProposalInfo((Object)listProp);
                            ccp.setHover((IEObjectHover)new HoverImpl(ownerProperty.getJavaElement()));
                        }
                        acceptor.accept(p);
                    } else if ("Integer".equals(type)) {
                        ICompletionProposal p = this.createCompletionProposal("1", context);
                        if (p instanceof ConfigurableCompletionProposal) {
                            ConfigurableCompletionProposal ccp = (ConfigurableCompletionProposal)p;
                            ccp.setAdditionalProposalInfo((Object)listProp);
                            ccp.setHover((IEObjectHover)new HoverImpl(ownerProperty.getJavaElement()));
                        }
                        acceptor.accept(p);
                    } else if ("Boolean".equals(type)) {
                        ConfigurableCompletionProposal ccp;
                        ICompletionProposal p = this.createCompletionProposal("true", context);
                        if (p instanceof ConfigurableCompletionProposal) {
                            ccp = (ConfigurableCompletionProposal)p;
                            ccp.setAdditionalProposalInfo((Object)listProp);
                            ccp.setHover((IEObjectHover)new HoverImpl(ownerProperty.getJavaElement()));
                        }
                        acceptor.accept(p);
                        p = this.createCompletionProposal("false", context);
                        if (p instanceof ConfigurableCompletionProposal) {
                            ccp = (ConfigurableCompletionProposal)p;
                            ccp.setAdditionalProposalInfo((Object)listProp);
                            ccp.setHover((IEObjectHover)new HoverImpl(ownerProperty.getJavaElement()));
                        }
                        acceptor.accept(p);
                    } else {
                        this.createCollectionClassProposals(cp, (EObject)listProp, context, FXGraphPackage.Literals.LIST_VALUE_PROPERTY__VALUE, acceptor);
                    }
                }
            }
            catch (JavaModelException e) {
                LOGGER.error((Object)"Unable to autocomplete list value", (Throwable)e);
            }
        }
    }

    @Override
    public void completeControllerHandledValueProperty_Methodname(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Property property;
        Model m;
        if (!model.eResource().getContents().isEmpty() && (m = (Model)model.eResource().getContents().get(0)).getComponentDef() != null && m.getComponentDef().getController() != null && model.eContainer() instanceof Property && (property = (Property)model.eContainer()).eContainer() instanceof Element) {
            try {
                Element element = (Element)property.eContainer();
                IJavaProject javaProject = this.projectProvider.getJavaProject(element.eResource().getResourceSet());
                IType ownerType = javaProject.findType(element.getType().getQualifiedName());
                IFXClass fxOwnerClazz = FXPlugin.getClassmodel().findClass(javaProject, ownerType);
                IFXProperty ownerProperty = fxOwnerClazz.getProperty(property.getName());
                if (ownerProperty instanceof IFXEventHandlerProperty) {
                    IFXEventHandlerProperty p = (IFXEventHandlerProperty)ownerProperty;
                    IType ctrlType = javaProject.findType(m.getComponentDef().getController().getQualifiedName());
                    IFXCtrlClass ctrlClass = FXPlugin.getClassmodel().findCtrlClass(javaProject, ctrlType);
                    for (IFXCtrlEventMethod ctrlMethod : ctrlClass.getAllEventMethods().values()) {
                        StyledString s = null;
                        if (!ctrlMethod.hasArgument()) {
                            s = new StyledString(String.valueOf(ctrlMethod.getName()) + "()");
                        } else if (Util.assignable((IType)p.getEventType(), (IType)ctrlMethod.getArgumentType())) {
                            s = new StyledString(String.valueOf(ctrlMethod.getName()) + "(" + p.getEventTypeAsString(false) + ")");
                        }
                        if (s == null) continue;
                        s.append(" - " + ctrlClass.getSimpleName(), StyledString.QUALIFIER_STYLER);
                        Image img = null;
                        switch (ctrlMethod.getVisibility()) {
                            case PUBLIC: {
                                img = IconKeys.getIcon((String)IconKeys.METHOD_PUBLIC_KEY);
                                break;
                            }
                            case PACKAGE: {
                                img = IconKeys.getIcon((String)IconKeys.METHOD_DEFAULT_KEY);
                                break;
                            }
                            case PROTECTED: {
                                img = IconKeys.getIcon((String)IconKeys.METHOD_PROTECTED_KEY);
                                break;
                            }
                            default: {
                                img = IconKeys.getIcon((String)IconKeys.METHOD_PRIVATE_KEY);
                            }
                        }
                        ICompletionProposal cp = this.createCompletionProposal(ctrlMethod.getName(), s, img, context);
                        acceptor.accept(cp);
                    }
                }
            }
            catch (JavaModelException e) {
                LOGGER.error((Object)"Unable to autocomplete list value", (Throwable)e);
            }
        }
    }

    @Override
    public void completeDefine_Element(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.typeProposalProviders.createTypeProposals((ICompletionProposalFactory)this, context, FXGraphPackage.Literals.DEFINE__ELEMENT, acceptor);
    }

    @Override
    public void completeReferenceValueProperty_Reference(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Model m;
        if (!model.eResource().getContents().isEmpty() && (m = (Model)model.eResource().getContents().get(0)).getComponentDef() != null) {
            for (Define d : m.getComponentDef().getDefines()) {
                Element element = d.getElement();
                boolean includeType = false;
                if (element == null) {
                    element = d.getIncludeElement().getSource().getRootNode();
                    includeType = true;
                }
                IJavaProject javaProject = this.projectProvider.getJavaProject(element.eResource().getResourceSet());
                try {
                    IType defType = javaProject.findType(element.getType().getQualifiedName());
                    ReferenceValueProperty rp = (ReferenceValueProperty)model;
                    IType targetType = null;
                    if (rp.eContainer() instanceof Property) {
                        Property p = (Property)rp.eContainer();
                        if (p.eContainer() instanceof Element) {
                            Element e = (Element)p.eContainer();
                            IType ownerType = javaProject.findType(e.getType().getQualifiedName());
                            IFXClass ownerClass = FXPlugin.getClassmodel().findClass(javaProject, ownerType);
                            IFXProperty ownerProp = ownerClass.getProperty(p.getName());
                            if (ownerProp instanceof IFXObjectProperty) {
                                targetType = ((IFXObjectProperty)ownerProp).getElementType();
                            }
                        }
                    } else if (rp.eContainer() instanceof StaticCallValueProperty) {
                        LOGGER.warn((Object)("Unable to extract type for " + rp.eContainer()));
                    } else if (rp.eContainer() instanceof ListValueProperty) {
                        ListValueProperty lvp = (ListValueProperty)rp.eContainer();
                        if (lvp.eContainer() instanceof Property) {
                            Property p = (Property)lvp.eContainer();
                            if (p.eContainer() instanceof Element) {
                                Element e = (Element)p.eContainer();
                                IType ownerType = javaProject.findType(e.getType().getQualifiedName());
                                IFXClass ownerClass = FXPlugin.getClassmodel().findClass(javaProject, ownerType);
                                IFXProperty ownerProp = ownerClass.getProperty(p.getName());
                                if (ownerProp instanceof IFXCollectionProperty) {
                                    targetType = ((IFXCollectionProperty)ownerProp).getElementType();
                                }
                            }
                        } else {
                            LOGGER.warn((Object)("Unable to extract type for " + rp.eContainer()));
                        }
                    }
                    if (targetType == null || !Util.assignable((IType)defType, targetType)) continue;
                    StyledString s = new StyledString(includeType ? d.getIncludeElement().getName() : element.getName());
                    s.append(" - " + defType.getElementName(), StyledString.QUALIFIER_STYLER);
                    acceptor.accept(this.createCompletionProposal(includeType ? d.getIncludeElement().getName() : element.getName(), s, IconKeys.getIcon((String)IconKeys.CLASS_KEY), context));
                }
                catch (JavaModelException e) {
                    LOGGER.error((Object)"Unable to extract define type", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void completeLocationValueProperty_Value(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot r = iPackageFragmentRootArray[n2];
                if (r.getCorrespondingResource() != null) {
                    final int count = r.getCorrespondingResource().getProjectRelativePath().segmentCount();
                    r.getCorrespondingResource().accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            String extension;
                            if (resource.getType() == 2 || resource.getType() == 4) {
                                return true;
                            }
                            if (resource.getType() == 1 && !resource.isLinked() && ((extension = resource.getProjectRelativePath().getFileExtension()).equals("png") || extension.equals("jpg") || extension.equals("gif"))) {
                                IPath p = resource.getProjectRelativePath().removeFirstSegments(count);
                                String prefix = "\"/" + (p.segmentCount() > 1 ? p.removeLastSegments(1).toString() : p.toString()) + "/" + context.getPrefix();
                                ICompletionProposal proposal = FXGraphProposalProvider.this.createCompletionProposal("\"/" + p.toString() + "\"", new StyledString("/" + p.toString()), null, FXGraphProposalProvider.this.getPriorityHelper().getDefaultPriority(), prefix, context);
                                acceptor.accept(proposal);
                            }
                            return false;
                        }
                    });
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeStaticCallValueProperty_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        JvmType superType = this.jdtTypeProvider.findOrCreateTypeProvider(model.eResource().getResourceSet()).findTypeByName("javafx.scene.Parent");
        FXClassFilter f = new FXClassFilter(this.projectProvider.getJavaProject(model.eResource().getResourceSet()));
        this.typeProposalProviders.createSubTypeProposals(superType, (ICompletionProposalFactory)this, context, FXGraphPackage.Literals.STATIC_CALL_VALUE_PROPERTY__TYPE, (ITypesProposalProvider.Filter)f, acceptor);
    }

    @Override
    public void completeStaticCallValueProperty_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StaticCallValueProperty staticProperty = (StaticCallValueProperty)model;
        try {
            IFXClass fxClazz;
            IJavaProject javaProject = this.projectProvider.getJavaProject(staticProperty.eResource().getResourceSet());
            IType type = javaProject.findType(staticProperty.getType().getQualifiedName());
            if (type != null && (fxClazz = FXPlugin.getClassmodel().findClass(javaProject, type)) != null) {
                Map map = fxClazz.getAllStaticProperties();
                for (IFXProperty p : map.values()) {
                    this.completeElement_PropertiesProposals(p, model, context, (EStructuralFeature)FXGraphPackage.Literals.STATIC_CALL_VALUE_PROPERTY__NAME, acceptor, null, null);
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeStaticCallValueProperty_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StaticCallValueProperty staticProperty = null;
        staticProperty = model instanceof Element ? (StaticCallValueProperty)model.eContainer() : (StaticCallValueProperty)model;
        try {
            IFXProperty fxProp;
            IFXClass fxClazz;
            IJavaProject javaProject = this.projectProvider.getJavaProject(staticProperty.eResource().getResourceSet());
            IType type = javaProject.findType(staticProperty.getType().getQualifiedName());
            if (type != null && (fxClazz = FXPlugin.getClassmodel().findClass(javaProject, type)) != null && (fxProp = fxClazz.getStaticProperty(staticProperty.getName())) != null) {
                this.completeProperty_ValueProposals(fxProp, model, context, FXGraphPackage.Literals.STATIC_CALL_VALUE_PROPERTY__VALUE, acceptor);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeStaticValueProperty_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject eo = model instanceof StaticValueProperty ? model.eContainer() : model;
        Element target = null;
        Element propertyTarget = (Element)(eo instanceof Element ? eo : null);
        while (eo.eContainer() != null) {
            if (eo.eContainer() instanceof Element) {
                target = (Element)eo.eContainer();
                break;
            }
            eo = eo.eContainer();
        }
        if (target == null) {
            return;
        }
        try {
            IFXClass fxClazz;
            IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
            IType type = javaProject.findType(target.getType().getQualifiedName());
            if (type != null && (fxClazz = FXPlugin.getClassmodel().findClass(javaProject, type)) != null) {
                Map map = fxClazz.getAllStaticProperties();
                for (IFXProperty p : map.values()) {
                    this.completeElement_PropertiesProposals(p, model, context, (EStructuralFeature)FXGraphPackage.Literals.STATIC_VALUE_PROPERTY__NAME, acceptor, propertyTarget, (EStructuralFeature)FXGraphPackage.Literals.ELEMENT__STATIC_PROPERTIES);
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeStaticValueProperty_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StaticValueProperty staticProperty = null;
        staticProperty = model instanceof Element ? (StaticValueProperty)model.eContainer() : (StaticValueProperty)model;
        EObject eo = staticProperty.eContainer();
        Element target = null;
        while (eo.eContainer() != null) {
            if (eo.eContainer() instanceof Element) {
                target = (Element)eo.eContainer();
                break;
            }
            eo = eo.eContainer();
        }
        if (target == null) {
            return;
        }
        try {
            IFXProperty fxProp;
            IFXClass fxClazz;
            IJavaProject javaProject = this.projectProvider.getJavaProject(staticProperty.eResource().getResourceSet());
            IType type = javaProject.findType(target.getType().getQualifiedName());
            if (type != null && (fxClazz = FXPlugin.getClassmodel().findClass(javaProject, type)) != null && (fxProp = fxClazz.getStaticProperty(staticProperty.getName())) != null) {
                this.completeProperty_ValueProposals(fxProp, model, context, FXGraphPackage.Literals.STATIC_VALUE_PROPERTY__VALUE, acceptor);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeComponentDefinition_RootNode(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        JvmType superType = this.jdtTypeProvider.findOrCreateTypeProvider(model.eResource().getResourceSet()).findTypeByName("javafx.scene.Parent");
        this.typeProposalProviders.createSubTypeProposals(superType, (ICompletionProposalFactory)this, context, FXGraphPackage.Literals.COMPONENT_DEFINITION__ROOT_NODE, acceptor);
    }

    @Override
    public void completeComponentDefinition_Controller(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.typeProposalProviders.createTypeProposals((ICompletionProposalFactory)this, context, FXGraphPackage.Literals.COMPONENT_DEFINITION__CONTROLLER, acceptor);
    }

    @Override
    public void completeConstValueProperty_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.typeProposalProviders.createTypeProposals((ICompletionProposalFactory)this, context, FXGraphPackage.Literals.CONST_VALUE_PROPERTY__TYPE, acceptor);
    }

    @Override
    public void completeConstValueProperty_Field(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof ConstValueProperty) {
            ConstValueProperty constProp = (ConstValueProperty)model;
            IJavaProject javaProject = this.projectProvider.getJavaProject(constProp.eResource().getResourceSet());
            try {
                IType type = javaProject.findType(constProp.getType().getQualifiedName());
                ArrayList<IField> fields = new ArrayList<IField>();
                this.collectStaticFields(fields, type);
                for (IField f : fields) {
                    StyledString s = new StyledString(String.valueOf(f.getElementName()) + " : " + Signature.getSimpleName((String)Signature.toString((String)f.getTypeSignature())));
                    String owner = ((IType)f.getAncestor(7)).getElementName();
                    s.append(" - " + Signature.getSimpleName((String)owner), StyledString.QUALIFIER_STYLER);
                    ICompletionProposal prop = this.createCompletionProposal(f.getElementName(), s, IconKeys.getIcon((String)IconKeys.FIELD_KEY), context);
                    acceptor.accept(prop);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private void collectStaticFields(List<IField> fields, IType type) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField f = iFieldArray[n2];
            if (Flags.isStatic((int)f.getFlags())) {
                fields.add(f);
            }
            ++n2;
        }
        String s = type.getSuperclassName();
        if (s != null) {
            String fqn = org.eclipse.fx.ide.model.internal.utils.Util.getFQNType((IType)type, (String)Signature.getTypeErasure((String)s));
            this.collectStaticFields(fields, type.getJavaProject().findType(fqn));
        }
    }

    static class EscapePrefixMatcher
    extends PrefixMatcher {
        private final PrefixMatcher original;

        public EscapePrefixMatcher(PrefixMatcher original) {
            this.original = original;
        }

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            if (name.startsWith("^")) {
                name = name.substring(1);
            }
            return this.original.isCandidateMatchingPrefix(name, prefix);
        }
    }

    class FXClassFilter
    implements ITypesProposalProvider.Filter {
        private final IJavaProject jp;

        public FXClassFilter(IJavaProject jp) {
            this.jp = jp;
        }

        public int getSearchFor() {
            return 0;
        }

        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            if (TypeMatchFilters.isInternalClass((char[])simpleTypeName, (char[][])enclosingTypeNames) || enclosingTypeNames.length > 0) {
                return false;
            }
            String sPackname = new String(packageName);
            if (sPackname.startsWith("com.sun")) {
                return false;
            }
            try {
                IType t = this.jp.findType(String.valueOf(new String(packageName)) + "." + new String(simpleTypeName));
                if (Flags.isAbstract((int)t.getFlags())) {
                    return false;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    public static class HoverImpl
    implements IEObjectHover,
    ITextHoverExtension {
        private JdtHoverProvider.JavadocHoverWrapper javadocHover = new JdtHoverProvider.JavadocHoverWrapper();
        private IJavaElement javaElement;

        public HoverImpl(IJavaElement javaElement) {
            this.javaElement = javaElement;
        }

        public Object getHoverInfo(EObject eObject, ITextViewer textViewer, IRegion hoverRegion) {
            this.javadocHover.setJavaElement(this.javaElement);
            return this.javadocHover.getHoverInfo2(textViewer, hoverRegion);
        }

        public IInformationControlCreator getHoverControlCreator() {
            return this.javadocHover.getHoverControlCreator();
        }
    }

    static class StaticPrefixMatcher
    extends PrefixMatcher {
        private final PrefixMatcher original;

        public StaticPrefixMatcher(PrefixMatcher original) {
            this.original = original;
        }

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            name = name.substring(name.indexOf("static") + "static".length() + 1);
            name = name.trim();
            return this.original.isCandidateMatchingPrefix(name, prefix);
        }
    }
}

