/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AsyncChannelGroupUtil;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.AsyncChannelWrapperNonSecure;
import org.apache.tomcat.websocket.AsyncChannelWrapperSecure;
import org.apache.tomcat.websocket.BackgroundProcess;
import org.apache.tomcat.websocket.BackgroundProcessManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.WsFrameClient;
import org.apache.tomcat.websocket.WsHandshakeResponse;
import org.apache.tomcat.websocket.WsRemoteEndpointImplClient;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoEndpointClient;

public class WsWebSocketContainer
implements WebSocketContainer,
BackgroundProcess {
    public static final String SSL_PROTOCOLS_PROPERTY = "org.apache.tomcat.websocket.SSL_PROTOCOLS";
    public static final String SSL_TRUSTSTORE_PROPERTY = "org.apache.tomcat.websocket.SSL_TRUSTSTORE";
    public static final String SSL_TRUSTSTORE_PWD_PROPERTY = "org.apache.tomcat.websocket.SSL_TRUSTSTORE_PWD";
    public static final String SSL_TRUSTSTORE_PWD_DEFAULT = "changeit";
    public static final String SSL_CONTEXT_PROPERTY = "org.apache.tomcat.websocket.SSL_CONTEXT";
    public static final String IO_TIMEOUT_MS_PROPERTY = "org.apache.tomcat.websocket.IO_TIMEOUT_MS";
    public static final long IO_TIMEOUT_MS_DEFAULT = 5000L;
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final Random random = new Random();
    private static final byte[] crlf = new byte[]{13, 10};
    private volatile AsynchronousChannelGroup asynchronousChannelGroup = null;
    private final Object asynchronousChannelGroupLock = new Object();
    private final Log log = LogFactory.getLog(WsWebSocketContainer.class);
    private final Map<Class<?>, Set<WsSession>> endpointSessionMap = new HashMap();
    private final Map<WsSession, WsSession> sessions = new ConcurrentHashMap<WsSession, WsSession>();
    private final Object endPointSessionMapLock = new Object();
    private long defaultAsyncTimeout = -1L;
    private int maxBinaryMessageBufferSize = 8192;
    private int maxTextMessageBufferSize = 8192;
    private volatile long defaultMaxSessionIdleTimeout = 0L;
    private int backgroundProcessCount = 0;
    private int processPeriod = 10;

    public Session connectToServer(Object pojo, URI path) throws DeploymentException {
        ClientEndpoint annotation = pojo.getClass().getAnnotation(ClientEndpoint.class);
        if (annotation == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.missingAnnotation", new Object[]{pojo.getClass().getName()}));
        }
        PojoEndpointClient ep = new PojoEndpointClient(pojo, annotation.decoders());
        Class configuratorClazz = pojo.getClass().getAnnotation(ClientEndpoint.class).configurator();
        ClientEndpointConfig.Configurator configurator = null;
        if (!ClientEndpointConfig.Configurator.class.equals((Object)configuratorClazz)) {
            try {
                configurator = (ClientEndpointConfig.Configurator)configuratorClazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.defaultConfiguratorFail"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.defaultConfiguratorFail"), (Throwable)e);
            }
        }
        ClientEndpointConfig.Builder builder = ClientEndpointConfig.Builder.create();
        if (configurator != null) {
            builder.configurator(configurator);
        }
        ClientEndpointConfig config = builder.decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).build();
        return this.connectToServer(ep, config, path);
    }

    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException {
        Object pojo;
        try {
            pojo = annotatedEndpointClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{annotatedEndpointClass.getName()}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{annotatedEndpointClass.getName()}), (Throwable)e);
        }
        return this.connectToServer(pojo, path);
    }

    public Session connectToServer(Class<? extends Endpoint> clazz, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException {
        Endpoint endpoint;
        try {
            endpoint = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{clazz.getName()}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{clazz.getName()}), (Throwable)e);
        }
        return this.connectToServer(endpoint, clientEndpointConfiguration, path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException {
        String subProtocol;
        ByteBuffer response;
        AsyncChannelWrapper channel;
        AsynchronousSocketChannel socketChannel;
        InetSocketAddress sa;
        boolean secure = false;
        String scheme = path.getScheme();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.pathWrongScheme", new Object[]{scheme}));
        }
        String host = path.getHost();
        if (host == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.pathNoHost"));
        }
        int port = path.getPort();
        Map<String, List<String>> reqHeaders = this.createRequestHeaders(host, port, clientEndpointConfiguration.getPreferredSubprotocols(), clientEndpointConfiguration.getExtensions());
        clientEndpointConfiguration.getConfigurator().beforeRequest(reqHeaders);
        ByteBuffer request = this.createRequest(path, reqHeaders);
        if (port == -1) {
            if ("ws".equalsIgnoreCase(scheme)) {
                sa = new InetSocketAddress(host, 80);
            } else {
                if (!"wss".equalsIgnoreCase(scheme)) throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidScheme"));
                sa = new InetSocketAddress(host, 443);
                secure = true;
            }
        } else {
            if ("wss".equalsIgnoreCase(scheme)) {
                secure = true;
            }
            sa = new InetSocketAddress(host, port);
        }
        try {
            socketChannel = AsynchronousSocketChannel.open(this.getAsynchronousChannelGroup());
        }
        catch (IOException ioe) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.asynchronousSocketChannelFail"), (Throwable)ioe);
        }
        Future<Void> fConnect = socketChannel.connect(sa);
        if (secure) {
            SSLEngine sslEngine = this.createSSLEngine(clientEndpointConfiguration.getUserProperties());
            channel = new AsyncChannelWrapperSecure(socketChannel, sslEngine);
        } else {
            channel = new AsyncChannelWrapperNonSecure(socketChannel);
        }
        long timeout = 5000L;
        String timeoutValue = (String)clientEndpointConfiguration.getUserProperties().get(IO_TIMEOUT_MS_PROPERTY);
        if (timeoutValue != null) {
            timeout = Long.valueOf(timeoutValue).intValue();
        }
        boolean success = false;
        try {
            fConnect.get(timeout, TimeUnit.MILLISECONDS);
            Future<Void> fHandshake = channel.handshake();
            fHandshake.get(timeout, TimeUnit.MILLISECONDS);
            int toWrite = request.limit();
            Future<Integer> fWrite = channel.write(request);
            Integer thisWrite = fWrite.get(timeout, TimeUnit.MILLISECONDS);
            toWrite -= thisWrite.intValue();
            while (toWrite > 0) {
                fWrite = channel.write(request);
                thisWrite = fWrite.get(timeout, TimeUnit.MILLISECONDS);
                toWrite -= thisWrite.intValue();
            }
            response = ByteBuffer.allocate(this.maxBinaryMessageBufferSize);
            HandshakeResponse handshakeResponse = this.processResponse(response, channel, timeout);
            clientEndpointConfiguration.getConfigurator().afterResponse(handshakeResponse);
            List values = (List)handshakeResponse.getHeaders().get(Constants.WS_PROTOCOL_HEADER_NAME_LOWER);
            if (values == null || values.size() == 0) {
                subProtocol = null;
            } else {
                if (values.size() != 1) throw new DeploymentException(sm.getString("Sec-WebSocket-Protocol"));
                subProtocol = (String)values.get(0);
            }
            success = true;
        }
        catch (ExecutionException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), (Throwable)e);
        }
        catch (SSLException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), (Throwable)e);
        }
        catch (EOFException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), (Throwable)e);
        }
        finally {
            if (!success) {
                channel.close();
            }
        }
        WsRemoteEndpointImplClient wsRemoteEndpointClient = new WsRemoteEndpointImplClient(channel);
        WsSession wsSession = new WsSession(endpoint, wsRemoteEndpointClient, this, null, null, null, null, null, Collections.<Extension>emptyList(), subProtocol, Collections.<String, String>emptyMap(), secure, (EndpointConfig)clientEndpointConfiguration);
        WsFrameClient wsFrameClient = new WsFrameClient(response, channel, wsSession);
        wsRemoteEndpointClient.setTransformation(wsFrameClient.getTransformation());
        endpoint.onOpen((Session)wsSession, (EndpointConfig)clientEndpointConfiguration);
        this.registerSession(endpoint, wsSession);
        wsFrameClient.startInputProcessing();
        return wsSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSession(Endpoint endpoint, WsSession wsSession) {
        Class<?> endpointClazz = endpoint.getClass();
        if (!wsSession.isOpen()) {
            return;
        }
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> wsSessions;
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().register(this);
            }
            if ((wsSessions = this.endpointSessionMap.get(endpointClazz)) == null) {
                wsSessions = new HashSet<WsSession>();
                this.endpointSessionMap.put(endpointClazz, wsSessions);
            }
            wsSessions.add(wsSession);
        }
        this.sessions.put(wsSession, wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSession(Endpoint endpoint, WsSession wsSession) {
        Class<?> endpointClazz = endpoint.getClass();
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> wsSessions = this.endpointSessionMap.get(endpointClazz);
            if (wsSessions != null) {
                wsSessions.remove(wsSession);
                if (wsSessions.size() == 0) {
                    this.endpointSessionMap.remove(endpointClazz);
                }
            }
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().unregister(this);
            }
        }
        this.sessions.remove(wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Session> getOpenSessions(Class<?> endpoint) {
        HashSet<Session> result = new HashSet<Session>();
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> sessions = this.endpointSessionMap.get(endpoint);
            if (sessions != null) {
                result.addAll(sessions);
            }
        }
        return result;
    }

    private Map<String, List<String>> createRequestHeaders(String host, int port, List<String> subProtocols, List<Extension> extensions) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        ArrayList<String> hostValues = new ArrayList<String>(1);
        if (port == -1) {
            hostValues.add(host);
        } else {
            hostValues.add(host + ':' + port);
        }
        headers.put("Host", hostValues);
        ArrayList<String> upgradeValues = new ArrayList<String>(1);
        upgradeValues.add("websocket");
        headers.put("Upgrade", upgradeValues);
        ArrayList<String> connectionValues = new ArrayList<String>(1);
        connectionValues.add("upgrade");
        headers.put("Connection", connectionValues);
        ArrayList<String> wsVersionValues = new ArrayList<String>(1);
        wsVersionValues.add("13");
        headers.put("Sec-WebSocket-Version", wsVersionValues);
        ArrayList<String> wsKeyValues = new ArrayList<String>(1);
        wsKeyValues.add(this.generateWsKeyValue());
        headers.put("Sec-WebSocket-Key", wsKeyValues);
        if (subProtocols != null && subProtocols.size() > 0) {
            headers.put("Sec-WebSocket-Protocol", subProtocols);
        }
        if (extensions != null && extensions.size() > 0) {
            headers.put("Sec-WebSocket-Extensions", this.generateExtensionHeaders(extensions));
        }
        return headers;
    }

    private List<String> generateExtensionHeaders(List<Extension> extensions) {
        ArrayList<String> result = new ArrayList<String>(extensions.size());
        for (Extension extension : extensions) {
            StringBuilder header = new StringBuilder();
            header.append(extension.getName());
            for (Extension.Parameter param : extension.getParameters()) {
                header.append(';');
                header.append(param.getName());
                String value = param.getValue();
                if (value == null || value.length() <= 0) continue;
                header.append('=');
                header.append(value);
            }
        }
        return result;
    }

    private String generateWsKeyValue() {
        byte[] keyBytes = new byte[16];
        random.nextBytes(keyBytes);
        return Base64.encodeBase64String((byte[])keyBytes);
    }

    private ByteBuffer createRequest(URI uri, Map<String, List<String>> reqHeaders) {
        ByteBuffer result = ByteBuffer.allocate(4096);
        result.put("GET ".getBytes(StandardCharsets.ISO_8859_1));
        result.put(uri.getRawPath().getBytes(StandardCharsets.ISO_8859_1));
        String query = uri.getRawQuery();
        if (query != null) {
            result.put((byte)63);
            result.put(query.getBytes(StandardCharsets.ISO_8859_1));
        }
        result.put(" HTTP/1.1\r\n".getBytes(StandardCharsets.ISO_8859_1));
        for (Map.Entry<String, List<String>> entry : reqHeaders.entrySet()) {
            this.addHeader(result, entry.getKey(), entry.getValue());
        }
        result.put(crlf);
        result.flip();
        return result;
    }

    private void addHeader(ByteBuffer result, String key, List<String> values) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = values.iterator();
        if (!iter.hasNext()) {
            return;
        }
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(',');
            sb.append(iter.next());
        }
        result.put(key.getBytes(StandardCharsets.ISO_8859_1));
        result.put(": ".getBytes(StandardCharsets.ISO_8859_1));
        result.put(sb.toString().getBytes(StandardCharsets.ISO_8859_1));
        result.put(crlf);
    }

    private HandshakeResponse processResponse(ByteBuffer response, AsyncChannelWrapper channel, long timeout) throws InterruptedException, ExecutionException, DeploymentException, EOFException, TimeoutException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        boolean readStatus = false;
        boolean readHeaders = false;
        String line = null;
        while (!readHeaders) {
            Future<Integer> read = channel.read(response);
            Integer bytesRead = read.get(timeout, TimeUnit.MILLISECONDS);
            if (bytesRead == -1) {
                throw new EOFException();
            }
            response.flip();
            while (response.hasRemaining() && !readHeaders) {
                if ("\r\n".equals(line = line == null ? this.readLine(response) : line + this.readLine(response))) {
                    readHeaders = true;
                    continue;
                }
                if (!line.endsWith("\r\n")) continue;
                if (readStatus) {
                    this.parseHeaders(line, headers);
                } else {
                    this.parseStatus(line);
                    readStatus = true;
                }
                line = null;
            }
        }
        return new WsHandshakeResponse(headers);
    }

    private void parseStatus(String line) throws DeploymentException {
        if (!line.startsWith("HTTP/1.1 101")) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{line}));
        }
    }

    private void parseHeaders(String line, Map<String, List<String>> headers) {
        int index = line.indexOf(58);
        if (index == -1) {
            this.log.warn((Object)sm.getString("wsWebSocketContainer.invalidHeader", new Object[]{line}));
            return;
        }
        String headerName = line.substring(0, index).trim().toLowerCase();
        String headerValue = line.substring(index + 1).trim();
        List<String> values = headers.get(headerName);
        if (values == null) {
            values = new ArrayList<String>(1);
            headers.put(headerName, values);
        }
        values.add(headerValue);
    }

    private String readLine(ByteBuffer response) {
        StringBuilder sb = new StringBuilder();
        char c = '\u0000';
        while (response.hasRemaining()) {
            c = (char)response.get();
            sb.append(c);
            if (c != '\n') continue;
            break;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngine createSSLEngine(Map<String, Object> userProperties) throws DeploymentException {
        try {
            SSLContext sslContext = (SSLContext)userProperties.get(SSL_CONTEXT_PROPERTY);
            if (sslContext == null) {
                sslContext = SSLContext.getInstance("TLS");
                String sslTrustStoreValue = (String)userProperties.get(SSL_TRUSTSTORE_PROPERTY);
                if (sslTrustStoreValue != null) {
                    String sslTrustStorePwdValue = (String)userProperties.get(SSL_TRUSTSTORE_PWD_PROPERTY);
                    if (sslTrustStorePwdValue == null) {
                        sslTrustStorePwdValue = SSL_TRUSTSTORE_PWD_DEFAULT;
                    }
                    File keyStoreFile = new File(sslTrustStoreValue);
                    KeyStore ks = KeyStore.getInstance("JKS");
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(keyStoreFile);
                        ks.load(is, sslTrustStorePwdValue.toCharArray());
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    sslContext.init(null, tmf.getTrustManagers(), null);
                } else {
                    sslContext.init(null, null, null);
                }
            }
            SSLEngine engine = sslContext.createSSLEngine();
            String sslProtocolsValue = (String)userProperties.get(SSL_PROTOCOLS_PROPERTY);
            if (sslProtocolsValue != null) {
                engine.setEnabledProtocols(sslProtocolsValue.split(","));
            }
            engine.setUseClientMode(true);
            return engine;
        }
        catch (Exception e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.sslEngineFail"), (Throwable)e);
        }
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncTimeout;
    }

    public void setAsyncSendTimeout(long timeout) {
        this.defaultAsyncTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        CloseReason cr = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsWebSocketContainer.shutdown"));
        for (WsSession session : this.sessions.keySet()) {
            try {
                session.close(cr);
            }
            catch (IOException ioe) {
                this.log.debug((Object)sm.getString("wsWebSocketContainer.sessionCloseFail", new Object[]{session.getId()}), (Throwable)ioe);
            }
        }
        if (this.asynchronousChannelGroup != null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup != null) {
                    AsyncChannelGroupUtil.unregister();
                    this.asynchronousChannelGroup = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsynchronousChannelGroup getAsynchronousChannelGroup() {
        AsynchronousChannelGroup result = this.asynchronousChannelGroup;
        if (result == null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup == null) {
                    this.asynchronousChannelGroup = AsyncChannelGroupUtil.register();
                }
                result = this.asynchronousChannelGroup;
            }
        }
        return result;
    }

    @Override
    public void backgroundProcess() {
        ++this.backgroundProcessCount;
        if (this.backgroundProcessCount >= this.processPeriod) {
            this.backgroundProcessCount = 0;
            for (WsSession wsSession : this.sessions.keySet()) {
                wsSession.checkExpiration();
            }
        }
    }

    @Override
    public void setProcessPeriod(int period) {
        this.processPeriod = period;
    }

    @Override
    public int getProcessPeriod() {
        return this.processPeriod;
    }
}

