/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.iteration;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.sqlite.SQLiteDatabase;
import org.eclipse.hawk.sqlite.SQLiteNode;
import org.eclipse.hawk.sqlite.iteration.ResultSetIterator;
import org.eclipse.hawk.sqlite.iteration.StatementSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementGraphNodeIterable
implements IGraphIterable<IGraphNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementGraphNodeIterable.class);
    private final SQLiteDatabase db;
    private final StatementSupplier stmtIterator;
    private final StatementSupplier stmtSize;
    private final StatementSupplier stmtSingle;

    public StatementGraphNodeIterable(SQLiteDatabase db, StatementSupplier stmtIterator, StatementSupplier stmtSize, StatementSupplier stmtSingle) {
        this.db = db;
        this.stmtIterator = stmtIterator;
        this.stmtSize = stmtSize;
        this.stmtSingle = stmtSingle;
    }

    public Iterator<IGraphNode> iterator() {
        try {
            PreparedStatement stmt = this.stmtIterator.get();
            stmt.execute();
            return new ResultSetIterator<IGraphNode>(stmt.getResultSet(), this::getNodeFromResultSet);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }

    public int size() {
        try {
            PreparedStatement stmt = this.stmtSize.get();
            stmt.execute();
            Throwable throwable = null;
            Object var3_5 = null;
            try (ResultSet rs = stmt.getResultSet();){
                rs.next();
                return rs.getInt(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public IGraphNode getSingle() {
        try {
            PreparedStatement stmt = this.stmtSingle.get();
            stmt.execute();
            Throwable throwable = null;
            Object var3_5 = null;
            try (ResultSet rs = stmt.getResultSet();){
                if (rs.next()) {
                    return new SQLiteNode(this.db, rs.getInt(1));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        throw new NoSuchElementException();
    }

    private SQLiteNode getNodeFromResultSet(ResultSet rs) throws SQLException {
        int nodeId = rs.getInt(1);
        return new SQLiteNode(this.db, nodeId);
    }
}

