/*******************************************************************************
 * Copyright (c) 2004-2008 Gabor Bergmann and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabor Bergmann - initial API and implementation
 *******************************************************************************/

package org.eclipse.incquery.runtime.rete.network;

import java.util.List;

/**
 * A node of a rete network, should be uniquely identified by network and nodeId. NodeId can be requested by registering
 * at the Network on construction.
 * 
 * @author Gabor Bergmann
 */
public interface Node {
    /**
     * @return the network this node belongs to.
     */
    ReteContainer getContainer();

    /**
     * @return the identifier unique to this node within the network.
     */
    long getNodeId();

    /**
     * Assigns a descriptive tag to the node
     */
    void setTag(Object tag);

    /**
     * @return the tag of the node
     */
    Object getTag();
    
    /**
     * @return unmodifiable view of the list of traceability infos assigned to this node
     */
    List<TraceInfo> getTraceInfos();
    
    /**
     * assigns new traceability info to this node
     */
    void assignTraceInfo(TraceInfo traceInfo);
    /**
     * accepts traceability info propagated to this node
     */
    void acceptPropagatedTraceInfo(TraceInfo traceInfo);
    
    
    /**
     * Traces the node back to a purpose for which the node was built.
     * @author Bergmann Gabor
     */
    public static interface TraceInfo {
    	boolean propagateToIndexerParent();
    	boolean propagateFromIndexerToSupplierParent();
    	boolean propagateFromStandardNodeToSupplierParent();  	
    	boolean propagateToProductionNodeParentAlso();
    	
    	/**
    	 * One kind of trace marker that merely establishes the pattern for which the node was built.
    	 * @author Bergmann Gabor
    	 */
    	public static interface PatternTraceInfo extends TraceInfo {
    		String getPatternName();		
    	}
    }
    // /**
    // * The semantics of the tuples contained in this node.
    // * @return a tuple of correct size representing the semantics of each position.
    // * @post not null
    // */
    // Tuple getSemantics();

}
